/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package com.atlassian.bamboo.specs.api.model.pbc;

import com.atlassian.bamboo.specs.api.builders.pbc.EnvVar;
import com.atlassian.bamboo.specs.api.codegen.annotations.Builder;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;

@Builder(EnvVar.class)
public class EnvProperties implements EntityProperties {
    public static final ValidationContext VALIDATION_CONTEXT =
            ValidationContext.of("Per-Build Container (PBC) Extra Container Env Variable");

    private final String key;
    private final String value;

    public EnvProperties() {
        key = null;
        value = null;
    }

    public EnvProperties(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotBlank(VALIDATION_CONTEXT, "key", key);
        ImporterUtils.checkNotBlank(VALIDATION_CONTEXT, "value", value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final EnvProperties other = (EnvProperties) obj;
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        return true;
    }
}
