package com.atlassian.bamboo.specs.codegen.emitters.pbc;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.deployment.configuration.AnyPluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.pbc.PerBuildContainerForEnvironment;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.AllOtherPluginsConfiguration;
import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.pbc.AtlassianModulePBC;
import com.atlassian.bamboo.specs.api.model.pbc.PerBuildContainerForEnvironmentProperties;
import com.atlassian.bamboo.specs.util.MapBuilder;
import org.jetbrains.annotations.NotNull;

public class PerBuildContainerForEnvironmentEmitter implements CodeEmitter<PerBuildContainerForEnvironmentProperties> {

    @NotNull
    @Override
    public String emitCode(
            @NotNull final CodeGenerationContext context,
            @NotNull final PerBuildContainerForEnvironmentProperties entity)
            throws CodeGenerationException {
        context.importClassName(AllOtherPluginsConfiguration.class);
        StringBuilder sb = new StringBuilder();
        sb.append(context.newLine());
        sb.append("/* Add com.atlassian.buildeng:bamboo-pbc-specs:")
                .append(EmitterUtils.version())
                .append(" as dependency to your specs pom.xml to make use of this custom entity.");
        sb.append(context.newLine());

        sb.append(context.newLine());
        appendDslClass(sb, entity, context);
        context.importClassName(AnyPluginConfiguration.class);
        context.importClassName(MapBuilder.class);
        context.importClassName(AtlassianModule.class);
        sb.append("new ")
                .append(AnyPluginConfiguration.class.getSimpleName())
                .append("(new AtlassianModule(\"")
                .append(AtlassianModulePBC.ENVIRONMENT.moduleKey())
                .append("\"))");
        context.incIndentation();
        sb.append(context.newLine()).append(".configuration(new MapBuilder()");
        context.incIndentation();
        sb.append(context.newLine())
                .append(".put(\"custom.isolated.docker.enabled\", \"")
                .append(entity.isEnabled())
                .append("\")");
        sb.append(context.newLine())
                .append(".put(\"custom.isolated.docker.image\", \"")
                .append(entity.getImage())
                .append("\")");
        sb.append(context.newLine())
                .append(".put(\"custom.isolated.docker.imageSize\", \"")
                .append(entity.getSize())
                .append("\")");
        if (entity.getAwsRole() != null) {
            sb.append(context.newLine())
                    .append(".put(\"custom.isolated.docker.awsRole\", \"")
                    .append(entity.getAwsRole())
                    .append("\")");
        }
        if (entity.getArchitecture() != null) {
            sb.append(context.newLine())
                    .append(".put(\"custom.isolated.docker.architecture\", \"")
                    .append(entity.getArchitecture())
                    .append("\")");
        }
        if (!entity.getExtraContainers().isEmpty()) {
            sb.append(context.newLine())
                    .append(".put(\"custom.isolated.docker.extraContainers\", \"")
                    .append(EmitterUtils.toJson(entity.getExtraContainers()))
                    .append("\")");
        }
        if (!entity.getFeatureFlags().isEmpty()) {
            sb.append(context.newLine())
                    .append(".put(\"custom.isolated.docker.featureFlags\", \"")
                    .append(EmitterUtils.toJson(entity.getFeatureFlags()))
                    .append("\")");
        }
        sb.append(context.newLine()).append(".build())");
        context.decIndentation();
        context.decIndentation();
        return sb.toString();
    }

    private void appendDslClass(
            StringBuilder sb, PerBuildContainerForEnvironmentProperties entity, CodeGenerationContext context) {
        sb.append("new ")
                .append(PerBuildContainerForEnvironment.class.getSimpleName())
                .append("()");
        dslParams(context, sb, entity);
    }

    private void dslParams(
            CodeGenerationContext context, StringBuilder sb, PerBuildContainerForEnvironmentProperties entity) {
        context.incIndentation();
        if (!entity.isEnabled()) {
            sb.append(context.newLine())
                    .append(".enabled(")
                    .append(entity.isEnabled())
                    .append(")");
        }
        sb.append(context.newLine())
                .append(".image(\"")
                .append(entity.getImage())
                .append("\")");
        sb.append(context.newLine())
                .append(".size(")
                .append(EmitterUtils.generateSizeEnumOrString(entity.getSize()))
                .append(")");
        if (entity.getAwsRole() != null) {
            sb.append(context.newLine())
                    .append(".awsRole(\"")
                    .append(entity.getAwsRole())
                    .append("\")");
        }
        if (entity.getArchitecture() != null) {
            sb.append(context.newLine())
                    .append(".architecture(")
                    .append(EmitterUtils.generateArchitectureEnumOrString(entity.getArchitecture()))
                    .append(")");
        }
        EmitterUtils.generateExtraContainerBuilder(entity.getExtraContainers(), sb, context);
        context.decIndentation();
        sb.append(" */").append(context.newLine());
    }
}
