/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.pbc.Architecture;
import com.atlassian.bamboo.specs.api.builders.pbc.ContainerSize;
import com.atlassian.bamboo.specs.api.builders.pbc.ExtraContainer;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import com.atlassian.bamboo.specs.api.model.pbc.PerBuildContainerForJobProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class PerBuildContainerForJob
extends PluginConfiguration<PerBuildContainerForJobProperties> {
    private String image;
    private boolean enabled = true;
    private String size = ContainerSize.REGULAR.name();
    private String awsRole;
    private String architecture;
    private List<ExtraContainerProperties> extraContainers = new ArrayList<ExtraContainerProperties>();
    private HashSet<String> featureFlags = new HashSet();

    public PerBuildContainerForJob enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PerBuildContainerForJob image(String image) {
        this.image = image;
        return this;
    }

    public PerBuildContainerForJob withFeatureFlag(String featureFlag) {
        this.featureFlags.add(featureFlag);
        return this;
    }

    public PerBuildContainerForJob withFeatureFlags(HashSet<String> featureFlags) {
        this.featureFlags.addAll(featureFlags);
        return this;
    }

    public PerBuildContainerForJob size(String size) {
        this.size = size;
        return this;
    }

    public PerBuildContainerForJob size(ContainerSize size) {
        this.size = size != null ? size.name() : null;
        return this;
    }

    public PerBuildContainerForJob awsRole(String awsRole) {
        this.awsRole = awsRole;
        return this;
    }

    public PerBuildContainerForJob architecture(Architecture architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    @Deprecated
    public PerBuildContainerForJob architecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public PerBuildContainerForJob extraContainers(ExtraContainer ... extraContainers) {
        this.extraContainers(Arrays.asList(extraContainers));
        return this;
    }

    public PerBuildContainerForJob extraContainers(List<ExtraContainer> extraContainers) {
        extraContainers.stream().map(ExtraContainer::build).forEach(this.extraContainers::add);
        return this;
    }

    protected PerBuildContainerForJobProperties build() {
        return new PerBuildContainerForJobProperties(this.enabled, this.image, this.size, this.extraContainers, this.awsRole, this.architecture, this.featureFlags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PerBuildContainerForJob that = (PerBuildContainerForJob)((Object)o);
        return this.enabled == that.enabled && Objects.equals(this.image, that.image) && Objects.equals(this.size, that.size) && Objects.equals(this.awsRole, that.awsRole) && Objects.equals(this.architecture, that.architecture) && this.extraContainersEqual(this.extraContainers, that.extraContainers) && Objects.equals(this.featureFlags, that.featureFlags);
    }

    private boolean extraContainersEqual(List<ExtraContainerProperties> thisContainers, List<ExtraContainerProperties> thatContainers) {
        if (thisContainers == thatContainers) {
            return true;
        }
        if (thisContainers.size() != thatContainers.size()) {
            return false;
        }
        for (ExtraContainerProperties thisContainer : thisContainers) {
            if (!this.isExtraContainerNotIn(thisContainer, thatContainers)) continue;
            return false;
        }
        for (ExtraContainerProperties container : thatContainers) {
            if (!this.isExtraContainerNotIn(container, thisContainers)) continue;
            return false;
        }
        return true;
    }

    private boolean isExtraContainerNotIn(ExtraContainerProperties container, List<ExtraContainerProperties> otherContainers) {
        for (ExtraContainerProperties other : otherContainers) {
            if (!Objects.equals(container, other)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.image, this.enabled, this.size, this.awsRole, this.architecture, this.extraContainers, this.featureFlags);
    }
}

