/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.pbc;

import com.atlassian.bamboo.specs.api.builders.pbc.ExtraContainer;
import com.atlassian.bamboo.specs.api.builders.pbc.ExtraContainerSize;
import com.atlassian.bamboo.specs.api.codegen.annotations.Builder;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.pbc.EnvProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@Builder(value=ExtraContainer.class)
public class ExtraContainerProperties
implements EntityProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Per-Build Container (PBC) Extra Container");
    private List<String> commands = new ArrayList<String>();
    private String size;
    private List<EnvProperties> environments = new ArrayList<EnvProperties>();
    private String image;
    private String name;

    public ExtraContainerProperties() {
    }

    public ExtraContainerProperties(String name, String image, String size, List<EnvProperties> environments, List<String> commands) {
        this.size = size != null ? size.toUpperCase(Locale.ENGLISH) : null;
        this.environments = environments;
        this.commands = commands;
        this.image = image;
        this.name = name;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getSize() {
        return this.size;
    }

    public List<EnvProperties> getEnvironments() {
        return this.environments;
    }

    public String getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public void validate() {
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"name", (String)this.name);
        ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (this.name != null && this.name.matches("[a-z0-9]([\\-a-z0-9]*[a-z0-9])?") ? 1 : 0) != 0, (Object)"Extra container name should be composed of lowercase letters, numbers and - character only");
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"image", (String)this.image);
        ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (this.image != null && StringUtils.deleteWhitespace((String)this.image).equals(this.image) ? 1 : 0) != 0, (Object)("Argument 'image' cannot contain whitespace.('" + this.image + "')."));
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"size", (String)this.size);
        ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (boolean)Stream.of(ExtraContainerSize.values()).anyMatch(t -> t.name().equals(this.size)), (Object)("Extra Container size is to be one of " + Arrays.toString((Object[])ExtraContainerSize.values())));
        ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"commands", this.commands);
        if (this.commands != null) {
            this.commands.forEach(t -> ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)("command '" + t + "'"), (String)t));
        }
        ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"envVariables", this.environments);
        if (this.environments != null) {
            this.environments.forEach(t -> t.validate());
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.image, this.environments, this.size, this.commands);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtraContainerProperties other = (ExtraContainerProperties)obj;
        return Objects.equals(this.size, other.size) && Objects.equals(this.image, other.image) && Objects.equals(this.name, other.name) && Objects.equals(this.commands, other.commands) && Objects.equals(this.environments, other.environments);
    }
}

