/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.util.Util;
import graphql.schema.GraphQLOutputType;
import java.util.UUID;

@Internal
public class ArtificialFieldUtils {
    private static final String UNDERSCORE_TYPENAME = Introspection.TypeNameMetaFieldDef.getName();
    private static final String TYPE_NAME_ALIAS_PREFIX_FOR_EMPTY_SELECTION_SETS = "empty_selection_set_";
    public static final String TYPE_NAME_ALIAS_PREFIX_FOR_INTERFACES_AND_UNIONS = "type_hint_";

    public static Field maybeAddUnderscoreTypeName(NadelContext nadelContext, Field field, GraphQLOutputType fieldType) {
        if (Util.isInterfaceOrUnionField((GraphQLOutputType)fieldType)) {
            return ArtificialFieldUtils.addUnderscoreTypeName(field, nadelContext, TYPE_NAME_ALIAS_PREFIX_FOR_INTERFACES_AND_UNIONS);
        }
        return field;
    }

    public static Field maybeAddEmptySelectionSetUnderscoreTypeName(NadelContext nadelContext, Field field, GraphQLOutputType fieldType) {
        boolean selectionSetIsEmpty;
        if (Util.isScalar((GraphQLOutputType)fieldType)) {
            return field;
        }
        boolean bl = selectionSetIsEmpty = field.getSelectionSet() == null || field.getSelectionSet().getSelections().isEmpty();
        if (selectionSetIsEmpty) {
            return ArtificialFieldUtils.addUnderscoreTypeName(field, nadelContext, TYPE_NAME_ALIAS_PREFIX_FOR_EMPTY_SELECTION_SETS);
        }
        return field;
    }

    private static Field addUnderscoreTypeName(Field field, NadelContext nadelContext, String aliasPrefix) {
        String typeNameAliasFromContext = ArtificialFieldUtils.getTypeNameAliasFromContext(nadelContext);
        SelectionSet selectionSet = field.getSelectionSet();
        if (selectionSet != null) {
            for (Field fld : selectionSet.getSelectionsOfType(Field.class)) {
                if (!(TYPE_NAME_ALIAS_PREFIX_FOR_INTERFACES_AND_UNIONS + typeNameAliasFromContext).equals(fld.getAlias()) && !(TYPE_NAME_ALIAS_PREFIX_FOR_EMPTY_SELECTION_SETS + typeNameAliasFromContext).equals(fld.getAlias())) continue;
                return field;
            }
        }
        Field underscoreTypeNameAliasField = Field.newField((String)UNDERSCORE_TYPENAME).alias(aliasPrefix + typeNameAliasFromContext).additionalData("id", UUID.randomUUID().toString()).build();
        selectionSet = selectionSet == null ? SelectionSet.newSelectionSet().selection((Selection)underscoreTypeNameAliasField).build() : selectionSet.transform(builder -> builder.selection((Selection)underscoreTypeNameAliasField));
        SelectionSet newSelectionSet = selectionSet;
        field = field.transform(builder -> builder.selectionSet(newSelectionSet));
        return field;
    }

    private static String getTypeNameAliasFromContext(NadelContext nadelContext) {
        String underscoreTypeNameAlias = nadelContext.getUnderscoreTypeNameAlias();
        Assert.assertNotNull((Object)underscoreTypeNameAlias, () -> "We MUST have a generated __typename alias in the request context");
        return underscoreTypeNameAlias;
    }

    public static Field addObjectIdentifier(NadelContext nadelContext, Field field, String objectIdentifier) {
        Field idField = Field.newField().additionalData("id", UUID.randomUUID().toString()).alias(nadelContext.getObjectIdentifierAlias()).name(objectIdentifier).build();
        SelectionSet selectionSet = field.getSelectionSet().transform(builder -> builder.selection((Selection)idField));
        return field.transform(builder -> builder.selectionSet(selectionSet));
    }

    public static boolean isArtificialField(NadelContext nadelContext, String alias) {
        String typeNameAlias = nadelContext.getUnderscoreTypeNameAlias();
        return (TYPE_NAME_ALIAS_PREFIX_FOR_INTERFACES_AND_UNIONS + typeNameAlias).equals(alias) || (TYPE_NAME_ALIAS_PREFIX_FOR_EMPTY_SELECTION_SETS + typeNameAlias).equals(alias) || nadelContext.getObjectIdentifierAlias().equals(alias);
    }
}

