/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.MergedField;
import graphql.language.AstNodeAdapter;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.nadel.OperationKind;
import graphql.nadel.Service;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.dsl.TypeMappingDefinition;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.engine.execution.ArtificialFieldUtils;
import graphql.nadel.engine.execution.AsyncIsFieldForbidden;
import graphql.nadel.engine.execution.QueryTransformationResult;
import graphql.nadel.engine.execution.TransformationState;
import graphql.nadel.engine.execution.Transformer;
import graphql.nadel.engine.execution.UnderlyingTypeContext;
import graphql.nadel.engine.execution.transformation.OverallTypeInfo;
import graphql.nadel.engine.execution.transformation.OverallTypeInformation;
import graphql.nadel.engine.execution.transformation.RecordOverallTypeInformation;
import graphql.nadel.engine.execution.transformation.TransformationMetadata;
import graphql.nadel.hooks.HydrationArguments;
import graphql.nadel.hooks.ServiceExecutionHooks;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.nadel.util.FpKit;
import graphql.nadel.util.Util;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.idl.TypeInfo;
import graphql.util.NodeAdapter;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import graphql.util.TraverserVisitorStub;
import graphql.util.TreeTransformer;
import graphql.util.TreeTransformerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class OverallQueryTransformer {
    private static final Logger log = LoggerFactory.getLogger(OverallQueryTransformer.class);
    private final RecordOverallTypeInformation recordOverallTypeInformation = new RecordOverallTypeInformation();

    CompletableFuture<QueryTransformationResult> transformHydratedTopLevelField(ExecutionContext executionContext, GraphQLSchema underlyingSchema, String operationName, OperationKind operationKind, Field rootField, GraphQLCompositeType topLevelFieldTypeOverall, ServiceExecutionHooks serviceExecutionHooks, Service service, Object serviceContext, boolean isSynthetic) {
        long startTime = System.currentTimeMillis();
        LinkedHashSet<String> referencedFragmentNames = new LinkedHashSet<String>();
        LinkedHashMap<String, Object> variableValues = new LinkedHashMap<String, Object>(executionContext.getVariables());
        TransformationMetadata removedFieldMap = new TransformationMetadata();
        TransformationState transformations = new TransformationState();
        NadelContext nadelContext = (NadelContext)executionContext.getContext();
        SelectionSet selectionSet = rootField.getSelectionSet();
        Field topLevelField = rootField;
        if (isSynthetic) {
            topLevelField = (Field)selectionSet.getSelections().get(0);
            selectionSet = topLevelField.getSelectionSet();
        }
        HydrationArguments hydrationArguments = OverallQueryTransformer.getHydrationArguments(executionContext, operationKind, rootField, topLevelField, isSynthetic);
        Map variableDefinitionMap = FpKit.getByName((List)executionContext.getOperationDefinition().getVariableDefinitions(), VariableDefinition::getName);
        Map<String, VariableDefinition> referencedVariables = OverallQueryTransformer.collectReferencedVariables(topLevelField, variableDefinitionMap);
        CompletableFuture<SelectionSet> topLevelFieldSelectionSetCF = this.transformNode(executionContext, underlyingSchema, selectionSet, topLevelFieldTypeOverall, referencedFragmentNames, referencedVariables, nadelContext, serviceExecutionHooks, variableValues, service, serviceContext, removedFieldMap, transformations, hydrationArguments);
        Field finalTopLevelField = topLevelField;
        return topLevelFieldSelectionSetCF.thenCompose(topLevelFieldSelectionSet -> {
            Field transformedRootField = finalTopLevelField.transform(builder -> builder.selectionSet(topLevelFieldSelectionSet));
            Field maybeTransformedRootField = ArtificialFieldUtils.maybeAddUnderscoreTypeName(nadelContext, transformedRootField, (GraphQLOutputType)topLevelFieldTypeOverall);
            if (maybeTransformedRootField != transformedRootField) {
                transformations.addHintTypename(maybeTransformedRootField.getName());
            }
            transformedRootField = maybeTransformedRootField;
            transformedRootField = ArtificialFieldUtils.maybeAddEmptySelectionSetUnderscoreTypeName(nadelContext, transformedRootField, (GraphQLOutputType)topLevelFieldTypeOverall);
            if (isSynthetic) {
                Field tempTransformedRootLevelField = transformedRootField;
                transformedRootField = rootField.transform(builder -> builder.selectionSet(SelectionSet.newSelectionSet().selection((Selection)tempTransformedRootLevelField).build()));
            }
            Map<String, VariableDefinition> referencedVariablesForTransformedField = OverallQueryTransformer.collectReferencedVariables(transformedRootField, variableDefinitionMap);
            List<VariableDefinition> variableDefinitions = this.buildReferencedVariableDefinitions(referencedVariablesForTransformedField, executionContext.getGraphQLSchema(), transformations.getTypeRenameMappings());
            ArrayList<String> referencedVariableNames = new ArrayList<String>(referencedVariablesForTransformedField.keySet());
            CompletableFuture<Map<String, FragmentDefinition>> transformedFragmentsCF = this.transformFragments(executionContext, underlyingSchema, executionContext.getFragmentsByName(), referencedFragmentNames, referencedVariables, serviceExecutionHooks, variableValues, service, serviceContext, removedFieldMap, transformations);
            Field finalTransformedRootField = transformedRootField;
            return transformedFragmentsCF.thenApply(transformedFragments -> {
                SelectionSet newOperationSelectionSet = SelectionSet.newSelectionSet().selection((Selection)finalTransformedRootField).build();
                OperationDefinition operationDefinition = OperationDefinition.newOperationDefinition().name(operationName).operation(operationKind.getAstOperation()).selectionSet(newOperationSelectionSet).variableDefinitions(variableDefinitions).build();
                Document newDocument = this.newDocument(operationDefinition, (Map<String, FragmentDefinition>)transformedFragments);
                MergedField transformedMergedField = MergedField.newMergedField((Field)finalTransformedRootField).build();
                long elapsedTime = System.currentTimeMillis() - startTime;
                log.debug("OverallQueryTransformer.transformHydratedTopLevelField time: {}, executionId: {}", (Object)elapsedTime, (Object)executionContext.getExecutionId());
                return new QueryTransformationResult(newDocument, operationDefinition, Collections.singletonList(transformedMergedField), (List<String>)referencedVariableNames, (Map<String, FragmentDefinition>)transformedFragments, variableValues, removedFieldMap, transformations);
            });
        });
    }

    private static Map<String, VariableDefinition> collectReferencedVariables(Field field, final Map<String, VariableDefinition> variableDefinitionMap) {
        final LinkedHashMap<String, VariableDefinition> referencedVariables = new LinkedHashMap<String, VariableDefinition>();
        NodeVisitorStub collectReferencedVariables = new NodeVisitorStub(){

            public TraversalControl visitVariableReference(VariableReference variableReference, TraverserContext<Node> context) {
                String name = variableReference.getName();
                referencedVariables.put(name, (VariableDefinition)variableDefinitionMap.get(name));
                return super.visitVariableReference(variableReference, context);
            }
        };
        new NodeTraverser().depthFirst((NodeVisitor)collectReferencedVariables, (Node)field);
        return referencedVariables;
    }

    private static HydrationArguments getHydrationArguments(ExecutionContext executionContext, OperationKind operation, Field rootField, Field topLevelField, boolean isSynthetic) {
        List hydrationGqlArguments = isSynthetic ? Optional.ofNullable(operation.getRootType(executionContext.getGraphQLSchema()).getFieldDefinition(rootField.getName())).map(fieldDefinition -> ((GraphQLObjectType)fieldDefinition.getType()).getFieldDefinition(topLevelField.getName())).map(GraphQLFieldDefinition::getArguments).orElse(Collections.emptyList()) : Optional.ofNullable(operation.getRootType(executionContext.getGraphQLSchema()).getFieldDefinition(topLevelField.getName())).map(GraphQLFieldDefinition::getArguments).orElse(Collections.emptyList());
        return new HydrationArguments(hydrationGqlArguments, topLevelField.getArguments());
    }

    CompletableFuture<QueryTransformationResult> transformMergedFields(ExecutionContext executionContext, GraphQLSchema underlyingSchema, String operationName, OperationKind operationKind, List<MergedField> mergedFields, ServiceExecutionHooks serviceExecutionHooks, Service service, Object serviceContext) {
        long startTime = System.currentTimeMillis();
        NadelContext nadelContext = (NadelContext)executionContext.getContext();
        LinkedHashSet fragmentsDirectlyReferenced = new LinkedHashSet();
        LinkedHashMap referencedVariables = new LinkedHashMap();
        LinkedHashMap variableValues = new LinkedHashMap(executionContext.getVariables());
        TransformationMetadata removedFieldMap = new TransformationMetadata();
        TransformationState transformations = new TransformationState();
        ArrayList transformedFieldsCF = new ArrayList();
        for (MergedField mergedField : mergedFields) {
            List fields = mergedField.getFields();
            List transformedCF = FpKit.map((List)fields, field -> {
                GraphQLObjectType rootType = operationKind.getRootType(executionContext.getGraphQLSchema());
                CompletableFuture<Field> newFieldCF = this.transformNode(executionContext, underlyingSchema, field, (GraphQLCompositeType)rootType, fragmentsDirectlyReferenced, referencedVariables, nadelContext, serviceExecutionHooks, variableValues, service, serviceContext, removedFieldMap, transformations, HydrationArguments.empty());
                return newFieldCF.thenApply(newField -> {
                    GraphQLOutputType fieldType;
                    Field maybeNewField;
                    if (newField == null) {
                        newField = field.transform(builder -> builder.selectionSet(SelectionSet.newSelectionSet().build()));
                    }
                    if ((maybeNewField = ArtificialFieldUtils.maybeAddUnderscoreTypeName(nadelContext, newField, fieldType = rootType.getFieldDefinition(field.getName()).getType())) != newField) {
                        transformations.addHintTypename(maybeNewField.getName());
                    }
                    newField = maybeNewField;
                    return newField;
                });
            });
            transformedFieldsCF.addAll(transformedCF);
        }
        return Async.each(transformedFieldsCF).thenCompose(transformedFields -> {
            List<VariableDefinition> variableDefinitions = this.buildReferencedVariableDefinitions(referencedVariables, executionContext.getGraphQLSchema(), transformations.getTypeRenameMappings());
            ArrayList referencedVariableNames = new ArrayList(referencedVariables.keySet());
            SelectionSet newSelectionSet = SelectionSet.newSelectionSet((Collection)transformedFields).build();
            OperationDefinition operationDefinition = OperationDefinition.newOperationDefinition().operation(operationKind.getAstOperation()).name(operationName).selectionSet(newSelectionSet).variableDefinitions(variableDefinitions).build();
            CompletableFuture<Map<String, FragmentDefinition>> transformedFragmentsCF = this.transformFragments(executionContext, underlyingSchema, executionContext.getFragmentsByName(), fragmentsDirectlyReferenced, referencedVariables, serviceExecutionHooks, variableValues, service, serviceContext, removedFieldMap, transformations);
            return transformedFragmentsCF.thenApply(transformedFragments -> {
                Document newDocument = this.newDocument(operationDefinition, (Map<String, FragmentDefinition>)transformedFragments);
                List transformedMergedFields = FpKit.map((List)transformedFields, transformed -> MergedField.newMergedField((Field)transformed).build());
                long elapsedTime = System.currentTimeMillis() - startTime;
                log.debug("OverallQueryTransformer.transformMergedFields time: {}, executionId: {}", (Object)elapsedTime, (Object)executionContext.getExecutionId());
                return new QueryTransformationResult(newDocument, operationDefinition, transformedMergedFields, referencedVariableNames, (Map<String, FragmentDefinition>)transformedFragments, variableValues, removedFieldMap, transformations);
            });
        });
    }

    private Document newDocument(OperationDefinition operationDefinition, Map<String, FragmentDefinition> transformedFragments) {
        Document.Builder newDocumentBuilder = Document.newDocument();
        newDocumentBuilder.definition((Definition)operationDefinition);
        for (FragmentDefinition transformedFragment : transformedFragments.values()) {
            newDocumentBuilder.definition((Definition)transformedFragment);
        }
        return newDocumentBuilder.build();
    }

    private CompletableFuture<Map<String, FragmentDefinition>> transformFragments(ExecutionContext executionContext, GraphQLSchema underlyingSchema, Map<String, FragmentDefinition> fragments, Set<String> referencedFragmentNames, Map<String, VariableDefinition> referencedVariables, ServiceExecutionHooks serviceExecutionHooks, Map<String, Object> variableValues, Service service, Object serviceContext, TransformationMetadata removedFieldMap, TransformationState transformations) {
        Set<String> fragmentsToTransform = Collections.synchronizedSet(new LinkedHashSet<String>(referencedFragmentNames));
        Set<FragmentDefinition> transformedFragmentsInput = Collections.synchronizedSet(new LinkedHashSet());
        return this.transformFragmentImpl(executionContext, underlyingSchema, fragments, referencedVariables, serviceExecutionHooks, variableValues, service, serviceContext, removedFieldMap, fragmentsToTransform, transformedFragmentsInput, transformations).thenApply(transformedFragments -> graphql.util.FpKit.groupingByUniqueKey((Collection)transformedFragmentsInput, FragmentDefinition::getName));
    }

    private CompletableFuture<Set<FragmentDefinition>> transformFragmentImpl(ExecutionContext executionContext, GraphQLSchema underlyingSchema, Map<String, FragmentDefinition> fragments, Map<String, VariableDefinition> referencedVariables, ServiceExecutionHooks serviceExecutionHooks, Map<String, Object> variableValues, Service service, Object serviceContext, TransformationMetadata removedFieldMap, Set<String> fragmentsToTransform, Set<FragmentDefinition> transformedFragments, TransformationState transformations) {
        if (fragmentsToTransform.isEmpty()) {
            return CompletableFuture.completedFuture(transformedFragments);
        }
        String fragmentName = fragmentsToTransform.iterator().next();
        LinkedHashSet<String> newReferencedFragments = new LinkedHashSet<String>();
        CompletableFuture<FragmentDefinition> transformedFragmentCF = this.transformFragmentDefinition(executionContext, underlyingSchema, fragments.get(fragmentName), newReferencedFragments, referencedVariables, serviceExecutionHooks, variableValues, service, serviceContext, removedFieldMap, transformations);
        return transformedFragmentCF.thenCompose(transformedFragment -> {
            fragmentsToTransform.remove(fragmentName);
            transformedFragments.add((FragmentDefinition)transformedFragment);
            fragmentsToTransform.addAll(newReferencedFragments);
            return this.transformFragmentImpl(executionContext, underlyingSchema, fragments, referencedVariables, serviceExecutionHooks, variableValues, service, serviceContext, removedFieldMap, fragmentsToTransform, transformedFragments, transformations);
        });
    }

    private CompletableFuture<FragmentDefinition> transformFragmentDefinition(ExecutionContext executionContext, GraphQLSchema underlyingSchema, FragmentDefinition fragmentDefinitionWithoutTypeInfo, Set<String> referencedFragmentNames, Map<String, VariableDefinition> referencedVariables, ServiceExecutionHooks serviceExecutionHooks, Map<String, Object> variableValues, Service service, Object serviceContext, TransformationMetadata removedFieldMap, TransformationState transformations) {
        NadelContext nadelContext = (NadelContext)executionContext.getContext();
        OverallTypeInformation<FragmentDefinition> overallTypeInformation = this.recordOverallTypeInformation.recordOverallTypes(fragmentDefinitionWithoutTypeInfo, executionContext.getGraphQLSchema(), null);
        AsyncIsFieldForbidden asyncIsFieldForbidden = new AsyncIsFieldForbidden(serviceExecutionHooks, nadelContext, executionContext.getGraphQLSchema(), HydrationArguments.empty(), variableValues);
        return asyncIsFieldForbidden.getForbiddenFields((Node<?>)fragmentDefinitionWithoutTypeInfo).thenApply(forbiddenFields -> {
            final Transformer transformer = new Transformer(executionContext, underlyingSchema, referencedFragmentNames, referencedVariables, nadelContext, serviceExecutionHooks, overallTypeInformation, variableValues, service, serviceContext, removedFieldMap, (Map<NormalizedQueryField, GraphQLError>)forbiddenFields, transformations);
            LinkedHashMap<Class<UnderlyingTypeContext>, UnderlyingTypeContext> rootVars = new LinkedHashMap<Class<UnderlyingTypeContext>, UnderlyingTypeContext>();
            rootVars.put(UnderlyingTypeContext.class, UnderlyingTypeContext.newUnderlyingTypeContext().build());
            TreeTransformer treeTransformer = new TreeTransformer((NodeAdapter)AstNodeAdapter.AST_NODE_ADAPTER);
            Node newNode = (Node)treeTransformer.transform((Object)fragmentDefinitionWithoutTypeInfo, (TraverserVisitor)new TraverserVisitorStub<Node>(){

                public TraversalControl enter(TraverserContext<Node> context) {
                    return ((Node)context.thisNode()).accept(context, (NodeVisitor)transformer);
                }
            }, rootVars);
            return (FragmentDefinition)newNode;
        });
    }

    private List<VariableDefinition> buildReferencedVariableDefinitions(Map<String, VariableDefinition> referencedVariables, GraphQLSchema graphQLSchema, Map<String, String> typeRenameMappings) {
        ArrayList<VariableDefinition> variableDefinitions = new ArrayList<VariableDefinition>();
        for (VariableDefinition vd : referencedVariables.values()) {
            TypeInfo typeInfo = TypeInfo.typeInfo((Type)vd.getType());
            GraphQLType type = graphQLSchema.getType(typeInfo.getName());
            TypeMappingDefinition mappingDefinition = Util.getTypeMappingDefinitionFor((GraphQLType)type);
            if (mappingDefinition != null) {
                typeRenameMappings.put(mappingDefinition.getUnderlyingName(), mappingDefinition.getOverallName());
                String newName = mappingDefinition.getUnderlyingName();
                TypeInfo newTypeInfo = typeInfo.renameAs(newName);
                vd = vd.transform(builder -> builder.type(newTypeInfo.getRawType()));
            }
            variableDefinitions.add(vd);
        }
        return variableDefinitions;
    }

    private <T extends Node> CompletableFuture<T> transformNode(ExecutionContext executionContext, GraphQLSchema underlyingSchema, T nodeWithoutTypeInfo, GraphQLCompositeType parentTypeOverall, Set<String> referencedFragmentNames, Map<String, VariableDefinition> referencedVariables, NadelContext nadelContext, ServiceExecutionHooks serviceExecutionHooks, Map<String, Object> variableValues, Service service, Object serviceContext, TransformationMetadata removedFieldMap, TransformationState transformations, HydrationArguments hydrationArguments) {
        OverallTypeInformation overallTypeInformation = this.recordOverallTypeInformation.recordOverallTypes(nodeWithoutTypeInfo, executionContext.getGraphQLSchema(), (GraphQLOutputType)parentTypeOverall);
        AsyncIsFieldForbidden asyncIsFieldForbidden = new AsyncIsFieldForbidden(serviceExecutionHooks, nadelContext, executionContext.getGraphQLSchema(), hydrationArguments, variableValues);
        return asyncIsFieldForbidden.getForbiddenFields(nodeWithoutTypeInfo).thenApply(forbiddenFields -> {
            final Transformer transformer = new Transformer(executionContext, underlyingSchema, referencedFragmentNames, referencedVariables, nadelContext, serviceExecutionHooks, overallTypeInformation, variableValues, service, serviceContext, removedFieldMap, (Map<NormalizedQueryField, GraphQLError>)forbiddenFields, transformations);
            LinkedHashMap rootVars = new LinkedHashMap();
            String underlyingParentName = this.getUnderlyingTypeNameAndRecordMapping(parentTypeOverall, transformations.getTypeRenameMappings());
            GraphQLOutputType underlyingSchemaParent = (GraphQLOutputType)underlyingSchema.getType(underlyingParentName);
            rootVars.put(UnderlyingTypeContext.class, UnderlyingTypeContext.newUnderlyingTypeContext().outputTypeUnderlying(underlyingSchemaParent).build());
            TreeTransformer treeTransformer = new TreeTransformer((NodeAdapter)AstNodeAdapter.AST_NODE_ADAPTER);
            Node newNode = (Node)treeTransformer.transform((Object)nodeWithoutTypeInfo, (TraverserVisitor)new TraverserVisitorStub<Node>(){

                public TraversalControl enter(TraverserContext<Node> context) {
                    return ((Node)context.thisNode()).accept(context, (NodeVisitor)transformer);
                }
            }, rootVars);
            if (removedFieldMap.hasRemovedFields()) {
                newNode = this.addUnderscoreTypeNameToEmptySelectionSets(nadelContext, overallTypeInformation, rootVars, (TreeTransformer<Node>)treeTransformer, newNode);
            }
            return newNode;
        });
    }

    private Node addUnderscoreTypeNameToEmptySelectionSets(final NadelContext nadelContext, final OverallTypeInformation<?> overallTypeInformation, Map<Class<?>, Object> rootVars, TreeTransformer<Node> treeTransformer, Node field) {
        if (field == null) {
            return null;
        }
        final NodeVisitorStub addDummyFieldToEmptySubSelectsVisitor = new NodeVisitorStub(){

            public TraversalControl visitField(Field node, TraverserContext<Node> context) {
                OverallTypeInfo overallTypeInfo = overallTypeInformation.getOverallTypeInfo(NodeId.getId((Node)node));
                if (overallTypeInfo == null) {
                    return TraversalControl.CONTINUE;
                }
                GraphQLFieldDefinition fieldDefinitionOverall = overallTypeInfo.getFieldDefinition();
                GraphQLNamedOutputType fieldTypeOverall = (GraphQLNamedOutputType)GraphQLTypeUtil.unwrapAll((GraphQLType)fieldDefinitionOverall.getType());
                Field newField = ArtificialFieldUtils.maybeAddEmptySelectionSetUnderscoreTypeName(nadelContext, node, (GraphQLOutputType)fieldTypeOverall);
                if (newField != node) {
                    TreeTransformerUtil.changeNode(context, (Object)newField);
                }
                return TraversalControl.CONTINUE;
            }
        };
        return (Node)treeTransformer.transform((Object)field, (TraverserVisitor)new TraverserVisitorStub<Node>(){

            public TraversalControl enter(TraverserContext<Node> context) {
                return ((Node)context.thisNode()).accept(context, (NodeVisitor)addDummyFieldToEmptySubSelectsVisitor);
            }
        }, rootVars);
    }

    private String getUnderlyingTypeNameAndRecordMapping(GraphQLCompositeType typeOverall, Map<String, String> typeRenameMappings) {
        TypeMappingDefinition mappingDefinition = Util.getTypeMappingDefinitionFor((GraphQLType)typeOverall);
        if (mappingDefinition == null) {
            return typeOverall.getName();
        }
        typeRenameMappings.put(mappingDefinition.getUnderlyingName(), mappingDefinition.getOverallName());
        return mappingDefinition.getUnderlyingName();
    }
}

