/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Scalars;
import graphql.SerializationError;
import graphql.TypeMismatchError;
import graphql.execution.ExecutionContext;
import graphql.execution.ResultPath;
import graphql.nadel.ServiceExecutionResult;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.engine.result.ElapsedTime;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.LeafExecutionResultNode;
import graphql.nadel.engine.result.ListExecutionResultNode;
import graphql.nadel.engine.result.NonNullableFieldWasNullError;
import graphql.nadel.engine.result.ObjectExecutionResultNode;
import graphql.nadel.engine.result.RootExecutionResultNode;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.nadel.normalized.NormalizedQueryFromAst;
import graphql.nadel.util.ErrorUtil;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResultToResultNodes {
    private static final Logger log = LoggerFactory.getLogger(ServiceResultToResultNodes.class);

    public RootExecutionResultNode createResultWithNullTopLevelField(NormalizedQueryFromAst query, NormalizedQueryField topLevelField, List<GraphQLError> errors, Map<String, Object> extensions) {
        ElapsedTime zeroElapsedTime = ElapsedTime.newElapsedTime().start().stop().build();
        List fieldIds = query.getFieldIds(topLevelField);
        ResultPath path = ResultPath.rootPath().segment(topLevelField.getResultKey());
        LeafExecutionResultNode nullTopLevelField = this.createNullERN(topLevelField, path, fieldIds, zeroElapsedTime);
        return ((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)RootExecutionResultNode.newRootExecutionResultNode().errors(errors)).extensions(extensions)).elapsedTime(zeroElapsedTime)).addChild(nullTopLevelField)).build();
    }

    public RootExecutionResultNode resultToResultNode(ExecutionContext executionContext, ServiceExecutionResult serviceExecutionResult, ElapsedTime elapsedTimeForServiceCall, NormalizedQueryFromAst normalizedQueryFromAst) {
        long startTime = System.currentTimeMillis();
        RootExecutionResultNode rootExecutionResultNodeNoData = this.resultNodeWithoutData(serviceExecutionResult, elapsedTimeForServiceCall);
        RootExecutionResultNode rootExecutionResultNode = this.fetchTopLevelFields(rootExecutionResultNodeNoData, executionContext, serviceExecutionResult, elapsedTimeForServiceCall, normalizedQueryFromAst);
        long elapsedTime = System.currentTimeMillis() - startTime;
        log.debug("ServiceResultToResultNodes time: {} ms, executionId: {}", (Object)elapsedTime, (Object)executionContext.getExecutionId());
        return rootExecutionResultNode;
    }

    private RootExecutionResultNode resultNodeWithoutData(ServiceExecutionResult serviceExecutionResult, ElapsedTime elapsedTimeForServiceCall) {
        List errors = ErrorUtil.createGraphQlErrorsFromRawErrors((List)serviceExecutionResult.getErrors());
        Map extensions = serviceExecutionResult.getExtensions();
        return ((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)RootExecutionResultNode.newRootExecutionResultNode().errors(errors)).extensions(extensions)).elapsedTime(elapsedTimeForServiceCall)).build();
    }

    private RootExecutionResultNode fetchTopLevelFields(RootExecutionResultNode rootNode, ExecutionContext executionContext, ServiceExecutionResult serviceExecutionResult, ElapsedTime elapsedTime, NormalizedQueryFromAst normalizedQueryFromAst) {
        List topLevelFields = normalizedQueryFromAst.getTopLevelFields();
        ResultPath rootPath = ResultPath.rootPath();
        Map source = serviceExecutionResult.getData();
        ArrayList<ExecutionResultNode> children = new ArrayList<ExecutionResultNode>(topLevelFields.size());
        for (NormalizedQueryField topLevelField : topLevelFields) {
            ResultPath path = rootPath.segment(topLevelField.getResultKey());
            List fieldIds = normalizedQueryFromAst.getFieldIds(topLevelField);
            ExecutionResultNode executionResultNode = this.fetchAndAnalyzeField(executionContext, source, topLevelField, normalizedQueryFromAst, path, fieldIds, elapsedTime);
            children.add(executionResultNode);
        }
        return (RootExecutionResultNode)rootNode.withNewChildren(children);
    }

    private ExecutionResultNode fetchAndAnalyzeField(ExecutionContext context, Object source, NormalizedQueryField normalizedQueryField, NormalizedQueryFromAst normalizedQueryFromAst, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime) {
        Object fetchedValue = this.fetchValue(source, normalizedQueryField.getResultKey());
        return this.analyzeValue(context, fetchedValue, normalizedQueryField, normalizedQueryFromAst, executionPath, fieldIds, elapsedTime);
    }

    private Object fetchValue(Object source, String key) {
        if (source == null) {
            return null;
        }
        Map map = (Map)source;
        return map.get(key);
    }

    private ExecutionResultNode analyzeValue(ExecutionContext executionContext, Object fetchedValue, NormalizedQueryField normalizedQueryField, NormalizedQueryFromAst normalizedQueryFromAst, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime) {
        return this.analyzeFetchedValueImpl(executionContext, fetchedValue, normalizedQueryField, normalizedQueryFromAst, normalizedQueryField.getFieldDefinition().getType(), executionPath, fieldIds, elapsedTime);
    }

    private ExecutionResultNode analyzeFetchedValueImpl(ExecutionContext executionContext, Object toAnalyze, NormalizedQueryField normalizedQueryField, NormalizedQueryFromAst normalizedQueryFromAst, GraphQLOutputType curType, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime) {
        boolean isNonNull = GraphQLTypeUtil.isNonNull((GraphQLType)curType);
        if (toAnalyze == null && isNonNull) {
            NonNullableFieldWasNullError nonNullableFieldWasNullError = new NonNullableFieldWasNullError((GraphQLNonNull)curType, executionPath);
            return this.createNullERNWithNullableError(normalizedQueryField, executionPath, fieldIds, elapsedTime, nonNullableFieldWasNullError);
        }
        if (toAnalyze == null) {
            return this.createNullERN(normalizedQueryField, executionPath, fieldIds, elapsedTime);
        }
        if (GraphQLTypeUtil.isList((GraphQLType)(curType = (GraphQLOutputType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)curType)))) {
            return this.analyzeList(executionContext, toAnalyze, (GraphQLList)curType, normalizedQueryField, normalizedQueryFromAst, executionPath, fieldIds, elapsedTime);
        }
        if (curType instanceof GraphQLScalarType) {
            return this.analyzeScalarValue(toAnalyze, (GraphQLScalarType)curType, normalizedQueryField, executionPath, fieldIds, elapsedTime);
        }
        if (curType instanceof GraphQLEnumType) {
            return this.analyzeEnumValue(toAnalyze, (GraphQLEnumType)curType, normalizedQueryField, executionPath, fieldIds, elapsedTime);
        }
        GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, toAnalyze, (GraphQLType)curType);
        return this.resolveObject(executionContext, normalizedQueryField, fieldIds, normalizedQueryFromAst, resolvedObjectType, toAnalyze, executionPath, elapsedTime);
    }

    private ObjectExecutionResultNode resolveObject(ExecutionContext context, NormalizedQueryField normalizedField, List<String> objectFieldIds, NormalizedQueryFromAst normalizedQueryFromAst, GraphQLObjectType resolvedType, Object completedValue, ResultPath executionPath, ElapsedTime elapsedTime) {
        ArrayList<ExecutionResultNode> nodeChildren = new ArrayList<ExecutionResultNode>(normalizedField.getChildren().size());
        for (NormalizedQueryField child : normalizedField.getChildren()) {
            if (child.getObjectType() != resolvedType) continue;
            ResultPath pathForChild = executionPath.segment(child.getResultKey());
            List fieldIds = normalizedQueryFromAst.getFieldIds(child);
            ExecutionResultNode childNode = this.fetchAndAnalyzeField(context, completedValue, child, normalizedQueryFromAst, pathForChild, fieldIds, elapsedTime);
            nodeChildren.add(childNode);
        }
        return ((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)ObjectExecutionResultNode.newObjectExecutionResultNode().resultPath(executionPath)).alias(normalizedField.getAlias())).fieldIds(objectFieldIds)).objectType(normalizedField.getObjectType())).fieldDefinition(normalizedField.getFieldDefinition())).completedValue(completedValue)).children(nodeChildren)).elapsedTime(elapsedTime)).build();
    }

    private ExecutionResultNode analyzeList(ExecutionContext executionContext, Object toAnalyze, GraphQLList curType, NormalizedQueryField normalizedQueryField, NormalizedQueryFromAst normalizedQueryFromAst, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime) {
        if (toAnalyze instanceof List) {
            return this.createListImpl(executionContext, toAnalyze, (List)toAnalyze, curType, normalizedQueryField, normalizedQueryFromAst, executionPath, fieldIds, elapsedTime);
        }
        TypeMismatchError error = new TypeMismatchError(executionPath, (GraphQLType)curType);
        return ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().resultPath(executionPath)).alias(normalizedQueryField.getAlias())).fieldDefinition(normalizedQueryField.getFieldDefinition())).objectType(normalizedQueryField.getObjectType())).completedValue(null)).fieldIds(fieldIds)).elapsedTime(elapsedTime)).addError((GraphQLError)error)).build();
    }

    private LeafExecutionResultNode createNullERNWithNullableError(NormalizedQueryField normalizedQueryField, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime, NonNullableFieldWasNullError nonNullableFieldWasNullError) {
        return ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().resultPath(executionPath)).alias(normalizedQueryField.getAlias())).fieldDefinition(normalizedQueryField.getFieldDefinition())).objectType(normalizedQueryField.getObjectType())).completedValue(null)).fieldIds(fieldIds)).elapsedTime(elapsedTime)).nonNullableFieldWasNullError(nonNullableFieldWasNullError)).build();
    }

    private LeafExecutionResultNode createNullERN(NormalizedQueryField normalizedQueryField, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime) {
        return ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().resultPath(executionPath)).alias(normalizedQueryField.getAlias())).fieldDefinition(normalizedQueryField.getFieldDefinition())).objectType(normalizedQueryField.getObjectType())).completedValue(null)).fieldIds(fieldIds)).elapsedTime(elapsedTime)).build();
    }

    private ExecutionResultNode createListImpl(ExecutionContext executionContext, Object fetchedValue, List<Object> iterableValues, GraphQLList currentType, NormalizedQueryField normalizedQueryField, NormalizedQueryFromAst normalizedQueryFromAst, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime) {
        ArrayList<ExecutionResultNode> children = new ArrayList<ExecutionResultNode>();
        int index = 0;
        for (Object item : iterableValues) {
            ResultPath indexedPath = executionPath.segment(index);
            children.add(this.analyzeFetchedValueImpl(executionContext, item, normalizedQueryField, normalizedQueryFromAst, (GraphQLOutputType)GraphQLTypeUtil.unwrapOne((GraphQLType)currentType), indexedPath, fieldIds, elapsedTime));
            ++index;
        }
        return ((ListExecutionResultNode.Builder)((ListExecutionResultNode.Builder)((ListExecutionResultNode.Builder)((ListExecutionResultNode.Builder)((ListExecutionResultNode.Builder)((ListExecutionResultNode.Builder)((ListExecutionResultNode.Builder)((ListExecutionResultNode.Builder)ListExecutionResultNode.newListExecutionResultNode().resultPath(executionPath)).alias(normalizedQueryField.getAlias())).fieldDefinition(normalizedQueryField.getFieldDefinition())).objectType(normalizedQueryField.getObjectType())).completedValue(fetchedValue)).fieldIds(fieldIds)).elapsedTime(elapsedTime)).children(children)).build();
    }

    private GraphQLObjectType resolveType(ExecutionContext executionContext, Object source, GraphQLType curType) {
        if (curType instanceof GraphQLObjectType) {
            return (GraphQLObjectType)curType;
        }
        NadelContext nadelContext = (NadelContext)executionContext.getContext();
        String underscoreTypeNameAlias = "type_hint_" + nadelContext.getUnderscoreTypeNameAlias();
        Assert.assertTrue((boolean)(source instanceof Map), () -> "The Nadel result object MUST be a Map");
        Map sourceMap = (Map)source;
        Assert.assertTrue((boolean)sourceMap.containsKey(underscoreTypeNameAlias), () -> "The Nadel result object for interfaces and unions MUST have an aliased __typename in them");
        Object typeName = sourceMap.get(underscoreTypeNameAlias);
        Assert.assertNotNull(typeName, () -> "The Nadel result object for interfaces and unions MUST have an aliased__typename with a non null value in them");
        GraphQLObjectType objectType = executionContext.getGraphQLSchema().getObjectType(typeName.toString());
        Assert.assertNotNull((Object)objectType, () -> String.format("There must be an underlying graphql object type called '%s'", typeName));
        return objectType;
    }

    private ExecutionResultNode analyzeScalarValue(Object toAnalyze, GraphQLScalarType scalarType, NormalizedQueryField normalizedQueryField, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime) {
        Object serialized;
        try {
            serialized = this.serializeScalarValue(toAnalyze, scalarType);
        }
        catch (CoercingSerializeException e) {
            SerializationError error = new SerializationError(executionPath, e);
            return ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().resultPath(executionPath)).alias(normalizedQueryField.getAlias())).fieldDefinition(normalizedQueryField.getFieldDefinition())).objectType(normalizedQueryField.getObjectType())).completedValue(null)).fieldIds(fieldIds)).elapsedTime(elapsedTime)).addError((GraphQLError)error)).build();
        }
        if (serialized instanceof Double && ((Double)serialized).isNaN()) {
            return this.createNullERN(normalizedQueryField, executionPath, fieldIds, elapsedTime);
        }
        return ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().resultPath(executionPath)).alias(normalizedQueryField.getAlias())).fieldDefinition(normalizedQueryField.getFieldDefinition())).objectType(normalizedQueryField.getObjectType())).completedValue(serialized)).fieldIds(fieldIds)).elapsedTime(elapsedTime)).build();
    }

    protected Object serializeScalarValue(Object toAnalyze, GraphQLScalarType scalarType) throws CoercingSerializeException {
        if (scalarType == Scalars.GraphQLString) {
            if (toAnalyze instanceof String) {
                return toAnalyze;
            }
            throw new CoercingSerializeException("Unexpected value '" + toAnalyze + "'. String expected");
        }
        return scalarType.getCoercing().serialize(toAnalyze);
    }

    private ExecutionResultNode analyzeEnumValue(Object toAnalyze, GraphQLEnumType enumType, NormalizedQueryField normalizedQueryField, ResultPath executionPath, List<String> fieldIds, ElapsedTime elapsedTime) {
        Object serialized;
        try {
            serialized = enumType.serialize(toAnalyze);
        }
        catch (CoercingSerializeException e) {
            SerializationError error = new SerializationError(executionPath, e);
            return ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().resultPath(executionPath)).alias(normalizedQueryField.getAlias())).fieldDefinition(normalizedQueryField.getFieldDefinition())).objectType(normalizedQueryField.getObjectType())).completedValue(null)).fieldIds(fieldIds)).elapsedTime(elapsedTime)).addError((GraphQLError)error)).build();
        }
        return ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().resultPath(executionPath)).alias(normalizedQueryField.getAlias())).fieldDefinition(normalizedQueryField.getFieldDefinition())).objectType(normalizedQueryField.getObjectType())).completedValue(serialized)).fieldIds(fieldIds)).elapsedTime(elapsedTime)).build();
    }
}

