/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation;

import graphql.Assert;
import graphql.Internal;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.SelectionSet;
import graphql.nadel.engine.execution.FieldMetadataUtil;
import graphql.nadel.engine.execution.transformation.FieldMetadata;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.LeafExecutionResultNode;
import graphql.nadel.engine.result.ObjectExecutionResultNode;
import graphql.nadel.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

@Internal
public final class FieldUtils {
    public static String resultKeyForField(Field field) {
        return field.getAlias() != null ? field.getAlias() : field.getName();
    }

    public static Field pathToFields(List<String> path, Field copyFieldMetadataFrom, String transformationId, List<String> additionalIds, boolean firstRootOfTransformation, Map<String, List<FieldMetadata>> metadataByFieldId) {
        return FieldUtils.pathToFields(path, copyFieldMetadataFrom, transformationId, additionalIds, firstRootOfTransformation, null, metadataByFieldId);
    }

    public static Field pathToFields(List<String> path, Field copyMetadataFrom, String transformationId, List<String> additionalIds, boolean firstRootOfTransformation, SelectionSet lastSelectionSet, Map<String, List<FieldMetadata>> metadataByFieldId) {
        Field curField = null;
        for (int ix = path.size() - 1; ix >= 0; --ix) {
            Field.Builder newField = Field.newField();
            String fieldId = "new-field_" + path.get(ix) + "_" + UUID.randomUUID().toString();
            newField.additionalData("id", fieldId);
            FieldMetadataUtil.setFieldMetadata(fieldId, transformationId, additionalIds, ix == 0 && firstRootOfTransformation, metadataByFieldId);
            if (ix == path.size() - 1 && lastSelectionSet != null) {
                newField.selectionSet(lastSelectionSet);
            }
            if (curField != null) {
                newField.selectionSet(SelectionSet.newSelectionSet().selection(curField).build());
            }
            newField.name(path.get(ix));
            curField = newField.build();
            FieldMetadataUtil.copyFieldMetadata(copyMetadataFrom, curField, metadataByFieldId);
        }
        return curField;
    }

    public static LeafExecutionResultNode getFirstLeafNode(ExecutionResultNode executionResultNode) {
        ExecutionResultNode curNode = executionResultNode;
        while (curNode instanceof ObjectExecutionResultNode) {
            ExecutionResultNode finalCurNode = curNode;
            Assert.assertTrue((curNode.getChildren().size() == 1 ? 1 : 0) != 0, () -> String.format("expecting one child but got %s", finalCurNode.getChildren().size()));
            curNode = curNode.getChildren().get(0);
        }
        Assert.assertTrue((boolean)(curNode instanceof LeafExecutionResultNode), () -> "expecting only object results and at the end one leaf");
        return (LeafExecutionResultNode)curNode;
    }

    public static ExecutionResultNode getSubTree(ExecutionResultNode executionResultNode, int levels) {
        ExecutionResultNode curNode = executionResultNode;
        int curLevel = 0;
        while (curNode.getChildren().size() > 0 && curLevel++ < levels) {
            ExecutionResultNode finalCurNode = curNode;
            Assert.assertTrue((curNode.getChildren().size() == 1 ? 1 : 0) != 0, () -> String.format("expecting one child but got %s", finalCurNode.getChildren().size()));
            if (!((curNode = curNode.getChildren().get(0)) instanceof LeafExecutionResultNode)) continue;
            return curNode;
        }
        return curNode;
    }

    public static void addTransformationIdToChildren(Field field, Map<String, FragmentDefinition> fragmentDefinitionMap, final String transformationId, final Map<String, List<FieldMetadata>> metadataByFieldId) {
        if (field.getSelectionSet() == null) {
            return;
        }
        Function<Node, List> getChildren = node -> {
            if (node instanceof FragmentSpread) {
                FragmentDefinition fragmentDefinition = (FragmentDefinition)Assert.assertNotNull((Object)((FragmentDefinition)fragmentDefinitionMap.get(((FragmentSpread)node).getName())));
                ArrayList<FragmentDefinition> result = new ArrayList<FragmentDefinition>();
                result.addAll(node.getChildren());
                result.add(fragmentDefinition);
                return result;
            }
            return node.getChildren();
        };
        NodeTraverser nodeTraverser = new NodeTraverser(Collections.emptyMap(), getChildren);
        nodeTraverser.depthFirst((NodeVisitor)new NodeVisitorStub(){

            public TraversalControl visitField(Field field, TraverserContext<Node> context) {
                FieldMetadataUtil.addFieldMetadata(field, transformationId, false, metadataByFieldId);
                return TraversalControl.CONTINUE;
            }
        }, (Node)field.getSelectionSet());
    }

    public static ExecutionResultNode mapChildren(ExecutionResultNode executionResultNode, Function<ExecutionResultNode, ExecutionResultNode> mapper) {
        List newChildren = FpKit.map(executionResultNode.getChildren(), mapper);
        return executionResultNode.withNewChildren(newChildren);
    }
}

