/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation.variables;

import graphql.Assert;
import graphql.PublicApi;
import graphql.nadel.engine.execution.transformation.variables.InputValueFindFunction;
import graphql.nadel.engine.execution.transformation.variables.InputValueTransformer;
import graphql.nadel.engine.execution.transformation.variables.InputValueTree;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInputValueDefinition;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@PublicApi
public class InputValueFinder {
    public static <T> List<T> find(List<? extends GraphQLInputValueDefinition> valueDefinitions, Map<String, Object> coercedArgs, InputValueFindFunction<T> inputValueFindFunction) {
        ArrayList foundValues = new ArrayList();
        for (GraphQLInputValueDefinition graphQLInputValueDefinition : valueDefinitions) {
            String argumentName = graphQLInputValueDefinition.getName();
            if (!coercedArgs.containsKey(argumentName)) continue;
            GraphQLInputType inputType = graphQLInputValueDefinition.getType();
            InputValueTree inputValueTree = new InputValueTree(null, argumentName, inputType, graphQLInputValueDefinition);
            Object coercedValue = coercedArgs.get(argumentName);
            InputValueFinder.findImpl(foundValues, inputType, coercedValue, inputValueTree, inputValueFindFunction);
        }
        return foundValues;
    }

    private static <T> void findImpl(List<T> foundValues, GraphQLInputType type, Object coercedValue, InputValueTree inputValueTree, InputValueFindFunction<T> inputValueFindFunction) {
        if (coercedValue == null) {
            Optional<Object> result = inputValueFindFunction.apply(coercedValue, inputValueTree);
            result.ifPresent(foundValues::add);
        } else if (GraphQLTypeUtil.isNonNull((GraphQLType)type)) {
            InputValueFinder.findImpl(foundValues, InputValueTransformer.unwrapOne(type), coercedValue, inputValueTree.unwrapOne(), inputValueFindFunction);
        } else if (GraphQLTypeUtil.isList((GraphQLType)type)) {
            Assert.assertTrue((boolean)(coercedValue instanceof Iterable), () -> "The value MUST be an Iterable");
            InputValueFinder.findListValue(foundValues, InputValueTransformer.unwrapOne(type), (Iterable)coercedValue, inputValueTree.unwrapOne(), inputValueFindFunction);
        } else if (type instanceof GraphQLInputObjectType) {
            Assert.assertTrue((boolean)(coercedValue instanceof Map), () -> "The value MUST be an Map");
            Map coercedMap = (Map)coercedValue;
            InputValueFinder.findObjectValue(foundValues, (GraphQLInputObjectType)type, coercedMap, inputValueTree, inputValueFindFunction);
        } else {
            Optional<Object> result = inputValueFindFunction.apply(coercedValue, inputValueTree);
            result.ifPresent(foundValues::add);
        }
    }

    private static <T> void findListValue(List<T> foundValues, GraphQLInputType unwrappedListType, Iterable coercedIterable, InputValueTree inputValueTree, InputValueFindFunction<T> inputValueFindFunction) {
        for (Object coercedValue : coercedIterable) {
            InputValueFinder.findImpl(foundValues, unwrappedListType, coercedValue, inputValueTree.unwrapOne(), inputValueFindFunction);
        }
    }

    private static <T> void findObjectValue(List<T> foundValues, GraphQLInputObjectType inputObjectType, Map<String, Object> coercedMap, InputValueTree inputValueTree, InputValueFindFunction<T> inputValueFindFunction) {
        for (GraphQLInputObjectField inputFieldDef : inputObjectType.getFieldDefinitions()) {
            String fieldName = inputFieldDef.getName();
            if (!coercedMap.containsKey(fieldName)) continue;
            GraphQLInputType fieldType = inputFieldDef.getType();
            InputValueTree newInputValueTree = new InputValueTree(inputValueTree, fieldName, fieldType, (GraphQLInputValueDefinition)inputFieldDef);
            Object coercedValue = coercedMap.get(fieldName);
            InputValueFinder.findImpl(foundValues, fieldType, coercedValue, newInputValueTree, inputValueFindFunction);
        }
    }
}

