/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.language.FragmentDefinition;
import graphql.nadel.OperationKind;
import graphql.nadel.Service;
import graphql.nadel.ServiceExecution;
import graphql.nadel.ServiceExecutionHydrationDetails;
import graphql.nadel.ServiceExecutionParameters;
import graphql.nadel.ServiceExecutionResult;
import graphql.nadel.engine.BenchmarkContext;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.engine.execution.QueryTransformationResult;
import graphql.nadel.engine.execution.ServiceResultToResultNodes;
import graphql.nadel.engine.execution.StrategyUtil;
import graphql.nadel.engine.result.ElapsedTime;
import graphql.nadel.engine.result.RootExecutionResultNode;
import graphql.nadel.instrumentation.NadelInstrumentation;
import graphql.nadel.instrumentation.parameters.NadelInstrumentationServiceExecutionParameters;
import graphql.nadel.normalized.NormalizedQueryFactory;
import graphql.nadel.normalized.NormalizedQueryFromAst;
import graphql.nadel.util.Data;
import graphql.nadel.util.LogKit;
import graphql.schema.GraphQLSchema;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ServiceExecutor {
    private final Logger log = LoggerFactory.getLogger(ServiceExecutor.class);
    private final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(ServiceExecutor.class);
    private final ServiceResultToResultNodes resultToResultNode = new ServiceResultToResultNodes();
    private final NormalizedQueryFactory normalizedQueryFactory = new NormalizedQueryFactory();
    private final NadelInstrumentation instrumentation;

    public ServiceExecutor(NadelInstrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public CompletableFuture<RootExecutionResultNode> execute(ExecutionContext executionContext, QueryTransformationResult queryTransformerResult, Service service, OperationKind operationKind, Object serviceContext, GraphQLSchema schema, ServiceExecutionHydrationDetails hydrationDetails) {
        List<MergedField> transformedMergedFields = queryTransformerResult.getTransformedMergedFields();
        ServiceExecution serviceExecution = service.getServiceExecution();
        GraphQLSchema underlyingSchema = service.getUnderlyingSchema();
        ServiceExecutionParameters serviceExecutionParameters = this.buildServiceExecutionParameters(executionContext, queryTransformerResult, serviceContext, hydrationDetails);
        ExecutionContext executionContextForService = this.buildServiceExecutionContext(executionContext, underlyingSchema, serviceExecutionParameters);
        ExecutionStepInfo underlyingRootStepInfo = StrategyUtil.createRootExecutionStepInfo(underlyingSchema, operationKind);
        NormalizedQueryFromAst normalizedQuery = this.normalizedQueryFactory.createNormalizedQuery(schema, serviceExecutionParameters.getQuery(), null, serviceExecutionParameters.getVariables());
        CompletableFuture<Data> result = this.executeImpl(service, serviceExecution, serviceExecutionParameters, underlyingRootStepInfo, executionContext);
        return result.thenApply(data -> this.serviceExecutionResultToResultNode(executionContextForService, underlyingRootStepInfo, transformedMergedFields, (Data)data, normalizedQuery));
    }

    private CompletableFuture<Data> executeImpl(Service service, ServiceExecution serviceExecution, ServiceExecutionParameters serviceExecutionParameters, ExecutionStepInfo executionStepInfo, ExecutionContext executionContext) {
        NadelInstrumentationServiceExecutionParameters instrumentationParams = new NadelInstrumentationServiceExecutionParameters(service, executionContext, executionContext.getInstrumentationState());
        serviceExecution = this.instrumentation.instrumentServiceExecution(serviceExecution, instrumentationParams);
        try {
            this.log.debug("service {} invocation started - executionId '{}'", (Object)service.getName(), (Object)executionContext.getExecutionId());
            ElapsedTime.Builder elapsedTimeBuilder = ElapsedTime.newElapsedTime().start();
            CompletableFuture executeReturnValue = serviceExecution.execute(serviceExecutionParameters);
            Assert.assertNotNull((Object)executeReturnValue, () -> "service execution returned null");
            CompletionStage result = executeReturnValue.thenApply(serviceExecutionResult -> {
                ElapsedTime elapsedTime = elapsedTimeBuilder.stop().build();
                return Data.newData().set(ElapsedTime.class, (Object)elapsedTime).set(ServiceExecutionResult.class, serviceExecutionResult).build();
            });
            this.log.debug("service {} invocation finished  - executionId '{}' ", (Object)service.getName(), (Object)executionContext.getExecutionId());
            return ((CompletableFuture)result).handle(this.handleServiceException(service, executionContext, executionStepInfo));
        }
        catch (Exception e) {
            ServiceExecutionResult exceptionResult = this.mkExceptionResult(service, executionContext, executionStepInfo, e);
            return CompletableFuture.completedFuture(Data.newData().set(ServiceExecutionResult.class, (Object)exceptionResult).build());
        }
    }

    private BiFunction<Data, Throwable, Data> handleServiceException(Service service, ExecutionContext executionContext, ExecutionStepInfo executionStepInfo) {
        return (data, throwable) -> {
            if (throwable != null) {
                return Data.newData().set(ServiceExecutionResult.class, (Object)this.mkExceptionResult(service, executionContext, executionStepInfo, (Throwable)throwable)).build();
            }
            return data;
        };
    }

    private ServiceExecutionResult mkExceptionResult(Service service, ExecutionContext executionContext, ExecutionStepInfo executionStepInfo, Throwable throwable) {
        String errorText = String.format("An exception occurred invoking the service '%s' : '%s' - executionId '%s'", service.getName(), throwable.getMessage(), executionContext.getExecutionId());
        this.logNotSafe.error(errorText, throwable);
        GraphqlErrorBuilder errorBuilder = GraphqlErrorBuilder.newError();
        MergedField field = executionStepInfo.getField();
        if (field != null) {
            errorBuilder.location(field.getSingleField().getSourceLocation());
        }
        LinkedHashMap<String, Throwable> extensions = new LinkedHashMap<String, Throwable>();
        extensions.put(Throwable.class.getName(), throwable);
        GraphQLError error = errorBuilder.message(errorText, new Object[0]).path(executionStepInfo.getPath()).errorType((ErrorClassification)ErrorType.DataFetchingException).extensions(extensions).build();
        Map errorMap = error.toSpecification();
        return new ServiceExecutionResult(new LinkedHashMap(), Collections.singletonList(errorMap), Collections.emptyMap());
    }

    private ServiceExecutionParameters buildServiceExecutionParameters(ExecutionContext executionContext, QueryTransformationResult queryTransformerResult, Object serviceContext, ServiceExecutionHydrationDetails hydrationDetails) {
        Map<String, Object> variables = this.buildReferencedVariables(executionContext, queryTransformerResult);
        Map<String, FragmentDefinition> fragments = queryTransformerResult.getTransformedFragments();
        NadelContext nadelContext = (NadelContext)executionContext.getContext();
        Object callerSuppliedContext = nadelContext.getUserSuppliedContext();
        return ServiceExecutionParameters.newServiceExecutionParameters().query(queryTransformerResult.getDocument()).context(callerSuppliedContext).variables(variables).fragments(fragments).operationDefinition(queryTransformerResult.getOperationDefinition()).executionId(executionContext.getExecutionId()).cacheControl(executionContext.getCacheControl()).serviceContext(serviceContext).executionHydrationDetails(hydrationDetails).build();
    }

    Map<String, Object> buildReferencedVariables(ExecutionContext executionContext, QueryTransformationResult queryTransformerResult) {
        Map contextVariables = executionContext.getVariables();
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
        for (String referencedVariable : queryTransformerResult.getReferencedVariables()) {
            Object value = contextVariables.get(referencedVariable);
            variables.put(referencedVariable, value);
        }
        return variables;
    }

    private ExecutionContext buildServiceExecutionContext(ExecutionContext executionContext, GraphQLSchema underlyingSchema, ServiceExecutionParameters serviceExecutionParameters) {
        return executionContext.transform(builder -> builder.graphQLSchema(underlyingSchema).fragmentsByName(serviceExecutionParameters.getFragments()).variables(serviceExecutionParameters.getVariables()).operationDefinition(serviceExecutionParameters.getOperationDefinition()));
    }

    private RootExecutionResultNode serviceExecutionResultToResultNode(ExecutionContext executionContextForService, ExecutionStepInfo underlyingRootStepInfo, List<MergedField> transformedMergedFields, Data data, NormalizedQueryFromAst normalizedQuery) {
        ServiceExecutionResult serviceExecutionResult = (ServiceExecutionResult)data.get(ServiceExecutionResult.class);
        ElapsedTime elapsedTime = (ElapsedTime)data.get(ElapsedTime.class);
        NadelContext nadelContext = (NadelContext)executionContextForService.getContext();
        if (nadelContext.getUserSuppliedContext() instanceof BenchmarkContext) {
            BenchmarkContext.ServiceResultToResultNodesArgs serviceResultToResultNodesArgs = ((BenchmarkContext)nadelContext.getUserSuppliedContext()).serviceResultToResultNodesArgs;
            serviceResultToResultNodesArgs.executionContextForService = executionContextForService;
            serviceResultToResultNodesArgs.underlyingRootStepInfo = underlyingRootStepInfo;
            serviceResultToResultNodesArgs.transformedMergedFields = transformedMergedFields;
            serviceResultToResultNodesArgs.serviceExecutionResult = serviceExecutionResult;
            serviceResultToResultNodesArgs.elapsedTime = elapsedTime;
            serviceResultToResultNodesArgs.normalizedQuery = normalizedQuery;
        }
        return this.resultToResultNode.resultToResultNode(executionContextForService, serviceExecutionResult, elapsedTime, normalizedQuery);
    }
}

