/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.GraphQLError;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.Node;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.hooks.HydrationArguments;
import graphql.nadel.hooks.ServiceExecutionHooks;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.nadel.util.FpKit;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class AsyncIsFieldForbidden {
    @NotNull
    private final Map<NormalizedQueryField, GraphQLError> fieldsToErrors = new ConcurrentHashMap<NormalizedQueryField, GraphQLError>();
    @NotNull
    private final ServiceExecutionHooks serviceExecutionHooks;
    @NotNull
    private final NadelContext nadelContext;
    @NotNull
    private final GraphQLSchema graphQLSchema;
    @NotNull
    private final HydrationArguments hydrationArguments;
    @NotNull
    private final Map<String, Object> variables;

    public AsyncIsFieldForbidden(@NotNull ServiceExecutionHooks serviceExecutionHooks, @NotNull NadelContext nadelContext, @NotNull GraphQLSchema graphQLSchema, @NotNull HydrationArguments hydrationArguments, @NotNull Map<String, Object> variables) {
        this.serviceExecutionHooks = serviceExecutionHooks;
        this.nadelContext = nadelContext;
        this.graphQLSchema = graphQLSchema;
        this.hydrationArguments = hydrationArguments;
        this.variables = variables;
    }

    @NotNull
    public CompletableFuture<Map<NormalizedQueryField, GraphQLError>> getForbiddenFields(Node<?> root) {
        List<NormalizedQueryField> normalisedFields = this.getNormalisedFields(root);
        List visitNormalisedFields = FpKit.map(normalisedFields, this::visitField);
        return AsyncIsFieldForbidden.allOf(visitNormalisedFields).thenApply(ignored -> this.fieldsToErrors);
    }

    private List<NormalizedQueryField> getNormalisedFields(Node<?> node) {
        if (node instanceof Field) {
            return this.nadelContext.getNormalizedOverallQuery().getNormalizedFieldsByFieldId(NodeId.getId(node));
        }
        return FpKit.flatMap((List)node.getChildren(), this::getNormalisedFields);
    }

    private CompletableFuture<Void> visitField(NormalizedQueryField field) {
        if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
            return CompletableFuture.completedFuture(null);
        }
        return this.serviceExecutionHooks.isFieldForbidden(field, this.hydrationArguments, this.variables, this.graphQLSchema, this.nadelContext.getUserSuppliedContext()).thenCompose(graphQLError -> {
            if (graphQLError.isPresent()) {
                this.fieldsToErrors.put(field, (GraphQLError)graphQLError.get());
                return CompletableFuture.completedFuture(null);
            }
            List visitChildren = FpKit.map((List)field.getChildren(), this::visitField);
            return AsyncIsFieldForbidden.allOf(visitChildren);
        });
    }

    private static CompletableFuture<Void> allOf(List<CompletableFuture<Void>> cfs) {
        return CompletableFuture.allOf(cfs.toArray(new CompletableFuture[0]));
    }
}

