/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.Internal;
import graphql.language.Field;
import graphql.language.Node;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.engine.execution.transformation.FieldMetadata;
import graphql.nadel.util.FpKit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Internal
public class FieldMetadataUtil {
    public static List<String> getRootOfTransformationIds(Field field, Map<String, List<FieldMetadata>> metadataByFieldId) {
        List<FieldMetadata> fieldMetadata = FieldMetadataUtil.readMetadata(field, metadataByFieldId);
        return FpKit.filterAndMap(fieldMetadata, FieldMetadata::isRootOfTransformation, FieldMetadata::getTransformationId);
    }

    public static List<String> getRootOfTransformationIds(String fieldId, Map<String, List<FieldMetadata>> metadataByFieldId) {
        List<FieldMetadata> fieldMetadata = FieldMetadataUtil.readMetadata(fieldId, metadataByFieldId);
        return FpKit.filterAndMap(fieldMetadata, FieldMetadata::isRootOfTransformation, FieldMetadata::getTransformationId);
    }

    public static List<String> getTransformationIds(Field field, Map<String, List<FieldMetadata>> metadataByFieldId) {
        List<FieldMetadata> fieldMetadata = FieldMetadataUtil.readMetadata(field, metadataByFieldId);
        return FpKit.map(fieldMetadata, FieldMetadata::getTransformationId);
    }

    public static List<String> getTransformationIds(String fieldId, Map<String, List<FieldMetadata>> metadataByFieldId) {
        List<FieldMetadata> fieldMetadata = FieldMetadataUtil.readMetadata(fieldId, metadataByFieldId);
        return FpKit.map(fieldMetadata, FieldMetadata::getTransformationId);
    }

    public static void addFieldMetadata(Field field, String transformationId, boolean rootOfTransformation, Map<String, List<FieldMetadata>> metadataByFieldId) {
        List<FieldMetadata> fieldMetadata = FieldMetadataUtil.readMetadata(field, metadataByFieldId);
        FieldMetadata newFieldMetadata = new FieldMetadata(transformationId, rootOfTransformation);
        fieldMetadata.add(newFieldMetadata);
        FieldMetadataUtil.writeMetadata(field, fieldMetadata, metadataByFieldId);
    }

    public static void copyFieldMetadata(Field from, Field to, Map<String, List<FieldMetadata>> metadataByFieldId) {
        List<FieldMetadata> fromMetadata = FieldMetadataUtil.readMetadata(from, metadataByFieldId);
        if (fromMetadata.isEmpty()) {
            return;
        }
        List<FieldMetadata> toMetadata = FieldMetadataUtil.readMetadata(to, metadataByFieldId);
        toMetadata.addAll(fromMetadata);
        FieldMetadataUtil.writeMetadata(to, toMetadata, metadataByFieldId);
    }

    public static String getUniqueRootTransformationId(Field field, Map<String, List<FieldMetadata>> metadataByFieldId) {
        List<FieldMetadata> fieldMetadata = FieldMetadataUtil.readMetadata(field, metadataByFieldId);
        List rootFieldMetadata = FpKit.filter(fieldMetadata, FieldMetadata::isRootOfTransformation);
        Assert.assertTrue((rootFieldMetadata.size() == 1 ? 1 : 0) != 0, () -> "exactly one root info expected");
        return ((FieldMetadata)rootFieldMetadata.get(0)).getTransformationId();
    }

    public static void setFieldMetadata(String fieldId, String transformationId, List<String> additionalIds, boolean rootOfTransformation, Map<String, List<FieldMetadata>> metadataByFieldId) {
        Assert.assertNotNull((Object)transformationId);
        ArrayList<FieldMetadata> fieldMetadata = new ArrayList<FieldMetadata>();
        FieldMetadata newFieldMetadata = new FieldMetadata(transformationId, rootOfTransformation);
        fieldMetadata.add(newFieldMetadata);
        for (String additionalId : additionalIds) {
            fieldMetadata.add(new FieldMetadata(additionalId, false));
        }
        metadataByFieldId.put(fieldId, fieldMetadata);
    }

    private static void writeMetadata(Field field, List<FieldMetadata> newMetadata, Map<String, List<FieldMetadata>> metadataByFieldId) {
        metadataByFieldId.put(NodeId.getId((Node)field), newMetadata);
    }

    private static List<FieldMetadata> readMetadata(Field field, Map<String, List<FieldMetadata>> metadataByFieldId) {
        ArrayList result = metadataByFieldId.get(NodeId.getId((Node)field));
        return result != null ? result : new ArrayList();
    }

    private static List<FieldMetadata> readMetadata(String fieldId, Map<String, List<FieldMetadata>> metadataByFieldId) {
        ArrayList result = metadataByFieldId.get(fieldId);
        return result != null ? result : new ArrayList();
    }
}

