/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.ResultPath;
import graphql.nadel.OperationKind;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.engine.execution.HydrationInputNode;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.ObjectExecutionResultNode;
import graphql.nadel.engine.result.ResultNodeAdapter;
import graphql.nadel.engine.result.RootExecutionResultNode;
import graphql.nadel.util.FpKit;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.util.Breadcrumb;
import graphql.util.NodeAdapter;
import graphql.util.NodeMultiZipper;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import graphql.util.TraverserVisitorStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@Internal
public class StrategyUtil {
    public static List<NodeMultiZipper<ExecutionResultNode>> groupNodesIntoBatchesByField(Collection<NodeZipper<ExecutionResultNode>> nodes, ExecutionResultNode root) {
        Map zipperByField = graphql.util.FpKit.groupingBy(nodes, executionResultZipper -> ((ExecutionResultNode)executionResultZipper.getCurNode()).getFieldIds());
        return graphql.util.FpKit.mapEntries((Map)zipperByField, (key, value) -> new NodeMultiZipper((Object)root, value, (NodeAdapter)ResultNodeAdapter.RESULT_NODE_ADAPTER));
    }

    public static Set<NodeZipper<ExecutionResultNode>> getHydrationInputNodes(ExecutionResultNode roots, final Set<ResultPath> hydrationInputPaths) {
        Comparator comparator = (node1, node2) -> {
            if (node1 == node2) {
                return 0;
            }
            List breadcrumbs1 = node1.getBreadcrumbs();
            List breadcrumbs2 = node2.getBreadcrumbs();
            if (breadcrumbs1.size() != breadcrumbs2.size()) {
                return Integer.compare(breadcrumbs1.size(), breadcrumbs2.size());
            }
            for (int i = breadcrumbs1.size() - 1; i >= 0; --i) {
                int ix2;
                int ix1 = ((Breadcrumb)breadcrumbs1.get(i)).getLocation().getIndex();
                if (ix1 == (ix2 = ((Breadcrumb)breadcrumbs2.get(i)).getLocation().getIndex())) continue;
                return Integer.compare(ix1, ix2);
            }
            return (Integer)Assert.assertShouldNeverHappen();
        };
        final Set<NodeZipper<ExecutionResultNode>> result = Collections.synchronizedSet(new TreeSet(comparator));
        Traverser traverser = Traverser.depthFirst(ExecutionResultNode::getChildren);
        traverser.traverse((Object)roots, (TraverserVisitor)new TraverserVisitorStub<ExecutionResultNode>(){

            public TraversalControl enter(TraverserContext<ExecutionResultNode> context) {
                if (context.thisNode() instanceof HydrationInputNode) {
                    result.add(new NodeZipper((Object)((ExecutionResultNode)context.thisNode()), context.getBreadcrumbs(), (NodeAdapter)ResultNodeAdapter.RESULT_NODE_ADAPTER));
                }
                if (hydrationInputPaths.contains(((ExecutionResultNode)context.thisNode()).getResultPath())) {
                    return TraversalControl.CONTINUE;
                }
                return TraversalControl.ABORT;
            }
        });
        return result;
    }

    public static ExecutionStepInfo createRootExecutionStepInfo(GraphQLSchema graphQLSchema, OperationKind operationKind) {
        ExecutionStepInfo executionInfo = ExecutionStepInfo.newExecutionStepInfo().type((GraphQLOutputType)operationKind.getRootType(graphQLSchema)).path(ResultPath.rootPath()).build();
        return executionInfo;
    }

    public static <T extends ExecutionResultNode> T changeFieldIsInResultNode(T executionResultNode, List<String> fieldIds) {
        return (T)executionResultNode.transform(builder -> builder.fieldIds(fieldIds));
    }

    public static <T extends ExecutionResultNode> T changeFieldIdsInResultNode(T executionResultNode, String fieldId) {
        return (T)executionResultNode.transform(builder -> builder.fieldId(fieldId));
    }

    public static <T extends ExecutionResultNode> T copyFieldInformation(ExecutionResultNode from, T to) {
        return (T)to.transform(builder -> ((ExecutionResultNode.BuilderBase)((ExecutionResultNode.BuilderBase)((ExecutionResultNode.BuilderBase)((ExecutionResultNode.BuilderBase)builder.resultPath(from.getResultPath())).fieldIds(from.getFieldIds())).alias(from.getAlias())).objectType(from.getObjectType())).fieldDefinition(from.getFieldDefinition()));
    }

    public static ExecutionResultNode copyTypeInformation(ExecutionStepInfo from) {
        return ((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)((ObjectExecutionResultNode.Builder)ObjectExecutionResultNode.newObjectExecutionResultNode().fieldIds(NodeId.getIds((MergedField)from.getField()))).objectType(from.getFieldContainer())).fieldDefinition(from.getFieldDefinition())).resultPath(from.getPath())).build();
    }

    public static RootExecutionResultNode mergeTrees(List<RootExecutionResultNode> rootNodes) {
        ArrayList<ExecutionResultNode> mergedChildren = new ArrayList<ExecutionResultNode>();
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        FpKit.map(rootNodes, ExecutionResultNode::getChildren).forEach(mergedChildren::addAll);
        FpKit.map(rootNodes, ExecutionResultNode::getErrors).forEach(errors::addAll);
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        rootNodes.forEach(node -> extensions.putAll(node.getExtensions()));
        Map<String, List<ExecutionResultNode>> resultNodesByResultKey = mergedChildren.stream().collect(Collectors.groupingBy(ExecutionResultNode::getResultKey));
        mergedChildren = new ArrayList();
        for (List<ExecutionResultNode> resultNodes : resultNodesByResultKey.values()) {
            ExecutionResultNode resultNode = resultNodes.get(0);
            if (resultNodes.size() > 1) {
                resultNode = StrategyUtil.combineResultNodes(resultNodes);
            }
            mergedChildren.add(resultNode);
        }
        return ((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)RootExecutionResultNode.newRootExecutionResultNode().children(mergedChildren)).errors(errors)).extensions(extensions)).build();
    }

    private static ExecutionResultNode combineResultNodes(List<ExecutionResultNode> resultNodes) {
        ArrayList<ExecutionResultNode> children = new ArrayList<ExecutionResultNode>();
        LinkedHashMap completedValueMap = new LinkedHashMap();
        List nonNullNodes = FpKit.filter(resultNodes, resultNode -> resultNode.getCompletedValue() != null);
        for (ExecutionResultNode resultNode2 : nonNullNodes) {
            Object completedValue = resultNode2.getCompletedValue();
            Assert.assertTrue((boolean)(resultNode2 instanceof ObjectExecutionResultNode), () -> String.format("We can only combine object fields not %s for result path %s", resultNode2.getClass(), resultNode2.getResultKey()));
            Assert.assertTrue((boolean)(completedValue instanceof Map), () -> String.format("We can only combine object field values that are maps not %s for result path %s", completedValue.getClass(), resultNode2.getResultKey()));
            children.addAll(resultNode2.getChildren());
            Map childValue = (Map)completedValue;
            completedValueMap.putAll(childValue);
        }
        return FpKit.findOne((Collection)nonNullNodes, node -> true).map(objectNode -> objectNode.transform(builder -> ((ExecutionResultNode.BuilderBase)builder.children(children)).completedValue(completedValueMap))).orElse(resultNodes.get(0));
    }
}

