/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectField;
import graphql.language.OperationDefinition;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.nadel.Service;
import graphql.nadel.dsl.ExtendedFieldDefinition;
import graphql.nadel.dsl.FieldMappingDefinition;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.dsl.TypeMappingDefinition;
import graphql.nadel.dsl.UnderlyingServiceHydration;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.engine.execution.ArtificialFieldUtils;
import graphql.nadel.engine.execution.FieldMetadataUtil;
import graphql.nadel.engine.execution.HooksVisitArgumentValueEnvironmentImpl;
import graphql.nadel.engine.execution.TransformationState;
import graphql.nadel.engine.execution.UnderlyingTypeContext;
import graphql.nadel.engine.execution.transformation.ApplyEnvironment;
import graphql.nadel.engine.execution.transformation.ApplyResult;
import graphql.nadel.engine.execution.transformation.FieldRenameTransformation;
import graphql.nadel.engine.execution.transformation.FieldTransformation;
import graphql.nadel.engine.execution.transformation.HydrationTransformation;
import graphql.nadel.engine.execution.transformation.OverallTypeInfo;
import graphql.nadel.engine.execution.transformation.OverallTypeInformation;
import graphql.nadel.engine.execution.transformation.TransformationMetadata;
import graphql.nadel.hooks.HooksVisitArgumentValueEnvironment;
import graphql.nadel.hooks.NewVariableValue;
import graphql.nadel.hooks.ServiceExecutionHooks;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.nadel.normalized.NormalizedQueryFromAst;
import graphql.nadel.schema.NadelDirectives;
import graphql.nadel.util.FpKit;
import graphql.nadel.util.Util;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputValueDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class Transformer
extends NodeVisitorStub {
    private final ValuesResolver valuesResolver = new ValuesResolver();
    final ExecutionContext executionContext;
    final GraphQLSchema underlyingSchema;
    final Set<String> referencedFragmentNames;
    final Map<String, VariableDefinition> referencedVariables;
    final NadelContext nadelContext;
    private final Map<String, VariableDefinition> variableDefinitions;
    final ServiceExecutionHooks serviceExecutionHooks;
    private OverallTypeInformation<?> overallTypeInformation;
    private TransformationMetadata transformationMetadata;
    private Map<NormalizedQueryField, GraphQLError> forbiddenFields;
    private Service service;
    private Object serviceContext;
    private Map<String, Object> variableValues;
    private TransformationState transformations;

    public Transformer(ExecutionContext executionContext, GraphQLSchema underlyingSchema, Set<String> referencedFragmentNames, Map<String, VariableDefinition> referencedVariables, NadelContext nadelContext, ServiceExecutionHooks serviceExecutionHooks, OverallTypeInformation overallTypeInformation, Map<String, Object> variableValues, Service service, Object serviceContext, TransformationMetadata transformationMetadata, Map<NormalizedQueryField, GraphQLError> forbiddenFields, TransformationState transformations) {
        this.executionContext = executionContext;
        this.underlyingSchema = underlyingSchema;
        this.referencedFragmentNames = referencedFragmentNames;
        this.referencedVariables = referencedVariables;
        this.nadelContext = nadelContext;
        this.serviceExecutionHooks = serviceExecutionHooks;
        this.overallTypeInformation = overallTypeInformation;
        this.transformationMetadata = transformationMetadata;
        this.forbiddenFields = forbiddenFields;
        OperationDefinition operationDefinition = executionContext.getOperationDefinition();
        this.variableDefinitions = FpKit.getByName((List)operationDefinition.getVariableDefinitions(), VariableDefinition::getName);
        this.variableValues = variableValues;
        this.service = service;
        this.serviceContext = serviceContext;
        this.transformations = transformations;
    }

    public TraversalControl visitVariableReference(VariableReference variableReference, TraverserContext<Node> context) {
        VariableDefinition variableDefinition = this.variableDefinitions.get(variableReference.getName());
        this.referencedVariables.put(variableDefinition.getName(), variableDefinition);
        return super.visitVariableReference(variableReference, context);
    }

    public TraversalControl visitObjectField(ObjectField node, TraverserContext<Node> context) {
        UnderlyingTypeContext underlyingTypeContext = (UnderlyingTypeContext)context.getVarFromParents(UnderlyingTypeContext.class);
        GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll((GraphQLType)underlyingTypeContext.getInputValueDefinitionUnderlying().getType());
        if (unmodifiedType instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)unmodifiedType;
            GraphQLInputObjectField inputObjectTypeField = inputObjectType.getField(node.getName());
            underlyingTypeContext = underlyingTypeContext.transform(builder -> builder.inputValueDefinitionUnderlying((GraphQLInputValueDefinition)inputObjectTypeField));
            context.setVar(UnderlyingTypeContext.class, (Object)underlyingTypeContext);
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitArgument(Argument argument, TraverserContext<Node> context) {
        UnderlyingTypeContext underlyingTypeContext = (UnderlyingTypeContext)context.getVarFromParents(UnderlyingTypeContext.class);
        GraphQLFieldDefinition fieldDefinition = underlyingTypeContext.getFieldDefinitionUnderlying();
        GraphQLArgument graphQLArgument = fieldDefinition.getArgument(argument.getName());
        String argumentName = graphQLArgument.getName();
        Object argumentValue = underlyingTypeContext.getFieldArgumentValues().getOrDefault(argumentName, null);
        UnderlyingTypeContext newContext = underlyingTypeContext.transform(builder -> builder.argumentValue(argumentValue).argumentDefinitionUnderlying(graphQLArgument).inputValueDefinitionUnderlying((GraphQLInputValueDefinition)graphQLArgument));
        context.setVar(UnderlyingTypeContext.class, (Object)newContext);
        return TraversalControl.CONTINUE;
    }

    protected TraversalControl visitValue(Value<?> value, TraverserContext<Node> context) {
        OverallTypeInfo overallTypeInfo;
        UnderlyingTypeContext typeContext = (UnderlyingTypeContext)context.getVarFromParents(UnderlyingTypeContext.class);
        GraphQLInputValueDefinition inputValueDefinition = typeContext.getInputValueDefinitionUnderlying();
        HooksVisitArgumentValueEnvironmentImpl hooksVisitArgumentValueEnvironment = new HooksVisitArgumentValueEnvironmentImpl(inputValueDefinition, (overallTypeInfo = this.overallTypeInformation.getOverallTypeInfo(NodeId.getId(value))).getGraphQLInputValueDefinition(), typeContext.getArgumentDefinitionUnderlying(), overallTypeInfo.getGraphQLArgument(), context, value, this.variableValues, this.service, this.serviceContext);
        NewVariableValue newVariableValue = this.serviceExecutionHooks.visitArgumentValueInQuery((HooksVisitArgumentValueEnvironment)hooksVisitArgumentValueEnvironment);
        if (newVariableValue != null) {
            this.variableValues.put(newVariableValue.getName(), newVariableValue.getValue());
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitField(Field field, TraverserContext<Node> context) {
        if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
            return TraversalControl.CONTINUE;
        }
        UnderlyingTypeContext typeContext = (UnderlyingTypeContext)context.getVarFromParents(UnderlyingTypeContext.class);
        OverallTypeInfo overallTypeInfo = this.overallTypeInformation.getOverallTypeInfo(NodeId.getId((Node)field));
        if (overallTypeInfo == null) {
            this.updateTypeContext(context, typeContext.getOutputTypeUnderlying());
            return TraversalControl.CONTINUE;
        }
        GraphQLFieldDefinition fieldDefinitionOverall = overallTypeInfo.getFieldDefinition();
        GraphQLNamedOutputType fieldTypeOverall = (GraphQLNamedOutputType)GraphQLTypeUtil.unwrapAll((GraphQLType)fieldDefinitionOverall.getType());
        String fieldContainerName = overallTypeInfo.getFieldsContainer().getName();
        NormalizedQueryFromAst normalizedOverallQuery = this.nadelContext.getNormalizedOverallQuery();
        List normalizedFields = normalizedOverallQuery.getNormalizedFieldsByFieldId(NodeId.getId((Node)field));
        int numberOfRemovedNormalizedFields = FpKit.filter((Collection)normalizedFields, normalizedField -> {
            GraphQLError forbiddenFieldError = this.forbiddenFields.get(normalizedField);
            if (forbiddenFieldError == null) {
                return false;
            }
            this.transformationMetadata.removeField((NormalizedQueryField)normalizedField, forbiddenFieldError);
            return true;
        }).size();
        if (!normalizedFields.isEmpty() && numberOfRemovedNormalizedFields == normalizedFields.size()) {
            return TreeTransformerUtil.deleteNode(context);
        }
        this.extractAndRecordTypeMappingDefinition(fieldTypeOverall.getName());
        FieldTransformation transformation = this.createTransformation(fieldDefinitionOverall);
        if (transformation != null) {
            ApplyEnvironment applyEnvironment = this.createApplyEnvironment(field, context, overallTypeInfo, normalizedFields, this.executionContext.getFragmentsByName());
            ApplyResult applyResult = transformation.apply(applyEnvironment);
            Field changedField = (Field)applyEnvironment.getTraverserContext().thisNode();
            String transformationId = FieldMetadataUtil.getUniqueRootTransformationId(changedField, this.transformationMetadata.getMetadataByFieldId());
            this.transformations.putTransformationIdToTransformation(transformationId, transformation);
            this.transformations.putTransformationToFieldId(transformation, NodeId.getId((Node)changedField));
            if (transformation instanceof FieldRenameTransformation) {
                this.maybeAddUnderscoreTypeName(context, changedField, (GraphQLOutputType)fieldTypeOverall);
            }
            if (applyResult.getTraversalControl() == TraversalControl.CONTINUE) {
                this.updateTypeContext(context, typeContext.getOutputTypeUnderlying(), fieldContainerName);
            }
            return applyResult.getTraversalControl();
        }
        this.maybeAddUnderscoreTypeName(context, field, (GraphQLOutputType)fieldTypeOverall);
        this.updateTypeContext(context, typeContext.getOutputTypeUnderlying(), fieldContainerName);
        return TraversalControl.CONTINUE;
    }

    private void updateTypeContext(TraverserContext<Node> context, GraphQLOutputType currentOutputTypeUnderlying) {
        this.updateTypeContext(context, currentOutputTypeUnderlying, null);
    }

    private void updateTypeContext(TraverserContext<Node> context, GraphQLOutputType currentOutputTypeUnderlying, String fieldContainerName) {
        Field newField = (Field)context.thisNode();
        GraphQLFieldsContainer fieldsContainerUnderlying = (GraphQLFieldsContainer)GraphQLTypeUtil.unwrapAll((GraphQLType)currentOutputTypeUnderlying);
        Assert.assertTrue((boolean)(fieldsContainerUnderlying instanceof GraphQLFieldsContainer), () -> String.format("Schema mismatch: The underlying schema is missing required interface type %s", fieldContainerName));
        GraphQLFieldDefinition fieldDefinitionUnderlying = Introspection.getFieldDef((GraphQLSchema)this.underlyingSchema, (GraphQLCompositeType)fieldsContainerUnderlying, (String)newField.getName());
        GraphQLOutputType newOutputTypeUnderlying = fieldDefinitionUnderlying.getType();
        Map argumentValues = this.valuesResolver.getArgumentValues(this.underlyingSchema.getCodeRegistry(), fieldDefinitionUnderlying.getArguments(), newField.getArguments(), this.executionContext.getVariables());
        UnderlyingTypeContext.Builder newTypeContext = UnderlyingTypeContext.newUnderlyingTypeContext().field(newField).outputTypeUnderlying(newOutputTypeUnderlying).fieldsContainerUnderlying(fieldsContainerUnderlying).fieldDefinitionUnderlying(fieldDefinitionUnderlying).fieldArgumentValues(argumentValues);
        context.setVar(UnderlyingTypeContext.class, (Object)newTypeContext.build());
    }

    ApplyEnvironment createApplyEnvironment(Field field, TraverserContext<Node> context, OverallTypeInfo overallTypeInfo, List<NormalizedQueryField> normalizedQueryFields, Map<String, FragmentDefinition> fragmentDefinitionMap) {
        return new ApplyEnvironment(field, overallTypeInfo.getFieldDefinition(), overallTypeInfo.getFieldsContainer(), context, normalizedQueryFields, this.transformationMetadata.getMetadataByFieldId(), fragmentDefinitionMap, this.underlyingSchema, this.nadelContext);
    }

    private void maybeAddUnderscoreTypeName(TraverserContext<Node> traverserContext, Field field, GraphQLOutputType fieldType) {
        Field changedNode = ArtificialFieldUtils.maybeAddUnderscoreTypeName(this.nadelContext, field, fieldType);
        if (changedNode != field) {
            TreeTransformerUtil.changeNode(traverserContext, (Object)changedNode);
            this.transformations.addHintTypename(changedNode.getName());
        }
    }

    public TraversalControl visitInlineFragment(InlineFragment inlineFragment, TraverserContext<Node> context) {
        TypeName typeCondition = inlineFragment.getTypeCondition();
        if (typeCondition == null) {
            return TraversalControl.CONTINUE;
        }
        TypeMappingDefinition typeMappingDefinition = this.typeTransformationForFragment(this.executionContext, typeCondition);
        String underlyingTypeName = typeCondition.getName();
        if (typeMappingDefinition != null) {
            this.recordTypeRename(typeMappingDefinition);
            InlineFragment changedFragment = inlineFragment.transform(f -> {
                TypeName newTypeName = TypeName.newTypeName((String)typeMappingDefinition.getUnderlyingName()).build();
                f.typeCondition(newTypeName);
            });
            underlyingTypeName = typeMappingDefinition.getUnderlyingName();
            TreeTransformerUtil.changeNode(context, (Object)changedFragment);
        }
        this.updateTypeContextForInlineFragment(underlyingTypeName, context);
        return TraversalControl.CONTINUE;
    }

    private void updateTypeContextForInlineFragment(String underlyingType, TraverserContext<Node> context) {
        UnderlyingTypeContext typeContext = (UnderlyingTypeContext)context.getVarFromParents(UnderlyingTypeContext.class);
        GraphQLCompositeType fragmentConditionUnderlying = (GraphQLCompositeType)this.underlyingSchema.getType(underlyingType);
        context.setVar(UnderlyingTypeContext.class, (Object)typeContext.transform(builder -> builder.outputTypeUnderlying((GraphQLOutputType)fragmentConditionUnderlying)));
    }

    public TraversalControl visitFragmentDefinition(FragmentDefinition fragment, TraverserContext<Node> context) {
        TypeName typeName = fragment.getTypeCondition();
        TypeMappingDefinition typeMappingDefinition = this.typeTransformationForFragment(this.executionContext, typeName);
        String underlyingTypeName = typeName.getName();
        if (typeMappingDefinition != null) {
            this.recordTypeRename(typeMappingDefinition);
            FragmentDefinition changedFragment = fragment.transform(f -> {
                TypeName newTypeName = TypeName.newTypeName((String)typeMappingDefinition.getUnderlyingName()).build();
                f.typeCondition(newTypeName);
            });
            underlyingTypeName = typeMappingDefinition.getUnderlyingName();
            TreeTransformerUtil.changeNode(context, (Object)changedFragment);
        }
        this.updateTypeContextForFragmentDefinition(fragment, underlyingTypeName, context);
        return TraversalControl.CONTINUE;
    }

    private void updateTypeContextForFragmentDefinition(FragmentDefinition fragmentDefinition, String underlyingTypeName, TraverserContext<Node> context) {
        UnderlyingTypeContext typeContext = (UnderlyingTypeContext)context.getVarFromParents(UnderlyingTypeContext.class);
        GraphQLCompositeType fragmentConditionUnderlying = (GraphQLCompositeType)this.underlyingSchema.getType(underlyingTypeName);
        context.setVar(UnderlyingTypeContext.class, (Object)typeContext.transform(builder -> builder.outputTypeUnderlying((GraphQLOutputType)fragmentConditionUnderlying)));
    }

    public TraversalControl visitFragmentSpread(FragmentSpread fragmentSpread, TraverserContext<Node> context) {
        this.referencedFragmentNames.add(fragmentSpread.getName());
        return TraversalControl.CONTINUE;
    }

    private TypeMappingDefinition recordTypeRename(TypeMappingDefinition typeMappingDefinition) {
        if (typeMappingDefinition != null) {
            this.transformations.putTypeRenameMapping(typeMappingDefinition.getUnderlyingName(), typeMappingDefinition.getOverallName());
        }
        return typeMappingDefinition;
    }

    private TypeMappingDefinition typeTransformationForFragment(ExecutionContext executionContext, TypeName typeNameOverall) {
        GraphQLType type = executionContext.getGraphQLSchema().getType(typeNameOverall.getName());
        Assert.assertTrue((boolean)(type instanceof GraphQLFieldsContainer), () -> String.format("Expected type '%s' to be an field container type", typeNameOverall));
        return this.extractAndRecordTypeMappingDefinition(executionContext.getGraphQLSchema(), type);
    }

    private TypeMappingDefinition extractAndRecordTypeMappingDefinition(String typeNameOverall) {
        GraphQLType type = this.executionContext.getGraphQLSchema().getType(typeNameOverall);
        return this.extractAndRecordTypeMappingDefinition(this.executionContext.getGraphQLSchema(), type);
    }

    private TypeMappingDefinition extractAndRecordTypeMappingDefinition(GraphQLSchema graphQLSchema, GraphQLType type) {
        TypeMappingDefinition typeMappingDefinition = Util.getTypeMappingDefinitionFor((GraphQLType)type);
        this.recordTypeRename(typeMappingDefinition);
        if (type instanceof GraphQLInterfaceType) {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)type;
            graphQLSchema.getImplementations(interfaceType).forEach(objectType -> this.extractAndRecordTypeMappingDefinition(graphQLSchema, (GraphQLType)objectType));
        }
        if (type instanceof GraphQLUnionType) {
            GraphQLUnionType unionType = (GraphQLUnionType)type;
            unionType.getTypes().forEach(typeMember -> this.extractAndRecordTypeMappingDefinition(graphQLSchema, (GraphQLType)typeMember));
        }
        return typeMappingDefinition;
    }

    private graphql.nadel.dsl.FieldTransformation transformationDefinitionForField(FieldDefinition definition) {
        if (definition instanceof ExtendedFieldDefinition) {
            return ((ExtendedFieldDefinition)definition).getFieldTransformation();
        }
        return null;
    }

    private FieldTransformation createTransformation(GraphQLFieldDefinition fieldDefinitionOverallSchema) {
        List hydrations = NadelDirectives.createUnderlyingServiceHydration((GraphQLFieldDefinition)fieldDefinitionOverallSchema, (GraphQLSchema)this.executionContext.getGraphQLSchema());
        if (!hydrations.isEmpty()) {
            return new HydrationTransformation((UnderlyingServiceHydration)hydrations.get(0));
        }
        FieldMappingDefinition mappingDefinition = NadelDirectives.createFieldMapping((GraphQLFieldDefinition)fieldDefinitionOverallSchema);
        if (mappingDefinition != null) {
            return new FieldRenameTransformation(mappingDefinition);
        }
        graphql.nadel.dsl.FieldTransformation definition = this.transformationDefinitionForField(fieldDefinitionOverallSchema.getDefinition());
        if (definition == null) {
            return null;
        }
        if (definition.getFieldMappingDefinition() != null) {
            return new FieldRenameTransformation(definition.getFieldMappingDefinition());
        }
        if (definition.getUnderlyingServiceHydration() != null) {
            return new HydrationTransformation(definition.getUnderlyingServiceHydration());
        }
        return (FieldTransformation)Assert.assertShouldNeverHappen();
    }
}

