/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.ResultPath;
import graphql.language.AbstractNode;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.SelectionSet;
import graphql.nadel.dsl.ObjectTypeDefinitionWithTransformation;
import graphql.nadel.dsl.RemoteArgumentDefinition;
import graphql.nadel.dsl.RemoteArgumentSource;
import graphql.nadel.dsl.TypeMappingDefinition;
import graphql.nadel.dsl.UnderlyingServiceHydration;
import graphql.nadel.engine.execution.ArtificialFieldUtils;
import graphql.nadel.engine.execution.ExecutionResultNodeMapper;
import graphql.nadel.engine.execution.HydrationInputNode;
import graphql.nadel.engine.execution.PathMapper;
import graphql.nadel.engine.execution.UnapplyEnvironment;
import graphql.nadel.engine.execution.transformation.ApplyEnvironment;
import graphql.nadel.engine.execution.transformation.ApplyResult;
import graphql.nadel.engine.execution.transformation.FieldTransformation;
import graphql.nadel.engine.execution.transformation.FieldUtils;
import graphql.nadel.engine.execution.transformation.UnapplyResult;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.LeafExecutionResultNode;
import graphql.nadel.engine.result.ListExecutionResultNode;
import graphql.nadel.engine.result.ObjectExecutionResultNode;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.nadel.schema.NadelDirectives;
import graphql.nadel.util.FpKit;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Internal
public class HydrationTransformation
extends FieldTransformation {
    private final UnderlyingServiceHydration underlyingServiceHydration;
    ExecutionResultNodeMapper executionResultNodeMapper = new ExecutionResultNodeMapper();
    PathMapper pathMapper = new PathMapper();

    public HydrationTransformation(UnderlyingServiceHydration underlyingServiceHydration) {
        this.underlyingServiceHydration = underlyingServiceHydration;
    }

    @Override
    public AbstractNode getDefinition() {
        return this.underlyingServiceHydration;
    }

    @Override
    public ApplyResult apply(ApplyEnvironment environment) {
        this.setEnvironment(environment);
        TraverserContext<Node> context = environment.getTraverserContext();
        List arguments = this.underlyingServiceHydration.getArguments();
        List sourceValues = FpKit.filter((Collection)arguments, argument -> argument.getRemoteArgumentSource().getSourceType() == RemoteArgumentSource.SourceType.OBJECT_FIELD);
        RemoteArgumentSource remoteArgumentSource = ((RemoteArgumentDefinition)sourceValues.get(0)).getRemoteArgumentSource();
        List hydrationSourceName = remoteArgumentSource.getPath();
        String transformationId = this.getTransformationId();
        Field newField = FieldUtils.pathToFields(hydrationSourceName, environment.getField(), transformationId, Collections.emptyList(), true, environment.getMetadataByFieldId());
        newField = HydrationTransformation.maybeAddTypenameToInterfaceField(environment, hydrationSourceName, newField).orElse(newField);
        List argumentValues = FpKit.filter((Collection)arguments, argument -> argument.getRemoteArgumentSource().getSourceType() == RemoteArgumentSource.SourceType.FIELD_ARGUMENT);
        Assert.assertTrue((sourceValues.size() + argumentValues.size() == arguments.size() ? 1 : 0) != 0, () -> "only $source and $argument values for arguments are supported");
        TreeTransformerUtil.changeNode(context, (Object)newField);
        if (sourceValues.size() > 1) {
            this.addExtraSourceArgumentFields(environment, transformationId, sourceValues.subList(1, sourceValues.size()));
        }
        return new ApplyResult(TraversalControl.ABORT);
    }

    public void addExtraSourceArgumentFields(ApplyEnvironment environment, String transformationId, List<RemoteArgumentDefinition> remoteArgumentDefinitions) {
        for (RemoteArgumentDefinition remoteArgumentDefinition : remoteArgumentDefinitions) {
            List hydrationSourceName = remoteArgumentDefinition.getRemoteArgumentSource().getPath();
            Field extraSourceArgumentField = FieldUtils.pathToFields(hydrationSourceName, environment.getField(), transformationId, Collections.emptyList(), true, environment.getMetadataByFieldId());
            TreeTransformerUtil.insertAfter(environment.getTraverserContext(), (Object)extraSourceArgumentField);
        }
    }

    public UnderlyingServiceHydration getUnderlyingServiceHydration() {
        return this.underlyingServiceHydration;
    }

    @Override
    public UnapplyResult unapplyResultNode(ExecutionResultNode node, List<FieldTransformation> allTransformations, UnapplyEnvironment environment) {
        NormalizedQueryField matchingNormalizedOverallField = this.getMatchingNormalizedQueryFieldBasedOnParent(environment.correctParentNode);
        if (node instanceof ListExecutionResultNode) {
            ExecutionResultNode child;
            if (node.getChildren().size() == 0) {
                return this.handleEmptyList((ListExecutionResultNode)node, allTransformations, environment, matchingNormalizedOverallField);
            }
            if (environment.correctParentNode == environment.directParentNode) {
                environment.correctParentNode = node;
            }
            if ((child = node.getChildren().get(0)) instanceof LeafExecutionResultNode) {
                return this.handleListOfLeafs((ListExecutionResultNode)node, allTransformations, environment, matchingNormalizedOverallField);
            }
            if (child instanceof ObjectExecutionResultNode) {
                return this.handleListOfObjects((ListExecutionResultNode)node, allTransformations, environment, matchingNormalizedOverallField);
            }
            return (UnapplyResult)Assert.assertShouldNeverHappen((String)"Not implemented yet", (Object[])new Object[0]);
        }
        LeafExecutionResultNode leafNode = FieldUtils.getFirstLeafNode(node);
        LeafExecutionResultNode changedNode = this.unapplyLeafNode(leafNode, allTransformations, environment, matchingNormalizedOverallField);
        return new UnapplyResult(changedNode, TraversalControl.ABORT);
    }

    private UnapplyResult handleEmptyList(ListExecutionResultNode listNode, List<FieldTransformation> allTransformations, UnapplyEnvironment environment, NormalizedQueryField matchingNormalizedOverallField) {
        ExecutionResultNode changedList = this.mapToOverallFieldAndTypes(listNode, allTransformations, matchingNormalizedOverallField);
        return new UnapplyResult(changedList, TraversalControl.ABORT);
    }

    private UnapplyResult handleListOfObjects(ListExecutionResultNode transformedNode, List<FieldTransformation> allTransformations, UnapplyEnvironment environment, NormalizedQueryField matchingNormalizedField) {
        ExecutionResultNode mappedNode = this.mapToOverallFieldAndTypes(transformedNode, allTransformations, matchingNormalizedField);
        ExecutionResultNode changedNode = FieldUtils.mapChildren(mappedNode, objectChild -> {
            LeafExecutionResultNode leaf = (LeafExecutionResultNode)objectChild.getChildren().get(0);
            return this.unapplyLeafNode(leaf, allTransformations, environment, matchingNormalizedField);
        });
        return new UnapplyResult(changedNode, TraversalControl.ABORT);
    }

    private UnapplyResult handleListOfLeafs(ListExecutionResultNode listExecutionResultNode, List<FieldTransformation> allTransformations, UnapplyEnvironment environment, NormalizedQueryField matchingNormalizedField) {
        ExecutionResultNode mappedNode = this.mapToOverallFieldAndTypes(listExecutionResultNode, allTransformations, matchingNormalizedField);
        ArrayList<ExecutionResultNode> newChildren = new ArrayList<ExecutionResultNode>();
        for (ExecutionResultNode leafNode : listExecutionResultNode.getChildren()) {
            LeafExecutionResultNode newChild = this.unapplyLeafNode((LeafExecutionResultNode)leafNode, allTransformations, environment, matchingNormalizedField);
            newChildren.add(newChild);
        }
        ExecutionResultNode changedNode = mappedNode.withNewChildren(newChildren);
        return new UnapplyResult(changedNode, TraversalControl.ABORT);
    }

    private LeafExecutionResultNode unapplyLeafNode(LeafExecutionResultNode leafNode, List<FieldTransformation> allTransformations, UnapplyEnvironment environment, NormalizedQueryField matchingNormalizedField) {
        leafNode = (LeafExecutionResultNode)this.mapToOverallFieldAndTypes(leafNode, allTransformations, matchingNormalizedField);
        ResultPath executionPath = this.pathMapper.mapPath(leafNode.getResultPath(), leafNode.getResultKey(), environment);
        leafNode = ((LeafExecutionResultNode)leafNode).transform(builder -> builder.resultPath(executionPath));
        SelectionSet.Builder selectionSetBuilder = SelectionSet.newSelectionSet();
        for (FieldTransformation fieldTransformation : allTransformations) {
            fieldTransformation.getOriginalField().getSelectionSet().getSelections().forEach(arg_0 -> ((SelectionSet.Builder)selectionSetBuilder).selection(arg_0));
        }
        SelectionSet selectionSet = selectionSetBuilder.build();
        if (leafNode.isNullValue()) {
            return leafNode;
        }
        return ((HydrationInputNode.Builder)((HydrationInputNode.Builder)((HydrationInputNode.Builder)((HydrationInputNode.Builder)((HydrationInputNode.Builder)((HydrationInputNode.Builder)((HydrationInputNode.Builder)HydrationInputNode.newHydrationInputNode().hydrationTransformation(this).selectionSet(selectionSet).alias(leafNode.getAlias())).fieldIds(leafNode.getFieldIds())).objectType(leafNode.getObjectType())).fieldDefinition(leafNode.getFieldDefinition())).resultPath(leafNode.getResultPath())).completedValue(leafNode.getCompletedValue())).elapsedTime(leafNode.getElapsedTime())).normalizedField(matchingNormalizedField).build();
    }

    private static Optional<Field> maybeAddTypenameToInterfaceField(ApplyEnvironment environment, List<String> hydrationSourceName, Field newField) {
        TypeMappingDefinition typeMapping;
        boolean isDeepSourceHydration;
        boolean bl = isDeepSourceHydration = hydrationSourceName.size() > 1;
        if (!isDeepSourceHydration) {
            return Optional.empty();
        }
        GraphQLFieldsContainer fieldsContainerOverall = environment.getFieldsContainerOverall();
        Node definition = fieldsContainerOverall.getDefinition();
        String underlyingTypeName = fieldsContainerOverall.getName();
        if (definition instanceof ObjectTypeDefinitionWithTransformation) {
            underlyingTypeName = ((ObjectTypeDefinitionWithTransformation)definition).getTypeMappingDefinition().getUnderlyingName();
        } else if (fieldsContainerOverall instanceof GraphQLDirectiveContainer && (typeMapping = NadelDirectives.createTypeMapping((GraphQLDirectiveContainer)((GraphQLDirectiveContainer)fieldsContainerOverall))) != null) {
            underlyingTypeName = typeMapping.getUnderlyingName();
        }
        String fieldToHydrateFrom = hydrationSourceName.get(0);
        String finalUnderlyingTypeName = underlyingTypeName;
        GraphQLFieldsContainer underlyingParentType = (GraphQLFieldsContainer)Assert.assertNotNull((Object)environment.getUnderlyingSchema().getType(underlyingTypeName), () -> String.format("No underlying type found for %s", finalUnderlyingTypeName));
        GraphQLFieldDefinition fieldDefinition = (GraphQLFieldDefinition)Assert.assertNotNull((Object)underlyingParentType.getFieldDefinition(fieldToHydrateFrom), () -> String.format("No field named %s found for type %s", fieldToHydrateFrom, underlyingParentType.getName()));
        GraphQLUnmodifiedType underlyingType = GraphQLTypeUtil.unwrapAll((GraphQLType)fieldDefinition.getType());
        if (underlyingType instanceof GraphQLInterfaceType) {
            return Optional.of(ArtificialFieldUtils.maybeAddUnderscoreTypeName(environment.getNadelContext(), newField, (GraphQLOutputType)((GraphQLInterfaceType)underlyingType)));
        }
        return Optional.empty();
    }
}

