/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.engine.execution.transformation.FieldMetadata;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.schema.GraphQLFieldDefinition;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
public class TransformationMetadata {
    private final List<NormalizedFieldAndError> removedFields = new ArrayList<NormalizedFieldAndError>();
    private final Map<String, List<FieldMetadata>> metadataByFieldId = new LinkedHashMap<String, List<FieldMetadata>>();

    public void removeField(NormalizedQueryField field, GraphQLError error) {
        this.removedFields.add(new NormalizedFieldAndError(field, error));
    }

    public List<NormalizedFieldAndError> getRemovedFieldsForParent(NormalizedQueryField parent) {
        ArrayList<NormalizedFieldAndError> result = new ArrayList<NormalizedFieldAndError>();
        for (NormalizedFieldAndError fieldAndError : this.removedFields) {
            if (fieldAndError.normalizedField.getParent() != parent) continue;
            result.add(fieldAndError);
        }
        return result;
    }

    public Optional<NormalizedFieldAndError> getRemovedFieldById(String id) {
        for (NormalizedFieldAndError fieldAndError : this.removedFields) {
            String fieldId = NodeId.getId((GraphQLFieldDefinition)fieldAndError.normalizedField.getFieldDefinition());
            if (!id.equals(fieldId)) continue;
            return Optional.of(fieldAndError);
        }
        return Optional.empty();
    }

    public boolean hasRemovedFields() {
        return !this.removedFields.isEmpty();
    }

    public Map<String, List<FieldMetadata>> getMetadataByFieldId() {
        return this.metadataByFieldId;
    }

    public static class NormalizedFieldAndError {
        private final NormalizedQueryField normalizedField;
        private final GraphQLError error;

        public NormalizedFieldAndError(NormalizedQueryField normalizedField, GraphQLError error) {
            this.normalizedField = normalizedField;
            this.error = error;
        }

        public NormalizedQueryField getNormalizedField() {
            return this.normalizedField;
        }

        public GraphQLError getError() {
            return this.error;
        }
    }
}

