/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation.variables;

import graphql.PublicApi;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInputValueDefinition;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;

@PublicApi
public class InputValueTree {
    private final String name;
    private final GraphQLInputType inputType;
    private final GraphQLInputValueDefinition valueDefinition;
    private final InputValueTree parent;

    public InputValueTree(InputValueTree parent, String name, GraphQLInputType inputType, GraphQLInputValueDefinition valueDefinition) {
        this.parent = parent;
        this.valueDefinition = valueDefinition;
        this.inputType = inputType;
        this.name = name;
    }

    public InputValueTree unwrapOne() {
        return new InputValueTree(this.parent, this.name, (GraphQLInputType)GraphQLTypeUtil.unwrapOne((GraphQLType)this.inputType), this.valueDefinition);
    }

    public InputValueTree getTopLevel() {
        InputValueTree tree = this;
        while (tree.parent != null) {
            tree = tree.parent;
        }
        return tree;
    }

    public String getName() {
        return this.name;
    }

    public InputValueTree getParent() {
        return this.parent;
    }

    public GraphQLInputType getInputType() {
        return this.inputType;
    }

    public GraphQLInputValueDefinition getValueDefinition() {
        return this.valueDefinition;
    }

    public String toString() {
        return "InputValueTree{name='" + this.name + "', inputType=" + this.inputType + ", valueDefinition=" + this.valueDefinition + ", parent=" + this.parent + "}";
    }
}

