/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.result;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.ResultPath;
import graphql.nadel.engine.result.ElapsedTime;
import graphql.nadel.engine.result.NonNullableFieldWasNullError;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@Internal
public abstract class ExecutionResultNode {
    private final Object completedValue;
    private final NonNullableFieldWasNullError nonNullableFieldWasNullError;
    private final List<ExecutionResultNode> children;
    private final List<GraphQLError> errors;
    private final Map<String, Object> extensions;
    private final ElapsedTime elapsedTime;
    private final int totalNodeCount;
    private final int totalFieldRenameCount;
    private final int totalTypeRenameCount;
    private final ResultPath executionPath;
    private final String alias;
    private final List<String> fieldIds;
    private final GraphQLFieldDefinition fieldDefinition;
    private final GraphQLObjectType objectType;

    protected ExecutionResultNode(BuilderBase builderBase) {
        this.completedValue = builderBase.completedValue;
        this.children = Collections.unmodifiableList((List)Assert.assertNotNull(builderBase.children));
        this.children.forEach(Assert::assertNotNull);
        this.errors = Collections.unmodifiableList(builderBase.errors);
        this.extensions = builderBase.extensions;
        this.elapsedTime = builderBase.elapsedTime;
        this.totalNodeCount = builderBase.totalNodeCount;
        this.totalFieldRenameCount = builderBase.totalFieldRenameCount;
        this.totalTypeRenameCount = builderBase.totalTypeRenameCount;
        this.executionPath = (ResultPath)Assert.assertNotNull((Object)builderBase.resultPath);
        this.alias = builderBase.alias;
        this.fieldIds = builderBase.fieldIds;
        this.fieldDefinition = builderBase.fieldDefinition;
        this.objectType = builderBase.objectType;
        this.nonNullableFieldWasNullError = builderBase.nonNullableFieldWasNullError;
    }

    public ElapsedTime getElapsedTime() {
        return this.elapsedTime;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public Object getCompletedValue() {
        return this.completedValue;
    }

    public boolean isNullValue() {
        return this.completedValue == null;
    }

    public String getResultKey() {
        return this.alias != null ? this.alias : this.fieldDefinition.getName();
    }

    public String getAlias() {
        return this.alias;
    }

    public List<String> getFieldIds() {
        return this.fieldIds;
    }

    public String getFieldName() {
        return this.fieldDefinition.getName();
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public GraphQLObjectType getObjectType() {
        return this.objectType;
    }

    public NonNullableFieldWasNullError getNonNullableFieldWasNullError() {
        return this.nonNullableFieldWasNullError;
    }

    public List<ExecutionResultNode> getChildren() {
        return this.children;
    }

    public int getTotalNodeCount() {
        return this.totalNodeCount;
    }

    public int getTotalFieldRenameCount() {
        return this.totalFieldRenameCount;
    }

    public int getTotalTypeRenameCount() {
        return this.totalTypeRenameCount;
    }

    public ResultPath getResultPath() {
        return this.executionPath;
    }

    public ExecutionResultNode withNewChildren(List<ExecutionResultNode> children) {
        return this.transform(builder -> builder.children(children));
    }

    public ExecutionResultNode withNewCompletedValue(Object completedValue) {
        return this.transform(builder -> builder.completedValue(completedValue));
    }

    public ExecutionResultNode withNewErrors(List<GraphQLError> errors) {
        return this.transform(builder -> builder.errors(errors));
    }

    public ExecutionResultNode withElapsedTime(ElapsedTime elapsedTime) {
        return this.transform(builder -> builder.elapsedTime(elapsedTime));
    }

    public abstract <B extends BuilderBase<B>> ExecutionResultNode transform(Consumer<B> var1);

    public ExecutionResultNode withNodeCount(int nodeCount) {
        return this.transform(builder -> builder.totalNodeCount(nodeCount));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{path=" + this.executionPath + ", objectType=" + (this.objectType != null ? this.objectType.getName() : "null") + ", name=" + (this.fieldDefinition != null ? this.fieldDefinition.getName() : "null") + ", alias=" + this.alias + ", completedValue=" + this.completedValue + ", nonNullableFieldWasNullError=" + this.nonNullableFieldWasNullError + ", children.size=" + this.children.size() + ", errors=" + this.errors + "}";
    }

    public static abstract class BuilderBase<T extends BuilderBase<T>> {
        protected Object completedValue;
        protected NonNullableFieldWasNullError nonNullableFieldWasNullError;
        protected List<ExecutionResultNode> children = new ArrayList<ExecutionResultNode>();
        protected List<GraphQLError> errors = new ArrayList<GraphQLError>();
        protected Map<String, Object> extensions = Collections.emptyMap();
        protected ElapsedTime elapsedTime;
        protected ResultPath resultPath;
        private String alias;
        private List<String> fieldIds = new ArrayList<String>();
        private GraphQLFieldDefinition fieldDefinition;
        private GraphQLObjectType objectType;
        private int totalNodeCount;
        private int totalFieldRenameCount;
        private int totalTypeRenameCount;

        public BuilderBase() {
        }

        public BuilderBase(ExecutionResultNode existing) {
            this.completedValue = existing.getCompletedValue();
            this.nonNullableFieldWasNullError = existing.getNonNullableFieldWasNullError();
            this.children.addAll(existing.getChildren());
            this.errors.addAll(existing.getErrors());
            this.extensions = existing.extensions;
            this.elapsedTime = existing.getElapsedTime();
            this.resultPath = existing.getResultPath();
            this.alias = existing.getAlias();
            this.fieldIds.addAll(existing.getFieldIds());
            this.fieldDefinition = existing.fieldDefinition;
            this.objectType = existing.objectType;
            this.totalNodeCount = existing.totalNodeCount;
            this.totalFieldRenameCount = existing.totalFieldRenameCount;
            this.totalTypeRenameCount = existing.totalTypeRenameCount;
        }

        public abstract ExecutionResultNode build();

        public T completedValue(Object completedValue) {
            this.completedValue = completedValue;
            return (T)this;
        }

        public T nonNullableFieldWasNullError(NonNullableFieldWasNullError nonNullableFieldWasNullError) {
            this.nonNullableFieldWasNullError = nonNullableFieldWasNullError;
            return (T)this;
        }

        public T objectType(GraphQLObjectType objectType) {
            this.objectType = objectType;
            return (T)this;
        }

        public T fieldDefinition(GraphQLFieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
            return (T)this;
        }

        public T alias(String alias) {
            this.alias = alias;
            return (T)this;
        }

        public T fieldIds(List<String> fieldIds) {
            this.fieldIds.clear();
            this.fieldIds.addAll(fieldIds);
            return (T)this;
        }

        public T fieldId(String fieldId) {
            this.fieldIds.clear();
            this.fieldIds.add(fieldId);
            return (T)this;
        }

        public T children(List<ExecutionResultNode> children) {
            this.children.clear();
            this.children.addAll(children);
            return (T)this;
        }

        public T addChild(ExecutionResultNode child) {
            this.children.add(child);
            return (T)this;
        }

        public T errors(List<GraphQLError> errors) {
            this.errors = errors;
            return (T)this;
        }

        public T extensions(Map<String, Object> extensions) {
            this.extensions = extensions == null ? Collections.emptyMap() : extensions;
            return (T)this;
        }

        public T addError(GraphQLError error) {
            this.errors.add(error);
            return (T)this;
        }

        public T elapsedTime(ElapsedTime elapsedTime) {
            this.elapsedTime = elapsedTime;
            return (T)this;
        }

        public T resultPath(ResultPath resultPath) {
            this.resultPath = resultPath;
            return (T)this;
        }

        public T totalNodeCount(int totalNodeCount) {
            this.totalNodeCount = totalNodeCount;
            return (T)this;
        }

        public T totalFieldRenameCount(int totalFieldRenameCount) {
            this.totalFieldRenameCount = totalFieldRenameCount;
            return (T)this;
        }

        public T totalTypeRenameCount(int totalTypeRenameCount) {
            this.totalTypeRenameCount = totalTypeRenameCount;
            return (T)this;
        }
    }
}

