/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.result;

import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.PublicApi;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.List;

@PublicApi
public class NonNullableFieldWasNullError
implements GraphQLError {
    private final String message;
    private final List<Object> path;

    public NonNullableFieldWasNullError(GraphQLNonNull nonNullType, ResultPath executionPath) {
        GraphQLType unwrappedTyped = GraphQLTypeUtil.unwrapNonNull((GraphQLType)nonNullType);
        this.path = executionPath.toList();
        this.message = String.format("The field at path '%s' was declared as a non null type, but the code involved in retrieving data has wrongly returned a null value.  The graphql specification requires that the parent field be set to null, or if that is non nullable that it bubble up null to its parent and so on. The non-nullable type is '%s'.", executionPath, GraphQLTypeUtil.simplePrint((GraphQLType)unwrappedTyped));
    }

    public String getMessage() {
        return this.message;
    }

    public List<Object> getPath() {
        return this.path;
    }

    public List<SourceLocation> getLocations() {
        return null;
    }

    public ErrorType getErrorType() {
        return ErrorType.NullValueInNonNullableField;
    }

    public String toString() {
        return "NonNullableFieldWasNullError{message='" + this.message + "', path=" + this.path + "}";
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals((GraphQLError)this, (Object)o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode((GraphQLError)this);
    }
}

