/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.result;

import graphql.Internal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
public class ResultComplexityAggregator {
    private AtomicInteger totalNodeCount = new AtomicInteger(0);
    private Map<String, Integer> serviceNodeCounts = Collections.synchronizedMap(new LinkedHashMap());
    private AtomicInteger totalFieldRenameCount = new AtomicInteger(0);
    private AtomicInteger totalTypeRenameCount = new AtomicInteger(0);

    public int getTotalNodeCount() {
        return this.totalNodeCount.get();
    }

    public int getFieldRenamesCount() {
        return this.totalFieldRenameCount.get();
    }

    public int getTypeRenamesCount() {
        return this.totalTypeRenameCount.get();
    }

    public Map<String, Integer> getServiceNodeCounts() {
        return this.serviceNodeCounts;
    }

    public int getNodeCountsForService(String serviceName) {
        return this.serviceNodeCounts.get(serviceName);
    }

    public void incrementServiceNodeCount(String serviceFieldName, int nodeCount) {
        this.serviceNodeCounts.compute(serviceFieldName, (k, v) -> v == null ? nodeCount : v + nodeCount);
        this.totalNodeCount.getAndAdd(nodeCount);
    }

    public void incrementFieldRenameCount(int fieldRenameCount) {
        this.totalFieldRenameCount.getAndAdd(fieldRenameCount);
    }

    public void incrementTypeRenameCount(int typeRenameCount) {
        this.totalTypeRenameCount.getAndAdd(typeRenameCount);
    }

    public Map<String, Object> snapshotResultComplexityData() {
        LinkedHashMap<String, Object> resultComplexityMap = new LinkedHashMap<String, Object>();
        resultComplexityMap.put("totalNodeCount", this.getTotalNodeCount());
        resultComplexityMap.put("serviceNodeCounts", this.getServiceNodeCounts());
        resultComplexityMap.put("fieldRenamesCount", this.getFieldRenamesCount());
        resultComplexityMap.put("typeRenamesCount", this.getTypeRenamesCount());
        return resultComplexityMap;
    }

    public String toString() {
        return "ResultComplexityAggregator{totalNodeCount=" + this.totalNodeCount + ", serviceNodeCountsMap=" + this.serviceNodeCounts + ", totalFieldRenameCount=" + this.totalFieldRenameCount + ", totalTypeRenameCount=" + this.totalTypeRenameCount + "}";
    }
}

