/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.result;

import java.util.concurrent.atomic.AtomicInteger;

public class ResultCounter {
    private final AtomicInteger nodeCount = new AtomicInteger();
    private final AtomicInteger fieldRenameCount = new AtomicInteger();
    private final AtomicInteger typeRenameCount = new AtomicInteger();

    public void incrementNodeCount() {
        this.incrementNodeCount(1);
    }

    public void incrementFieldRenameCount() {
        this.incrementFieldRenameCount(1);
    }

    public void incrementTypeRenameCount() {
        this.incrementTypeRenameCount(1);
    }

    public void decrementNodeCount() {
        this.incrementNodeCount(-1);
    }

    public void decrementFieldRenameCount() {
        this.incrementFieldRenameCount(-1);
    }

    public void decrementTypeRenameCount() {
        this.incrementTypeRenameCount(-1);
    }

    public void incrementNodeCount(int count) {
        this.nodeCount.getAndAdd(count);
    }

    public void incrementFieldRenameCount(int count) {
        this.fieldRenameCount.getAndAdd(count);
    }

    public void incrementTypeRenameCount(int count) {
        this.typeRenameCount.getAndAdd(count);
    }

    public int getNodeCount() {
        return this.nodeCount.get();
    }

    public int getFieldRenameCount() {
        return this.fieldRenameCount.get();
    }

    public int getTypeRenameCount() {
        return this.typeRenameCount.get();
    }
}

