/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ResultPath;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.Node;
import graphql.language.NullValue;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.nadel.OperationKind;
import graphql.nadel.Service;
import graphql.nadel.ServiceExecutionHydrationDetails;
import graphql.nadel.dsl.ExtendedFieldDefinition;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.dsl.RemoteArgumentDefinition;
import graphql.nadel.dsl.RemoteArgumentSource;
import graphql.nadel.dsl.UnderlyingServiceHydration;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.engine.execution.ArtificialFieldUtils;
import graphql.nadel.engine.execution.HydrationInputNode;
import graphql.nadel.engine.execution.OverallQueryTransformer;
import graphql.nadel.engine.execution.QueryTransformationResult;
import graphql.nadel.engine.execution.ServiceExecutor;
import graphql.nadel.engine.execution.ServiceResultNodesToOverallResult;
import graphql.nadel.engine.execution.StrategyUtil;
import graphql.nadel.engine.execution.transformation.FieldTransformation;
import graphql.nadel.engine.execution.transformation.HydrationTransformation;
import graphql.nadel.engine.result.ElapsedTime;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.LeafExecutionResultNode;
import graphql.nadel.engine.result.ListExecutionResultNode;
import graphql.nadel.engine.result.ObjectExecutionResultNode;
import graphql.nadel.engine.result.ResultComplexityAggregator;
import graphql.nadel.engine.result.ResultNodeAdapter;
import graphql.nadel.engine.result.RootExecutionResultNode;
import graphql.nadel.hooks.ServiceExecutionHooks;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.nadel.util.FpKit;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.NodeAdapter;
import graphql.util.NodeMultiZipper;
import graphql.util.NodeZipper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

@Internal
public class HydrationInputResolver {
    private final OverallQueryTransformer queryTransformer = new OverallQueryTransformer();
    private final ServiceResultNodesToOverallResult serviceResultNodesToOverallResult = new ServiceResultNodesToOverallResult();
    private final List<Service> services;
    private final GraphQLSchema overallSchema;
    private final ServiceExecutor serviceExecutor;
    private final ServiceExecutionHooks serviceExecutionHooks;
    private final Set<ResultPath> hydrationInputPaths;

    public HydrationInputResolver(List<Service> services, GraphQLSchema overallSchema, ServiceExecutor serviceExecutor, ServiceExecutionHooks serviceExecutionHooks, Set<ResultPath> hydrationInputPaths) {
        this.services = services;
        this.overallSchema = overallSchema;
        this.serviceExecutor = serviceExecutor;
        this.serviceExecutionHooks = serviceExecutionHooks;
        this.hydrationInputPaths = hydrationInputPaths;
    }

    public CompletableFuture<ExecutionResultNode> resolveAllHydrationInputs(ExecutionContext context, ExecutionResultNode node, Map<Service, Object> serviceContexts, ResultComplexityAggregator resultComplexityAggregator) {
        Set<NodeZipper<ExecutionResultNode>> hydrationInputZippers = StrategyUtil.getHydrationInputNodes(node, this.hydrationInputPaths);
        if (hydrationInputZippers.isEmpty()) {
            return CompletableFuture.completedFuture(node);
        }
        List<NodeMultiZipper<ExecutionResultNode>> hydrationInputBatches = StrategyUtil.groupNodesIntoBatchesByField(hydrationInputZippers, node);
        ArrayList<CompletableFuture<List<NodeZipper<ExecutionResultNode>>>> resolvedNodeCFs = new ArrayList<CompletableFuture<List<NodeZipper<ExecutionResultNode>>>>();
        for (NodeMultiZipper<ExecutionResultNode> batch : hydrationInputBatches) {
            if (this.isBatchHydrationField((HydrationInputNode)((NodeZipper)batch.getZippers().get(0)).getCurNode())) {
                this.resolveInputNodesAsBatch(context, resolvedNodeCFs, batch, serviceContexts, resultComplexityAggregator);
                continue;
            }
            this.resolveInputNodes(context, resolvedNodeCFs, batch, serviceContexts, resultComplexityAggregator);
        }
        return ((CompletableFuture)Async.each(resolvedNodeCFs).thenCompose(resolvedNodes -> {
            NodeMultiZipper multiZipper = new NodeMultiZipper((Object)node, FpKit.flatList((List)resolvedNodes), (NodeAdapter)ResultNodeAdapter.RESULT_NODE_ADAPTER);
            ExecutionResultNode newRoot = (ExecutionResultNode)multiZipper.toRootNode();
            return this.resolveAllHydrationInputs(context, newRoot, serviceContexts, resultComplexityAggregator);
        })).whenComplete(this::possiblyLogException);
    }

    private void resolveInputNodes(ExecutionContext context, List<CompletableFuture<List<NodeZipper<ExecutionResultNode>>>> resolvedNodeCFs, NodeMultiZipper<ExecutionResultNode> batch, Map<Service, Object> serviceContexts, ResultComplexityAggregator resultComplexityAggregator) {
        for (NodeZipper hydrationInputNodeZipper : batch.getZippers()) {
            HydrationInputNode hydrationInputNode = (HydrationInputNode)hydrationInputNodeZipper.getCurNode();
            CompletableFuture<ExecutionResultNode> executionResultNodeCompletableFuture = this.resolveSingleHydrationInput(context, hydrationInputNode, serviceContexts, resultComplexityAggregator);
            resolvedNodeCFs.add((CompletableFuture<List<NodeZipper<ExecutionResultNode>>>)executionResultNodeCompletableFuture.thenApply(newNode -> Collections.singletonList(hydrationInputNodeZipper.withNewNode(newNode))));
        }
    }

    private void resolveInputNodesAsBatch(ExecutionContext context, List<CompletableFuture<List<NodeZipper<ExecutionResultNode>>>> resolvedNodeCFs, NodeMultiZipper<ExecutionResultNode> batch, Map<Service, Object> serviceContexts, ResultComplexityAggregator resultComplexityAggregator) {
        List<NodeMultiZipper<ExecutionResultNode>> batchesWithCorrectSize = this.groupIntoCorrectBatchSizes(batch);
        for (NodeMultiZipper<ExecutionResultNode> oneBatch : batchesWithCorrectSize) {
            List batchedNodes = FpKit.map((List)oneBatch.getZippers(), zipper -> (HydrationInputNode)zipper.getCurNode());
            CompletableFuture<List<ExecutionResultNode>> executionResultNodeCompletableFuture = this.resolveHydrationInputBatch(context, batchedNodes, serviceContexts, resultComplexityAggregator);
            resolvedNodeCFs.add(this.replaceNodesInZipper(oneBatch, executionResultNodeCompletableFuture));
        }
    }

    private Integer getDefaultBatchSize(UnderlyingServiceHydration underlyingServiceHydration) {
        GraphQLFieldDefinition graphQLFieldDefinition = null;
        String topLevelField = underlyingServiceHydration.getTopLevelField();
        if (underlyingServiceHydration.getSyntheticField() != null) {
            GraphQLFieldDefinition syntheticFieldDefinition = this.overallSchema.getQueryType().getFieldDefinition(underlyingServiceHydration.getSyntheticField());
            if (syntheticFieldDefinition == null) {
                return null;
            }
            GraphQLObjectType syntheticFieldDefinitionType = (GraphQLObjectType)syntheticFieldDefinition.getType();
            graphQLFieldDefinition = syntheticFieldDefinitionType.getFieldDefinition(underlyingServiceHydration.getTopLevelField());
        } else {
            graphQLFieldDefinition = this.overallSchema.getQueryType().getFieldDefinition(topLevelField);
        }
        if (graphQLFieldDefinition == null) {
            return null;
        }
        FieldDefinition fieldDefinition = graphQLFieldDefinition.getDefinition();
        if (!(fieldDefinition instanceof ExtendedFieldDefinition)) {
            return null;
        }
        return ((ExtendedFieldDefinition)fieldDefinition).getDefaultBatchSize();
    }

    private List<NodeMultiZipper<ExecutionResultNode>> groupIntoCorrectBatchSizes(NodeMultiZipper<ExecutionResultNode> batch) {
        HydrationInputNode node = (HydrationInputNode)((NodeZipper)batch.getZippers().get(0)).getCurNode();
        Integer batchSize = node.getHydrationTransformation().getUnderlyingServiceHydration().getBatchSize();
        if (batchSize == null) {
            batchSize = this.getDefaultBatchSize(node.getHydrationTransformation().getUnderlyingServiceHydration());
        }
        if (batchSize == null) {
            return Collections.singletonList(batch);
        }
        ArrayList<NodeMultiZipper<ExecutionResultNode>> result = new ArrayList<NodeMultiZipper<ExecutionResultNode>>();
        int counter = 0;
        ArrayList<NodeZipper> currentBatch = new ArrayList<NodeZipper>();
        for (NodeZipper zipper : batch.getZippers()) {
            currentBatch.add(zipper);
            if (++counter != batchSize) continue;
            result.add((NodeMultiZipper<ExecutionResultNode>)new NodeMultiZipper((Object)((ExecutionResultNode)batch.getCommonRoot()), currentBatch, (NodeAdapter)ResultNodeAdapter.RESULT_NODE_ADAPTER));
            counter = 0;
            currentBatch = new ArrayList();
        }
        if (currentBatch.size() > 0) {
            result.add((NodeMultiZipper<ExecutionResultNode>)new NodeMultiZipper((Object)((ExecutionResultNode)batch.getCommonRoot()), currentBatch, (NodeAdapter)ResultNodeAdapter.RESULT_NODE_ADAPTER));
        }
        return result;
    }

    private boolean isBatchHydrationField(HydrationInputNode hydrationInputNode) {
        HydrationTransformation hydrationTransformation = hydrationInputNode.getHydrationTransformation();
        Service service = this.getService(hydrationTransformation.getUnderlyingServiceHydration());
        String syntheticFieldName = hydrationTransformation.getUnderlyingServiceHydration().getSyntheticField();
        String topLevelFieldName = hydrationTransformation.getUnderlyingServiceHydration().getTopLevelField();
        GraphQLFieldDefinition topLevelFieldDefinition = syntheticFieldName == null ? service.getUnderlyingSchema().getQueryType().getFieldDefinition(topLevelFieldName) : ((GraphQLObjectType)service.getUnderlyingSchema().getQueryType().getFieldDefinition(syntheticFieldName).getType()).getFieldDefinition(topLevelFieldName);
        Assert.assertNotNull((Object)topLevelFieldDefinition, () -> String.format("hydration field '%s' does not exist in underlying schema in service '%s'", topLevelFieldName, service.getName()));
        return GraphQLTypeUtil.isList((GraphQLType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)topLevelFieldDefinition.getType()));
    }

    private CompletableFuture<List<NodeZipper<ExecutionResultNode>>> replaceNodesInZipper(NodeMultiZipper<ExecutionResultNode> batch, CompletableFuture<List<ExecutionResultNode>> executionResultNodeCompletableFuture) {
        return executionResultNodeCompletableFuture.thenApply(executionResultNodes -> {
            ArrayList<NodeZipper> newZippers = new ArrayList<NodeZipper>();
            List zippers = batch.getZippers();
            for (int i = 0; i < executionResultNodes.size(); ++i) {
                NodeZipper zipper = (NodeZipper)zippers.get(i);
                NodeZipper newZipper = zipper.withNewNode((Object)((ExecutionResultNode)executionResultNodes.get(i)));
                newZippers.add(newZipper);
            }
            return newZippers;
        });
    }

    private CompletableFuture<ExecutionResultNode> resolveSingleHydrationInput(ExecutionContext executionContext, HydrationInputNode hydrationInputNode, Map<Service, Object> serviceContexts, ResultComplexityAggregator resultComplexityAggregator) {
        HydrationTransformation hydrationTransformation = hydrationInputNode.getHydrationTransformation();
        Field originalField = hydrationTransformation.getOriginalField();
        UnderlyingServiceHydration underlyingServiceHydration = hydrationTransformation.getUnderlyingServiceHydration();
        ServiceExecutionHydrationDetails hydrationDetails = new ServiceExecutionHydrationDetails(Integer.valueOf(underlyingServiceHydration.getTimeout()), underlyingServiceHydration.getBatchSize(), null, null);
        String topLevelFieldName = underlyingServiceHydration.getTopLevelField();
        Service service = this.getService(underlyingServiceHydration);
        Field topLevelField = this.createSingleHydrationTopLevelField(hydrationInputNode, hydrationInputNode.getSelectionSet(), underlyingServiceHydration, topLevelFieldName, underlyingServiceHydration.getSyntheticField(), originalField);
        GraphQLCompositeType topLevelFieldType = (GraphQLCompositeType)GraphQLTypeUtil.unwrapAll((GraphQLType)hydrationTransformation.getOriginalFieldType());
        OperationKind operationKind = OperationKind.QUERY;
        String operationName = this.buildOperationName(service, executionContext);
        boolean isSyntheticHydration = underlyingServiceHydration.getSyntheticField() != null;
        CompletableFuture<QueryTransformationResult> queryTransformationResultCF = this.queryTransformer.transformHydratedTopLevelField(executionContext, service.getUnderlyingSchema(), operationName, operationKind, topLevelField, topLevelFieldType, this.serviceExecutionHooks, service, serviceContexts.get(service), isSyntheticHydration);
        return queryTransformationResultCF.thenCompose(queryTransformationResult -> {
            CompletableFuture<RootExecutionResultNode> serviceResult = this.serviceExecutor.execute(executionContext, (QueryTransformationResult)queryTransformationResult, service, operationKind, serviceContexts.get(service), service.getUnderlyingSchema(), hydrationDetails);
            return ((CompletableFuture)serviceResult.thenApply(resultNode -> this.convertSingleHydrationResultIntoOverallResult(executionContext.getExecutionId(), hydrationInputNode, hydrationTransformation, (RootExecutionResultNode)resultNode, hydrationInputNode.getNormalizedField(), (QueryTransformationResult)queryTransformationResult, this.getNadelContext(executionContext), resultComplexityAggregator))).whenComplete(this::possiblyLogException);
        });
    }

    private Field createSingleHydrationTopLevelField(HydrationInputNode hydrationInputNode, SelectionSet selectionSet, UnderlyingServiceHydration underlyingServiceHydration, String topLevelFieldName, String syntheticFieldName, Field originalField) {
        List<Argument> allArguments = this.getArguments(hydrationInputNode, underlyingServiceHydration, originalField);
        Field topLevelField = Field.newField((String)topLevelFieldName).selectionSet(selectionSet).arguments(allArguments).additionalData("id", UUID.randomUUID().toString()).build();
        if (syntheticFieldName == null) {
            return topLevelField;
        }
        Field syntheticField = Field.newField((String)syntheticFieldName).selectionSet(SelectionSet.newSelectionSet().selection((Selection)topLevelField).build()).additionalData("id", UUID.randomUUID().toString()).build();
        return syntheticField;
    }

    private List<Argument> getArguments(HydrationInputNode hydrationInputNode, UnderlyingServiceHydration underlyingServiceHydration, Field originalField) {
        List arguments = underlyingServiceHydration.getArguments();
        List argumentDefinitionsFromSourceObjects = FpKit.filter((Collection)arguments, argument -> argument.getRemoteArgumentSource().getSourceType() == RemoteArgumentSource.SourceType.OBJECT_FIELD);
        ArrayList<Argument> allArguments = new ArrayList<Argument>();
        for (RemoteArgumentDefinition definition : argumentDefinitionsFromSourceObjects) {
            List sourcePath = definition.getRemoteArgumentSource().getPath();
            Object definitionValue = this.getDefinitionValue(sourcePath, hydrationInputNode.getCompletedValue());
            StringValue argumentValue = definitionValue != null ? new StringValue(definitionValue.toString()) : NullValue.newNullValue().build();
            Argument argumentAstFromSourceObject = Argument.newArgument().name(definition.getName()).value((Value)argumentValue).build();
            allArguments.add(argumentAstFromSourceObject);
        }
        this.addExtraFieldArguments(originalField, arguments, allArguments);
        return allArguments;
    }

    private Object getDefinitionValue(List<String> sourcePath, Object value) {
        for (String path : sourcePath) {
            value = ((Map)value).get(path);
        }
        return value;
    }

    private ExecutionResultNode convertSingleHydrationResultIntoOverallResult(ExecutionId executionId, HydrationInputNode hydrationInputNode, HydrationTransformation hydrationTransformation, RootExecutionResultNode rootResultNode, NormalizedQueryField rootNormalizedField, QueryTransformationResult queryTransformationResult, NadelContext nadelContext, ResultComplexityAggregator resultComplexityAggregator) {
        Map<String, FieldTransformation> transformationByTransformationId = queryTransformationResult.getTransformations().getTransformationIdToTransformation();
        Map<FieldTransformation, String> transformationToFieldId = queryTransformationResult.getTransformations().getTransformationToFieldId();
        Map<String, String> typeRenameMappings = queryTransformationResult.getTransformations().getTypeRenameMappings();
        Assert.assertTrue((rootResultNode.getChildren().size() == 1 ? 1 : 0) != 0, () -> "expected rootResultNode to only have 1 child.");
        ExecutionResultNode root = rootResultNode.getChildren().get(0);
        if (hydrationTransformation.getUnderlyingServiceHydration().getSyntheticField() != null && root.getChildren().size() > 0) {
            Assert.assertTrue((root.getChildren().size() == 1 ? 1 : 0) != 0, () -> "expected synthetic field to only have 1 topLevelField child.");
            root = root.getChildren().get(0);
        }
        ExecutionResultNode firstTopLevelResultNode = this.serviceResultNodesToOverallResult.convertChildren(executionId, root, rootNormalizedField, this.overallSchema, hydrationInputNode, true, false, transformationByTransformationId, transformationToFieldId, typeRenameMappings, nadelContext, queryTransformationResult.getRemovedFieldMap(), this.hydrationInputPaths);
        String serviceName = hydrationTransformation.getUnderlyingServiceHydration().getServiceName();
        resultComplexityAggregator.incrementServiceNodeCount(serviceName, firstTopLevelResultNode.getTotalNodeCount());
        resultComplexityAggregator.incrementTypeRenameCount(firstTopLevelResultNode.getTotalTypeRenameCount());
        resultComplexityAggregator.incrementFieldRenameCount(firstTopLevelResultNode.getTotalFieldRenameCount());
        firstTopLevelResultNode = firstTopLevelResultNode.withNewErrors(rootResultNode.getErrors());
        firstTopLevelResultNode = StrategyUtil.copyFieldInformation(hydrationInputNode, firstTopLevelResultNode);
        return StrategyUtil.changeFieldIdsInResultNode(firstTopLevelResultNode, NodeId.getId((Node)hydrationTransformation.getOriginalField()));
    }

    private CompletableFuture<List<ExecutionResultNode>> resolveHydrationInputBatch(ExecutionContext executionContext, List<HydrationInputNode> hydrationInputs, Map<Service, Object> serviceContexts, ResultComplexityAggregator resultComplexityAggregator) {
        List hydrationTransformations = FpKit.map(hydrationInputs, HydrationInputNode::getHydrationTransformation);
        HydrationTransformation hydrationTransformation = (HydrationTransformation)hydrationTransformations.get(0);
        Field originalField = hydrationTransformation.getOriginalField();
        UnderlyingServiceHydration underlyingServiceHydration = hydrationTransformation.getUnderlyingServiceHydration();
        ServiceExecutionHydrationDetails hydrationDetails = new ServiceExecutionHydrationDetails(Integer.valueOf(underlyingServiceHydration.getTimeout()), underlyingServiceHydration.getBatchSize(), null, null);
        Service service = this.getService(underlyingServiceHydration);
        Field topLevelField = this.createBatchHydrationTopLevelField(executionContext, hydrationInputs, originalField, underlyingServiceHydration);
        GraphQLCompositeType topLevelFieldType = (GraphQLCompositeType)GraphQLTypeUtil.unwrapAll((GraphQLType)hydrationTransformation.getOriginalFieldType());
        OperationKind operationKind = OperationKind.QUERY;
        String operationName = this.buildOperationName(service, executionContext);
        boolean isSyntheticHydration = underlyingServiceHydration.getSyntheticField() != null;
        CompletableFuture<QueryTransformationResult> queryTransformationResultCF = this.queryTransformer.transformHydratedTopLevelField(executionContext, service.getUnderlyingSchema(), operationName, operationKind, topLevelField, topLevelFieldType, this.serviceExecutionHooks, service, serviceContexts.get(service), isSyntheticHydration);
        return queryTransformationResultCF.thenCompose(queryTransformationResult -> ((CompletableFuture)this.serviceExecutor.execute(executionContext, (QueryTransformationResult)queryTransformationResult, service, operationKind, serviceContexts.get(service), service.getUnderlyingSchema(), hydrationDetails).thenApply(resultNode -> this.convertHydrationBatchResultIntoOverallResult(executionContext, hydrationInputs, (RootExecutionResultNode)resultNode, (QueryTransformationResult)queryTransformationResult, resultComplexityAggregator))).whenComplete(this::possiblyLogException));
    }

    private Field createBatchHydrationTopLevelField(ExecutionContext executionContext, List<HydrationInputNode> hydrationInputs, Field originalField, UnderlyingServiceHydration underlyingServiceHydration) {
        String topLevelFieldName = underlyingServiceHydration.getTopLevelField();
        String syntheticFieldName = underlyingServiceHydration.getSyntheticField();
        List<Argument> allArguments = this.getBatchArguments(hydrationInputs, originalField, underlyingServiceHydration);
        Field topLevelField = Field.newField((String)topLevelFieldName).selectionSet(hydrationInputs.get(0).getSelectionSet()).additionalData("id", UUID.randomUUID().toString()).arguments(allArguments).build();
        if (!underlyingServiceHydration.isObjectMatchByIndex()) {
            topLevelField = ArtificialFieldUtils.addObjectIdentifier(this.getNadelContext(executionContext), topLevelField, underlyingServiceHydration.getObjectIdentifier());
        }
        if (syntheticFieldName == null) {
            return topLevelField;
        }
        Field syntheticField = Field.newField((String)syntheticFieldName).selectionSet(SelectionSet.newSelectionSet().selection((Selection)topLevelField).build()).additionalData("id", UUID.randomUUID().toString()).build();
        return syntheticField;
    }

    private List<Argument> getBatchArguments(List<HydrationInputNode> hydrationInputs, Field originalField, UnderlyingServiceHydration underlyingServiceHydration) {
        List arguments = underlyingServiceHydration.getArguments();
        List argumentDefinitionsFromSourceObjects = FpKit.filter((Collection)arguments, argument -> argument.getRemoteArgumentSource().getSourceType() == RemoteArgumentSource.SourceType.OBJECT_FIELD);
        ArrayList<Argument> allArguments = new ArrayList<Argument>();
        for (RemoteArgumentDefinition definition : argumentDefinitionsFromSourceObjects) {
            ArrayList<StringValue> values = new ArrayList<StringValue>();
            List sourcePath = definition.getRemoteArgumentSource().getPath();
            for (ExecutionResultNode executionResultNode : hydrationInputs) {
                Object definitionValue = this.getDefinitionValue(sourcePath, executionResultNode.getCompletedValue());
                StringValue argumentValue = definitionValue != null ? new StringValue(definitionValue.toString()) : NullValue.newNullValue().build();
                values.add(argumentValue);
            }
            Argument argumentAstFromSourceObject = Argument.newArgument().name(definition.getName()).value((Value)new ArrayValue(values)).build();
            allArguments.add(argumentAstFromSourceObject);
        }
        this.addExtraFieldArguments(originalField, arguments, allArguments);
        return allArguments;
    }

    private void addExtraFieldArguments(Field originalField, List<RemoteArgumentDefinition> arguments, List<Argument> allArguments) {
        List extraArguments = FpKit.filter(arguments, argument -> argument.getRemoteArgumentSource().getSourceType() == RemoteArgumentSource.SourceType.FIELD_ARGUMENT);
        Map originalArgumentsByName = FpKit.getByName((List)originalField.getArguments(), Argument::getName);
        for (RemoteArgumentDefinition argumentDefinition : extraArguments) {
            if (!originalArgumentsByName.containsKey(argumentDefinition.getName())) continue;
            allArguments.add((Argument)originalArgumentsByName.get(argumentDefinition.getName()));
        }
    }

    private List<ExecutionResultNode> convertHydrationBatchResultIntoOverallResult(ExecutionContext executionContext, List<HydrationInputNode> hydrationInputNodes, RootExecutionResultNode rootResultNode, QueryTransformationResult queryTransformationResult, ResultComplexityAggregator resultComplexityAggregator) {
        UnderlyingServiceHydration serviceHydration = hydrationInputNodes.get(0).getHydrationTransformation().getUnderlyingServiceHydration();
        boolean isSyntheticHydration = serviceHydration.getSyntheticField() != null;
        boolean isResolveByIndex = serviceHydration.isObjectMatchByIndex();
        ExecutionResultNode root = rootResultNode.getChildren().get(0);
        if (!(root instanceof LeafExecutionResultNode) && isSyntheticHydration) {
            root = root.getChildren().get(0);
        }
        if (root instanceof LeafExecutionResultNode) {
            Assert.assertTrue((boolean)root.isNullValue());
            ArrayList<ExecutionResultNode> result = new ArrayList<ExecutionResultNode>();
            boolean first = true;
            for (HydrationInputNode hydrationInputNode : hydrationInputNodes) {
                ExecutionResultNode resultNode = this.createNullValue(hydrationInputNode);
                if (first) {
                    resultNode = resultNode.withNewErrors(rootResultNode.getErrors());
                    first = false;
                }
                result.add(resultNode);
            }
            return result;
        }
        Assert.assertTrue((boolean)(root instanceof ListExecutionResultNode), () -> "expect a list result from the underlying service for batched hydration");
        ListExecutionResultNode listResultNode = (ListExecutionResultNode)root;
        List<ExecutionResultNode> resolvedNodes = listResultNode.getChildren();
        if (isResolveByIndex) {
            Assert.assertTrue((resolvedNodes.size() == hydrationInputNodes.size() ? 1 : 0) != 0, () -> String.format("If you use indexed hydration then you MUST follow a contract where the resolved nodes matches the size of the input arguments. We expected %d returned nodes but only got %d", hydrationInputNodes.size(), resolvedNodes.size()));
        }
        ArrayList<ExecutionResultNode> result = new ArrayList<ExecutionResultNode>();
        Map<String, FieldTransformation> transformationByResultField = queryTransformationResult.getTransformations().getTransformationIdToTransformation();
        Map<FieldTransformation, String> transformationToFieldId = queryTransformationResult.getTransformations().getTransformationToFieldId();
        Map<String, String> typeRenameMappings = queryTransformationResult.getTransformations().getTypeRenameMappings();
        boolean first = true;
        for (int i = 0; i < hydrationInputNodes.size(); ++i) {
            ExecutionResultNode resultNode;
            ExecutionResultNode matchingResolvedNode;
            HydrationInputNode hydrationInputNode = hydrationInputNodes.get(i);
            if (isResolveByIndex) {
                matchingResolvedNode = resolvedNodes.get(i);
            } else {
                RemoteArgumentDefinition idDefinition = (RemoteArgumentDefinition)FpKit.findOneOrNull((List)serviceHydration.getArguments(), argument -> argument.getRemoteArgumentSource().getSourceType() == RemoteArgumentSource.SourceType.OBJECT_FIELD);
                matchingResolvedNode = this.findMatchingResolvedNode(executionContext, hydrationInputNode, resolvedNodes, idDefinition.getRemoteArgumentSource().getPath());
            }
            if (matchingResolvedNode != null) {
                ExecutionResultNode overallResultNode = this.serviceResultNodesToOverallResult.convertChildren(executionContext.getExecutionId(), matchingResolvedNode, hydrationInputNode.getNormalizedField(), this.overallSchema, hydrationInputNode, true, true, transformationByResultField, transformationToFieldId, typeRenameMappings, this.getNadelContext(executionContext), queryTransformationResult.getRemovedFieldMap(), this.hydrationInputPaths);
                String serviceName = hydrationInputNode.getHydrationTransformation().getUnderlyingServiceHydration().getServiceName();
                int nodeCount = overallResultNode.getTotalNodeCount();
                resultComplexityAggregator.incrementServiceNodeCount(serviceName, nodeCount);
                resultComplexityAggregator.incrementTypeRenameCount(overallResultNode.getTotalTypeRenameCount());
                resultComplexityAggregator.incrementFieldRenameCount(overallResultNode.getTotalFieldRenameCount());
                resultNode = StrategyUtil.copyFieldInformation(hydrationInputNode, overallResultNode);
            } else {
                resultNode = this.createNullValue(hydrationInputNode);
            }
            if (first) {
                resultNode = resultNode.withNewErrors(rootResultNode.getErrors());
                first = false;
            }
            result.add(resultNode);
        }
        return result;
    }

    private LeafExecutionResultNode createNullValue(HydrationInputNode inputNode) {
        ElapsedTime elapsedTime = inputNode.getElapsedTime();
        return ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().objectType(inputNode.getObjectType())).alias(inputNode.getAlias())).fieldIds(inputNode.getFieldIds())).resultPath(inputNode.getResultPath())).fieldDefinition(inputNode.getFieldDefinition())).completedValue(null)).elapsedTime(elapsedTime)).build();
    }

    private ExecutionResultNode findMatchingResolvedNode(ExecutionContext executionContext, HydrationInputNode inputNode, List<ExecutionResultNode> resolvedNodes, List<String> sourcePath) {
        NadelContext nadelContext = this.getNadelContext(executionContext);
        String objectIdentifier = nadelContext.getObjectIdentifierAlias();
        String inputNodeId = (String)this.getDefinitionValue(sourcePath, inputNode.getCompletedValue());
        for (ExecutionResultNode resolvedNode : resolvedNodes) {
            LeafExecutionResultNode idNode = this.getFieldByResultKey((ObjectExecutionResultNode)resolvedNode, objectIdentifier);
            Assert.assertNotNull((Object)idNode, () -> String.format("no value found for object identifier: %s", objectIdentifier));
            Object id = idNode.getCompletedValue();
            Assert.assertNotNull((Object)id, () -> "object identifier is null");
            if (!id.equals(inputNodeId)) continue;
            return resolvedNode;
        }
        return null;
    }

    private LeafExecutionResultNode getFieldByResultKey(ObjectExecutionResultNode node, String resultKey) {
        return (LeafExecutionResultNode)FpKit.findOneOrNull(node.getChildren(), child -> child.getResultKey().equals(resultKey));
    }

    private <T> void possiblyLogException(T result, Throwable exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    private Service getService(UnderlyingServiceHydration underlyingServiceHydration) {
        return (Service)FpKit.findOne(this.services, service -> service.getName().equals(underlyingServiceHydration.getServiceName())).get();
    }

    private String buildOperationName(Service service, ExecutionContext executionContext) {
        NadelContext nadelContext = (NadelContext)executionContext.getContext();
        if (nadelContext.getOriginalOperationName() != null) {
            return String.format("nadel_2_%s_%s", service.getName(), nadelContext.getOriginalOperationName());
        }
        return String.format("nadel_2_%s", service.getName());
    }

    private NadelContext getNadelContext(ExecutionContext executionContext) {
        return (NadelContext)executionContext.getContext();
    }
}

