/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStepInfoFactory;
import graphql.execution.MergedField;
import graphql.execution.ResultPath;
import graphql.execution.nextgen.FieldSubSelection;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.nadel.OperationKind;
import graphql.nadel.Service;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.engine.BenchmarkContext;
import graphql.nadel.engine.FieldInfo;
import graphql.nadel.engine.FieldInfos;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.engine.execution.HydrationInputResolver;
import graphql.nadel.engine.execution.OverallQueryTransformer;
import graphql.nadel.engine.execution.QueryTransformationResult;
import graphql.nadel.engine.execution.ServiceExecutor;
import graphql.nadel.engine.execution.ServiceResultNodesToOverallResult;
import graphql.nadel.engine.execution.ServiceResultToResultNodes;
import graphql.nadel.engine.execution.StrategyUtil;
import graphql.nadel.engine.execution.TransformationState;
import graphql.nadel.engine.execution.transformation.FieldTransformation;
import graphql.nadel.engine.execution.transformation.TransformationMetadata;
import graphql.nadel.engine.hooks.EngineServiceExecutionHooks;
import graphql.nadel.engine.hooks.ResultRewriteParams;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.LeafExecutionResultNode;
import graphql.nadel.engine.result.ResultComplexityAggregator;
import graphql.nadel.engine.result.RootExecutionResultNode;
import graphql.nadel.hooks.CreateServiceContextParams;
import graphql.nadel.hooks.ServiceExecutionHooks;
import graphql.nadel.hooks.ServiceOrError;
import graphql.nadel.instrumentation.NadelInstrumentation;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.nadel.normalized.NormalizedQueryFromAst;
import graphql.nadel.schema.NadelDirectives;
import graphql.nadel.util.MergedFieldUtil;
import graphql.nadel.util.NamespacedUtil;
import graphql.nadel.util.OperationNameUtil;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NadelExecutionStrategy {
    private final ExecutionStepInfoFactory executionStepInfoFactory = new ExecutionStepInfoFactory();
    private final ServiceResultNodesToOverallResult serviceResultNodesToOverallResult = new ServiceResultNodesToOverallResult();
    private final OverallQueryTransformer queryTransformer = new OverallQueryTransformer();
    private final ServiceResultToResultNodes resultToResultNode = new ServiceResultToResultNodes();
    private final FieldInfos fieldInfos;
    private final GraphQLSchema overallSchema;
    private final ServiceExecutor serviceExecutor;
    private final HydrationInputResolver hydrationInputResolver;
    private final ServiceExecutionHooks serviceExecutionHooks;
    private final ExecutionPathSet hydrationInputPaths;
    private final List<Service> services;
    private static final Logger log = LoggerFactory.getLogger(NadelExecutionStrategy.class);

    public NadelExecutionStrategy(List<Service> services, FieldInfos fieldInfos, GraphQLSchema overallSchema, NadelInstrumentation instrumentation, ServiceExecutionHooks serviceExecutionHooks) {
        this.overallSchema = overallSchema;
        Assert.assertNotEmpty(services);
        this.fieldInfos = fieldInfos;
        this.serviceExecutionHooks = serviceExecutionHooks;
        this.serviceExecutor = new ServiceExecutor(instrumentation);
        this.hydrationInputPaths = new ExecutionPathSet();
        this.hydrationInputResolver = new HydrationInputResolver(services, overallSchema, this.serviceExecutor, serviceExecutionHooks, this.hydrationInputPaths);
        this.services = services;
    }

    public CompletableFuture<RootExecutionResultNode> execute(ExecutionContext executionContext, FieldSubSelection fieldSubSelection, ResultComplexityAggregator resultComplexityAggregator) {
        long startTime = System.currentTimeMillis();
        ExecutionStepInfo rootExecutionStepInfo = fieldSubSelection.getExecutionStepInfo();
        NadelContext nadelContext = this.getNadelContext(executionContext);
        OperationKind operationKind = OperationKind.fromAst((OperationDefinition.Operation)executionContext.getOperationDefinition().getOperation());
        CompletableFuture<List<OneServiceExecution>> oneServiceExecutionsCF = this.prepareServiceExecution(executionContext, fieldSubSelection, rootExecutionStepInfo);
        return ((CompletableFuture)oneServiceExecutionsCF.thenCompose(oneServiceExecutions -> {
            Map<Service, Object> serviceContextsByService = this.serviceContextsByService((List<OneServiceExecution>)oneServiceExecutions);
            List<CompletableFuture<RootExecutionResultNode>> resultNodes = this.executeTopLevelFields(executionContext, nadelContext, operationKind, (List<OneServiceExecution>)oneServiceExecutions, resultComplexityAggregator, this.hydrationInputPaths);
            CompletableFuture<RootExecutionResultNode> rootResult = this.mergeTrees(resultNodes);
            return ((CompletableFuture)rootResult.thenCompose(rootExecutionResultNode -> this.hydrationInputResolver.resolveAllHydrationInputs(executionContext, (ExecutionResultNode)rootExecutionResultNode, serviceContextsByService, resultComplexityAggregator).thenApply(resultNode -> (RootExecutionResultNode)resultNode))).whenComplete((resultNode, throwable) -> {
                this.possiblyLogException((Object)resultNode, (Throwable)throwable);
                long elapsedTime = System.currentTimeMillis() - startTime;
                log.debug("NadelExecutionStrategy time: {} ms, executionId: {}", (Object)elapsedTime, (Object)executionContext.getExecutionId());
            });
        })).whenComplete(this::possiblyLogException);
    }

    private Map<Service, Object> serviceContextsByService(List<OneServiceExecution> oneServiceExecutions) {
        LinkedHashMap<Service, Object> result = new LinkedHashMap<Service, Object>();
        for (OneServiceExecution oneServiceExecution : oneServiceExecutions) {
            result.put(oneServiceExecution.service, oneServiceExecution.serviceContext);
        }
        return result;
    }

    private CompletableFuture<List<OneServiceExecution>> prepareServiceExecution(ExecutionContext executionCtx, FieldSubSelection fieldSubSelection, ExecutionStepInfo rootExecutionStepInfo) {
        ArrayList<CompletableFuture<OneServiceExecution>> result = new ArrayList<CompletableFuture<OneServiceExecution>>();
        for (MergedField mergedField : fieldSubSelection.getMergedSelectionSet().getSubFieldsList()) {
            boolean usesDynamicService;
            ExecutionStepInfo fieldExecutionStepInfo = this.executionStepInfoFactory.newExecutionStepInfoForSubField(executionCtx, mergedField, rootExecutionStepInfo);
            boolean isNamespaced = !fieldExecutionStepInfo.getFieldDefinition().getDirectives(NadelDirectives.NAMESPACED_DIRECTIVE_DEFINITION.getName()).isEmpty();
            boolean bl = usesDynamicService = fieldExecutionStepInfo.getFieldDefinition().getDirective(NadelDirectives.DYNAMIC_SERVICE_DIRECTIVE_DEFINITION.getName()) != null;
            if (isNamespaced) {
                result.addAll(this.getServiceExecutionsForNamespacedField(executionCtx, rootExecutionStepInfo, mergedField, fieldExecutionStepInfo));
                continue;
            }
            if (usesDynamicService) {
                result.add(this.getServiceExecutionForDynamicServiceField(executionCtx, rootExecutionStepInfo, fieldExecutionStepInfo));
                continue;
            }
            Service service = this.getServiceForFieldDefinition(fieldExecutionStepInfo.getFieldDefinition());
            result.add(this.getOneServiceExecution(executionCtx, fieldExecutionStepInfo, service));
        }
        return Async.each(result);
    }

    private CompletableFuture<OneServiceExecution> getServiceExecutionForDynamicServiceField(ExecutionContext executionCtx, ExecutionStepInfo rootExecutionStepInfo, ExecutionStepInfo fieldExecutionStepInfo) {
        ServiceOrError serviceOrError = (ServiceOrError)Assert.assertNotNull((Object)this.serviceExecutionHooks.resolveServiceForField(this.services, fieldExecutionStepInfo), () -> "Service resolution hook must never return null.");
        if (serviceOrError.getService() == null) {
            GraphQLError graphQLError = (GraphQLError)Assert.assertNotNull((Object)serviceOrError.getError(), () -> "Hook must return an error object when Service is null");
            return CompletableFuture.completedFuture(new OneServiceExecution(null, null, null, true, graphQLError, fieldExecutionStepInfo));
        }
        Assert.assertTrue((boolean)(fieldExecutionStepInfo.getUnwrappedNonNullType() instanceof GraphQLInterfaceType), () -> String.format("field annotated with %s directive is expected to be of GraphQLInterfaceType", NadelDirectives.DYNAMIC_SERVICE_DIRECTIVE_DEFINITION.getName()));
        Service service = serviceOrError.getService();
        List<String> serviceObjectTypes = service.getDefinitionRegistry().getDefinitions(ObjectTypeDefinition.class).stream().map(ObjectTypeDefinition::getName).collect(Collectors.toList());
        NormalizedQueryFromAst normalizedQuery = this.getNadelContext(executionCtx).getNormalizedOverallQuery();
        List<InlineFragment> inlineFragments = this.wrapFieldsInInlineFragments(fieldExecutionStepInfo, serviceObjectTypes, normalizedQuery);
        SelectionSet selectionSet = SelectionSet.newSelectionSet(inlineFragments).build();
        Field transform = fieldExecutionStepInfo.getField().getSingleField().transform(builder -> builder.selectionSet(selectionSet));
        MergedField newMergedField = MergedField.newMergedField().addField(transform).build();
        ExecutionStepInfo executionStepInfo = this.executionStepInfoFactory.newExecutionStepInfoForSubField(executionCtx, newMergedField, rootExecutionStepInfo);
        return this.getOneServiceExecution(executionCtx, executionStepInfo, service);
    }

    private List<InlineFragment> wrapFieldsInInlineFragments(ExecutionStepInfo fieldExecutionStepInfo, List<String> serviceObjectTypes, NormalizedQueryFromAst normalizedQuery) {
        return normalizedQuery.getTopLevelFields().stream().filter(field -> field.getFieldDefinition().getName().equals(fieldExecutionStepInfo.getFieldDefinition().getName())).flatMap(field -> field.getChildren().stream().filter(childField -> serviceObjectTypes.contains(childField.getObjectType().getName())).map(normalizedQueryField -> {
            TypeName typeName = TypeName.newTypeName((String)normalizedQueryField.getObjectType().getName()).build();
            return InlineFragment.newInlineFragment().typeCondition(typeName).selectionSet(SelectionSet.newSelectionSet().selection((Selection)((MergedField)normalizedQuery.getMergedFieldByNormalizedFields().get(normalizedQueryField)).getSingleField()).build()).build();
        })).collect(Collectors.toList());
    }

    private List<CompletableFuture<OneServiceExecution>> getServiceExecutionsForNamespacedField(ExecutionContext executionCtx, ExecutionStepInfo rootExecutionStepInfo, MergedField mergedField, ExecutionStepInfo stepInfoForNamespacedField) {
        ArrayList<CompletableFuture<OneServiceExecution>> serviceExecutions = new ArrayList<CompletableFuture<OneServiceExecution>>();
        Assert.assertTrue((boolean)(stepInfoForNamespacedField.getUnwrappedNonNullType() instanceof GraphQLObjectType), () -> "field annotated with @namespaced directive is expected to be of GraphQLObjectType");
        GraphQLObjectType namespacedObjectType = (GraphQLObjectType)stepInfoForNamespacedField.getUnwrappedNonNullType();
        Map<Service, Set<GraphQLFieldDefinition>> serviceSetHashMap = this.fieldInfos.splitObjectFieldsByServices(namespacedObjectType);
        for (Map.Entry<Service, Set<GraphQLFieldDefinition>> entry : serviceSetHashMap.entrySet()) {
            Service service = entry.getKey();
            Set<GraphQLFieldDefinition> secondLevelFieldDefinitionsForService = entry.getValue();
            Optional maybeNewMergedField = MergedFieldUtil.includeSubSelection((MergedField)mergedField, (GraphQLObjectType)namespacedObjectType, (ExecutionContext)executionCtx, field -> secondLevelFieldDefinitionsForService.stream().anyMatch(graphQLFieldDefinition -> NadelExecutionStrategy.fieldMatchesDefinition(graphQLFieldDefinition, field) || NadelExecutionStrategy.isTypename(field) && NamespacedUtil.serviceOwnsNamespacedField((GraphQLObjectType)namespacedObjectType, (Service)service)));
            maybeNewMergedField.ifPresent(newMergedField -> {
                ExecutionStepInfo newFieldExecutionStepInfo = this.executionStepInfoFactory.newExecutionStepInfoForSubField(executionCtx, newMergedField, rootExecutionStepInfo);
                serviceExecutions.add(this.getOneServiceExecution(executionCtx, newFieldExecutionStepInfo, service));
            });
        }
        return serviceExecutions;
    }

    private static boolean isTypename(MergedField field) {
        return field.getName().equals(Introspection.TypeNameMetaFieldDef.getName());
    }

    private static boolean fieldMatchesDefinition(GraphQLFieldDefinition graphQLFieldDefinition, MergedField field) {
        return graphQLFieldDefinition.getName().equals(field.getName());
    }

    private CompletableFuture<OneServiceExecution> getOneServiceExecution(ExecutionContext executionCtx, ExecutionStepInfo fieldExecutionStepInfo, Service service) {
        CreateServiceContextParams parameters = CreateServiceContextParams.newParameters().from(executionCtx).service(service).executionStepInfo(fieldExecutionStepInfo).build();
        CompletableFuture serviceContextCF = this.serviceExecutionHooks.createServiceContext(parameters);
        return serviceContextCF.thenApply(serviceContext -> new OneServiceExecution(service, serviceContext, fieldExecutionStepInfo, false, null, fieldExecutionStepInfo));
    }

    private List<CompletableFuture<RootExecutionResultNode>> executeTopLevelFields(ExecutionContext executionContext, NadelContext nadelContext, OperationKind operationKind, List<OneServiceExecution> oneServiceExecutions, ResultComplexityAggregator resultComplexityAggregator, Set<ResultPath> hydrationInputPaths) {
        ArrayList<CompletableFuture<RootExecutionResultNode>> resultNodes = new ArrayList<CompletableFuture<RootExecutionResultNode>>();
        for (OneServiceExecution oneServiceExecution : oneServiceExecutions) {
            if (oneServiceExecution.earlyFailure) {
                LeafExecutionResultNode leafExecutionResultNode = ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)new LeafExecutionResultNode.Builder().addError(oneServiceExecution.error)).completedValue(null)).fieldDefinition(oneServiceExecution.fieldExecutionStepInfo.getFieldDefinition())).resultPath(oneServiceExecution.fieldExecutionStepInfo.getPath())).alias(oneServiceExecution.fieldExecutionStepInfo.getField().getSingleField().getAlias())).objectType(oneServiceExecution.fieldExecutionStepInfo.getObjectType())).build();
                RootExecutionResultNode rootExecutionResultNode = ((RootExecutionResultNode.Builder)new RootExecutionResultNode.Builder().addChild(leafExecutionResultNode)).build();
                resultNodes.add(CompletableFuture.completedFuture(rootExecutionResultNode));
                continue;
            }
            Service service = oneServiceExecution.service;
            ExecutionStepInfo esi = oneServiceExecution.stepInfo;
            Object serviceContext = oneServiceExecution.serviceContext;
            String operationName = this.buildOperationName(service, executionContext);
            MergedField mergedField = esi.getField();
            GraphQLSchema underlyingSchema = service.getUnderlyingSchema();
            CompletableFuture<QueryTransformationResult> transformedQueryCF = this.queryTransformer.transformMergedFields(executionContext, underlyingSchema, operationName, operationKind, Collections.singletonList(mergedField), this.serviceExecutionHooks, service, serviceContext);
            resultNodes.add((CompletableFuture<RootExecutionResultNode>)transformedQueryCF.thenCompose(transformedQuery -> {
                CompletionStage<RootExecutionResultNode> convertedResult;
                Map<String, FieldTransformation> transformationIdToTransformation = transformedQuery.getTransformations().getTransformationIdToTransformation();
                Map<String, String> typeRenameMappings = transformedQuery.getTransformations().getTypeRenameMappings();
                Map<FieldTransformation, String> transformationToFieldId = transformedQuery.getTransformations().getTransformationToFieldId();
                ExecutionContext newExecutionContext = this.buildServiceVariableOverrides(executionContext, transformedQuery.getVariableValues());
                Optional<GraphQLError> maybeFieldForbiddenError = this.getForbiddenTopLevelFieldError(esi, (QueryTransformationResult)transformedQuery);
                if (maybeFieldForbiddenError.isPresent()) {
                    GraphQLError fieldForbiddenError = maybeFieldForbiddenError.get();
                    return CompletableFuture.completedFuture(this.getForbiddenTopLevelFieldResult(nadelContext, esi, fieldForbiddenError));
                }
                if (this.skipTransformationProcessing((QueryTransformationResult)transformedQuery)) {
                    convertedResult = this.serviceExecutor.execute(newExecutionContext, (QueryTransformationResult)transformedQuery, service, operationKind, serviceContext, this.overallSchema, null);
                    resultComplexityAggregator.incrementServiceNodeCount(service.getName(), 0);
                } else {
                    CompletableFuture<RootExecutionResultNode> serviceCallResult = this.serviceExecutor.execute(newExecutionContext, (QueryTransformationResult)transformedQuery, service, operationKind, serviceContext, service.getUnderlyingSchema(), null);
                    convertedResult = serviceCallResult.thenApply(resultNode -> {
                        if (nadelContext.getUserSuppliedContext() instanceof BenchmarkContext) {
                            BenchmarkContext benchmarkContext = (BenchmarkContext)nadelContext.getUserSuppliedContext();
                            benchmarkContext.serviceResultNodesToOverallResult.executionId = newExecutionContext.getExecutionId();
                            benchmarkContext.serviceResultNodesToOverallResult.resultNode = resultNode;
                            benchmarkContext.serviceResultNodesToOverallResult.overallSchema = this.overallSchema;
                            benchmarkContext.serviceResultNodesToOverallResult.correctRootNode = resultNode;
                            benchmarkContext.serviceResultNodesToOverallResult.transformationIdToTransformation = transformationIdToTransformation;
                            benchmarkContext.serviceResultNodesToOverallResult.typeRenameMappings = typeRenameMappings;
                            benchmarkContext.serviceResultNodesToOverallResult.nadelContext = nadelContext;
                            benchmarkContext.serviceResultNodesToOverallResult.transformationMetadata = transformedQuery.getRemovedFieldMap();
                        }
                        return (RootExecutionResultNode)this.serviceResultNodesToOverallResult.convert(newExecutionContext.getExecutionId(), (ExecutionResultNode)resultNode, this.overallSchema, (ExecutionResultNode)resultNode, transformationIdToTransformation, transformationToFieldId, typeRenameMappings, nadelContext, transformedQuery.getRemovedFieldMap(), hydrationInputPaths);
                    });
                    ((CompletableFuture)convertedResult).thenAccept(rootExecutionResultNode -> {
                        resultComplexityAggregator.incrementServiceNodeCount(service.getName(), rootExecutionResultNode.getTotalNodeCount());
                        resultComplexityAggregator.incrementFieldRenameCount(rootExecutionResultNode.getTotalFieldRenameCount());
                        resultComplexityAggregator.incrementTypeRenameCount(rootExecutionResultNode.getTotalTypeRenameCount());
                    });
                }
                CompletionStage<RootExecutionResultNode> serviceResult = convertedResult;
                if (this.serviceExecutionHooks instanceof EngineServiceExecutionHooks) {
                    serviceResult = serviceResult.thenCompose(rootResultNode -> {
                        ResultRewriteParams resultRewriteParams = ResultRewriteParams.newParameters().from(executionContext).service(service).serviceContext(serviceContext).executionStepInfo(esi).resultNode((RootExecutionResultNode)rootResultNode).build();
                        return ((EngineServiceExecutionHooks)this.serviceExecutionHooks).resultRewrite(resultRewriteParams);
                    });
                }
                return serviceResult;
            }));
        }
        return resultNodes;
    }

    private Optional<GraphQLError> getForbiddenTopLevelFieldError(ExecutionStepInfo esi, QueryTransformationResult transformedQuery) {
        GraphQLFieldDefinition fieldDefinition = esi.getFieldDefinition();
        String topLevelFieldId = NodeId.getId((GraphQLFieldDefinition)fieldDefinition);
        return transformedQuery.getRemovedFieldMap().getRemovedFieldById(topLevelFieldId).map(TransformationMetadata.NormalizedFieldAndError::getError);
    }

    private RootExecutionResultNode getForbiddenTopLevelFieldResult(NadelContext nadelContext, ExecutionStepInfo esi, GraphQLError error) {
        String topLevelFieldResultKey = esi.getResultKey();
        NormalizedQueryFromAst overallQuery = nadelContext.getNormalizedOverallQuery();
        NormalizedQueryField topLevelField = overallQuery.getTopLevelField(topLevelFieldResultKey);
        return this.resultToResultNode.createResultWithNullTopLevelField(overallQuery, topLevelField, Collections.singletonList(error), Collections.emptyMap());
    }

    private <T> void possiblyLogException(T result, Throwable exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    private ExecutionContext buildServiceVariableOverrides(ExecutionContext executionContext, Map<String, Object> overrideVariables) {
        if (!overrideVariables.isEmpty()) {
            Map<String, Object> newVariables = this.mergeVariables(executionContext.getVariables(), overrideVariables);
            executionContext = executionContext.transform(builder -> builder.variables(newVariables));
        }
        return executionContext;
    }

    private Map<String, Object> mergeVariables(Map<String, Object> variables, Map<String, Object> overrideVariables) {
        LinkedHashMap<String, Object> newVariables = new LinkedHashMap<String, Object>(variables);
        newVariables.putAll(overrideVariables);
        return newVariables;
    }

    private CompletableFuture<RootExecutionResultNode> mergeTrees(List<CompletableFuture<RootExecutionResultNode>> resultNodes) {
        return Async.each(resultNodes).thenApply(StrategyUtil::mergeTrees);
    }

    private Service getServiceForFieldDefinition(GraphQLFieldDefinition fieldDefinition) {
        FieldInfo info = (FieldInfo)Assert.assertNotNull((Object)this.fieldInfos.getInfo(fieldDefinition), () -> String.format("no field info for field %s", fieldDefinition.getName()));
        return info.getService();
    }

    private String buildOperationName(Service service, ExecutionContext executionContext) {
        NadelContext nadelContext = (NadelContext)executionContext.getContext();
        String originalOperationName = nadelContext.getOriginalOperationName();
        return OperationNameUtil.getLegacyOperationName((String)service.getName(), (String)originalOperationName);
    }

    private NadelContext getNadelContext(ExecutionContext executionContext) {
        return (NadelContext)executionContext.getContext();
    }

    private boolean skipTransformationProcessing(QueryTransformationResult transformedQuery) {
        TransformationState transformations = transformedQuery.getTransformations();
        return transformations.getTransformationIdToTransformation().isEmpty() && transformations.getTypeRenameMappings().isEmpty() && !transformedQuery.getRemovedFieldMap().hasRemovedFields() && transformations.getHintTypenames().isEmpty();
    }

    public static class ExecutionPathSet
    extends LinkedHashSet<ResultPath> {
        @Override
        public boolean add(ResultPath executionPath) {
            for (ResultPath path = executionPath.getParent(); path != null; path = path.getParent()) {
                super.add(path);
            }
            return super.add(executionPath);
        }
    }

    private static class OneServiceExecution {
        final Service service;
        final Object serviceContext;
        final ExecutionStepInfo stepInfo;
        final boolean earlyFailure;
        final GraphQLError error;
        final ExecutionStepInfo fieldExecutionStepInfo;

        public OneServiceExecution(Service service, Object serviceContext, ExecutionStepInfo stepInfo, boolean earlyFailure, GraphQLError error, ExecutionStepInfo fieldExecutionStepInfo) {
            this.service = service;
            this.serviceContext = serviceContext;
            this.stepInfo = stepInfo;
            this.earlyFailure = earlyFailure;
            this.error = error;
            this.fieldExecutionStepInfo = fieldExecutionStepInfo;
        }
    }
}

