/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.ExecutionId;
import graphql.execution.MergedField;
import graphql.execution.ResultPath;
import graphql.language.AbstractNode;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.dsl.UnderlyingServiceHydration;
import graphql.nadel.engine.NadelContext;
import graphql.nadel.engine.Tuples;
import graphql.nadel.engine.TuplesTwo;
import graphql.nadel.engine.execution.ArtificialFieldUtils;
import graphql.nadel.engine.execution.ExecutionResultNodeMapper;
import graphql.nadel.engine.execution.FieldMetadataUtil;
import graphql.nadel.engine.execution.HydrationInputNode;
import graphql.nadel.engine.execution.ResolvedValueMapper;
import graphql.nadel.engine.execution.ResultNodesTransformer;
import graphql.nadel.engine.execution.StrategyUtil;
import graphql.nadel.engine.execution.UnapplyEnvironment;
import graphql.nadel.engine.execution.transformation.FieldMetadata;
import graphql.nadel.engine.execution.transformation.FieldTransformation;
import graphql.nadel.engine.execution.transformation.HydrationTransformation;
import graphql.nadel.engine.execution.transformation.TransformationMetadata;
import graphql.nadel.engine.execution.transformation.UnapplyResult;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.LeafExecutionResultNode;
import graphql.nadel.engine.result.ListExecutionResultNode;
import graphql.nadel.engine.result.ObjectExecutionResultNode;
import graphql.nadel.engine.result.ResultCounter;
import graphql.nadel.engine.result.RootExecutionResultNode;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.nadel.normalized.NormalizedQueryFromAst;
import graphql.nadel.util.FpKit;
import graphql.schema.GraphQLSchema;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import graphql.util.TraverserVisitorStub;
import graphql.util.TreeTransformerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class ServiceResultNodesToOverallResult {
    ExecutionResultNodeMapper executionResultNodeMapper = new ExecutionResultNodeMapper();
    ResolvedValueMapper resolvedValueMapper = new ResolvedValueMapper();
    ResultNodesTransformer resultNodesTransformer = new ResultNodesTransformer();

    public ExecutionResultNode convert(ExecutionId executionId, ExecutionResultNode resultNode, GraphQLSchema overallSchema, ExecutionResultNode correctRootNode, Map<String, FieldTransformation> transformationIdToTransformation, Map<FieldTransformation, String> transformationToFieldId, Map<String, String> typeRenameMappings, NadelContext nadelContext, TransformationMetadata transformationMetadata, Set<ResultPath> hydrationInputPaths) {
        return this.convertImpl(executionId, resultNode, null, overallSchema, correctRootNode, false, false, transformationIdToTransformation, transformationToFieldId, typeRenameMappings, false, nadelContext, transformationMetadata, hydrationInputPaths);
    }

    public ExecutionResultNode convertChildren(ExecutionId executionId, ExecutionResultNode root, NormalizedQueryField normalizedRootField, GraphQLSchema overallSchema, ExecutionResultNode correctRootNode, boolean isHydrationTransformation, boolean batched, Map<String, FieldTransformation> transformationIdToTransformation, Map<FieldTransformation, String> transformationToFieldId, Map<String, String> typeRenameMappings, NadelContext nadelContext, TransformationMetadata transformationMetadata, Set<ResultPath> hydrationInputPaths) {
        return this.convertImpl(executionId, root, normalizedRootField, overallSchema, correctRootNode, isHydrationTransformation, batched, transformationIdToTransformation, transformationToFieldId, typeRenameMappings, true, nadelContext, transformationMetadata, hydrationInputPaths);
    }

    private ExecutionResultNode convertImpl(ExecutionId executionId, ExecutionResultNode root, NormalizedQueryField normalizedRootField, GraphQLSchema overallSchema, ExecutionResultNode correctRootNode, boolean isHydrationTransformation, boolean batched, Map<String, FieldTransformation> transformationIdToTransformation, Map<FieldTransformation, String> transformationToFieldId, Map<String, String> typeRenameMappings, boolean onlyChildren, NadelContext nadelContext, TransformationMetadata transformationMetadata, Set<ResultPath> hydrationInputPaths) {
        ResultCounter resultCounter = new ResultCounter();
        HandleResult handleResult = this.convertSingleNode(root, null, null, executionId, root, normalizedRootField, overallSchema, isHydrationTransformation, batched, transformationIdToTransformation, transformationToFieldId, typeRenameMappings, onlyChildren, nadelContext, transformationMetadata, resultCounter, hydrationInputPaths);
        Assert.assertNotNull((Object)handleResult, () -> "can't delete root");
        Assert.assertTrue((boolean)handleResult.siblings.isEmpty(), () -> "can't add siblings to root");
        ExecutionResultNode changedNode = handleResult.changedNode;
        ArrayList<ExecutionResultNode> newChildren = new ArrayList<ExecutionResultNode>();
        for (ExecutionResultNode child : changedNode.getChildren()) {
            HandleResult handleResultChild = this.convertRecursively(child, correctRootNode, changedNode, executionId, root, normalizedRootField, overallSchema, isHydrationTransformation, batched, transformationIdToTransformation, transformationToFieldId, typeRenameMappings, onlyChildren, nadelContext, transformationMetadata, resultCounter, hydrationInputPaths);
            if (handleResultChild == null) continue;
            newChildren.add(handleResultChild.changedNode);
            newChildren.addAll(handleResultChild.siblings);
        }
        return changedNode.transform(builder -> ((ExecutionResultNode.BuilderBase)((ExecutionResultNode.BuilderBase)((ExecutionResultNode.BuilderBase)builder.children(newChildren)).totalNodeCount(resultCounter.getNodeCount())).totalFieldRenameCount(resultCounter.getFieldRenameCount())).totalTypeRenameCount(resultCounter.getTypeRenameCount()));
    }

    private HandleResult convertRecursively(ExecutionResultNode node, ExecutionResultNode correctParentNode, ExecutionResultNode directParentNode, ExecutionId executionId, ExecutionResultNode root, NormalizedQueryField normalizedRootField, GraphQLSchema overallSchema, boolean isHydrationTransformation, boolean batched, Map<String, FieldTransformation> transformationIdToTransformation, Map<FieldTransformation, String> transformationToFieldId, Map<String, String> typeRenameMappings, boolean onlyChildren, NadelContext nadelContext, TransformationMetadata transformationMetadata, ResultCounter resultCounter, Set<ResultPath> hydrationInputPaths) {
        HandleResult handleResult = this.convertSingleNode(node, correctParentNode, directParentNode, executionId, root, normalizedRootField, overallSchema, isHydrationTransformation, batched, transformationIdToTransformation, transformationToFieldId, typeRenameMappings, onlyChildren, nadelContext, transformationMetadata, resultCounter, hydrationInputPaths);
        if (handleResult == null) {
            return null;
        }
        if (handleResult.traversalControl == TraversalControl.ABORT) {
            return handleResult;
        }
        ExecutionResultNode changedNode = handleResult.changedNode;
        ArrayList<ExecutionResultNode> newChildren = new ArrayList<ExecutionResultNode>();
        for (ExecutionResultNode child : changedNode.getChildren()) {
            HandleResult handleResultChild = this.convertRecursively(child, changedNode, changedNode, executionId, root, normalizedRootField, overallSchema, isHydrationTransformation, batched, transformationIdToTransformation, transformationToFieldId, typeRenameMappings, onlyChildren, nadelContext, transformationMetadata, resultCounter, hydrationInputPaths);
            if (handleResultChild == null) continue;
            newChildren.add(handleResultChild.changedNode);
            newChildren.addAll(handleResultChild.siblings);
        }
        handleResult.changedNode = changedNode.withNewChildren(newChildren);
        return handleResult;
    }

    private HandleResult convertSingleNode(ExecutionResultNode node, ExecutionResultNode correctParentNode, ExecutionResultNode directParentNode, ExecutionId executionId, ExecutionResultNode root, NormalizedQueryField normalizedRootField, GraphQLSchema overallSchema, boolean isHydrationTransformation, boolean batched, Map<String, FieldTransformation> transformationIdToTransformation, Map<FieldTransformation, String> transformationToFieldId, Map<String, String> typeRenameMappings, boolean onlyChildren, NadelContext nadelContext, TransformationMetadata transformationMetadata, ResultCounter resultCounter, Set<ResultPath> hydrationInputPaths) {
        HandleResult result;
        resultCounter.incrementNodeCount();
        if (onlyChildren && node == root) {
            if (normalizedRootField != null) {
                ExecutionResultNodeMapper.checkForTypeRename(normalizedRootField.getFieldDefinition(), node.getFieldDefinition(), typeRenameMappings, resultCounter, 0);
            }
            if (root instanceof ObjectExecutionResultNode) {
                ExecutionResultNode executionResultNode = this.addDeletedChildren((ObjectExecutionResultNode)node, normalizedRootField, nadelContext, transformationMetadata);
                return HandleResult.simple(executionResultNode);
            }
            return HandleResult.simple(node);
        }
        if (node instanceof RootExecutionResultNode) {
            RootExecutionResultNode convertedNode = this.mapRootResultNode((RootExecutionResultNode)node);
            return HandleResult.simple(convertedNode);
        }
        if (node instanceof LeafExecutionResultNode && ArtificialFieldUtils.isArtificialField(nadelContext, node.getAlias())) {
            resultCounter.decrementNodeCount();
            return null;
        }
        TuplesTwo<Set<FieldTransformation>, List<String>> transformationsAndNotTransformedFields = this.getTransformationsAndNotTransformedFields(node, transformationIdToTransformation, transformationMetadata);
        ArrayList<FieldTransformation> transformations = new ArrayList<FieldTransformation>((Collection)transformationsAndNotTransformedFields.getT1());
        UnapplyEnvironment unapplyEnvironment = new UnapplyEnvironment(correctParentNode, directParentNode, isHydrationTransformation, batched, typeRenameMappings, overallSchema);
        if (transformations.isEmpty()) {
            result = HandleResult.simple(this.mapNode(node, unapplyEnvironment, resultCounter));
        } else {
            result = this.unapplyTransformations(executionId, node, transformations, unapplyEnvironment, transformationIdToTransformation, transformationToFieldId, nadelContext, transformationMetadata, resultCounter, hydrationInputPaths);
            if (result == null) {
                return null;
            }
        }
        if (result.changedNode instanceof ObjectExecutionResultNode && !(correctParentNode instanceof HydrationInputNode)) {
            result.changedNode = this.addDeletedChildren((ObjectExecutionResultNode)result.changedNode, null, nadelContext, transformationMetadata);
        }
        return result;
    }

    private ExecutionResultNode addDeletedChildren(ObjectExecutionResultNode resultNode, NormalizedQueryField normalizedQueryField, NadelContext nadelContext, TransformationMetadata transformationMetadata) {
        List<TransformationMetadata.NormalizedFieldAndError> removedFields;
        if (normalizedQueryField == null) {
            normalizedQueryField = this.getNormalizedQueryFieldForResultNode((ObjectExecutionResultNode)resultNode, nadelContext.getNormalizedOverallQuery());
        }
        if (!(removedFields = transformationMetadata.getRemovedFieldsForParent(normalizedQueryField)).isEmpty()) {
            boolean isFirstNode = this.isFirstNode((ObjectExecutionResultNode)resultNode);
            for (TransformationMetadata.NormalizedFieldAndError normalizedFieldAndError : removedFields) {
                NormalizedQueryField field = normalizedFieldAndError.getNormalizedField();
                GraphQLError error = isFirstNode ? normalizedFieldAndError.getError() : null;
                MergedField mergedField = (MergedField)nadelContext.getNormalizedOverallQuery().getMergedFieldByNormalizedFields().get(field);
                LeafExecutionResultNode newChild = this.createRemovedFieldResult(resultNode, mergedField, field, error);
                resultNode = resultNode.transform(b -> b.addChild(newChild));
            }
        }
        return resultNode;
    }

    private LeafExecutionResultNode createRemovedFieldResult(ExecutionResultNode parent, MergedField mergedField, NormalizedQueryField normalizedQueryField, GraphQLError error) {
        ResultPath parentPath = parent.getResultPath();
        ResultPath executionPath = parentPath.segment(normalizedQueryField.getResultKey());
        LeafExecutionResultNode removedNode = ((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)((LeafExecutionResultNode.Builder)LeafExecutionResultNode.newLeafExecutionResultNode().resultPath(executionPath)).alias(mergedField.getSingleField().getAlias())).fieldIds(NodeId.getIds((MergedField)mergedField))).objectType(normalizedQueryField.getObjectType())).fieldDefinition(normalizedQueryField.getFieldDefinition())).completedValue(null)).errors(error != null ? Collections.singletonList(error) : Collections.emptyList())).build();
        return removedNode;
    }

    private HandleResult unapplyTransformations(ExecutionId executionId, ExecutionResultNode node, List<FieldTransformation> transformations, UnapplyEnvironment unapplyEnvironment, Map<String, FieldTransformation> transformationIdToTransformation, Map<FieldTransformation, String> transformationToFieldId, NadelContext nadelContext, TransformationMetadata transformationMetadata, ResultCounter resultCounter, Set<ResultPath> hydrationInputPaths) {
        if (this.isArtificialHydrationNode(node.getFieldIds(), new HashSet<String>(transformationToFieldId.values()))) {
            if (this.getFieldIdsWithoutTransformations(node, transformationMetadata).isEmpty()) {
                return null;
            }
            HandleResult handleResult = HandleResult.simple(this.nodesWithTransformationIds(node, null, transformationMetadata));
            handleResult.traversalControl = TraversalControl.ABORT;
            return handleResult;
        }
        Map transformationByDefinition = graphql.util.FpKit.groupingBy(transformations, FieldTransformation::getDefinition);
        TuplesTwo<ExecutionResultNode, Map<AbstractNode, List<ExecutionResultNode>>> splittedNodes = this.splitTreeByTransformationDefinition(node, unapplyEnvironment.directParentNode, transformationIdToTransformation, transformationToFieldId, transformationMetadata);
        ExecutionResultNode notTransformedTree = splittedNodes.getT1();
        Map<AbstractNode, List<ExecutionResultNode>> nodesWithTransformedFields = splittedNodes.getT2();
        ArrayList<UnapplyResult> unapplyResults = new ArrayList<UnapplyResult>();
        for (AbstractNode definition : nodesWithTransformedFields.keySet()) {
            List transformationsForDefinition = (List)transformationByDefinition.get(definition);
            FieldTransformation transformation = (FieldTransformation)transformationsForDefinition.get(0);
            boolean isHydrationTransformation = transformation instanceof HydrationTransformation;
            List<ExecutionResultNode> transformedNodes = nodesWithTransformedFields.get(definition);
            ExecutionResultNode resultNode = transformedNodes.get(0);
            if (isHydrationTransformation) {
                resultNode = this.mergeHydrationNodes(transformedNodes, resultNode);
            }
            UnapplyResult unapplyResult = transformation.unapplyResultNode(resultNode, transformationsForDefinition, unapplyEnvironment);
            if (isHydrationTransformation) {
                int typeDecrementValue = unapplyResult.getNode() instanceof ListExecutionResultNode ? -unapplyResult.getNode().getChildren().size() : -1;
                ExecutionResultNodeMapper.checkForTypeRename(unapplyResult.getNode().getFieldDefinition(), node.getFieldDefinition(), unapplyEnvironment.typeRenameMappings, resultCounter, typeDecrementValue);
                hydrationInputPaths.add(unapplyResult.getNode().getResultPath());
            } else {
                ExecutionResultNodeMapper.checkForTypeRename(unapplyResult.getNode().getFieldDefinition(), node.getFieldDefinition(), unapplyEnvironment.typeRenameMappings, resultCounter, 0);
                resultCounter.incrementFieldRenameCount();
            }
            unapplyResults.add(unapplyResult);
        }
        HandleResult handleResult = HandleResult.newHandleResultWithSiblings();
        boolean first = true;
        if (notTransformedTree != null) {
            ExecutionResultNode mappedNode = this.mapNode(notTransformedTree, unapplyEnvironment, resultCounter);
            handleResult.changedNode = mappedNode = this.convertChildren(executionId, mappedNode, null, unapplyEnvironment.overallSchema, unapplyEnvironment.correctParentNode, unapplyEnvironment.isHydrationTransformation, unapplyEnvironment.batched, transformationIdToTransformation, transformationToFieldId, unapplyEnvironment.typeRenameMappings, nadelContext, transformationMetadata, hydrationInputPaths);
            resultCounter.incrementFieldRenameCount(mappedNode.getTotalFieldRenameCount());
            resultCounter.incrementTypeRenameCount(mappedNode.getTotalTypeRenameCount());
            resultCounter.incrementNodeCount(mappedNode.getTotalNodeCount() - 1);
            first = false;
        }
        for (UnapplyResult unapplyResult : unapplyResults) {
            ExecutionResultNode transformedResult;
            if (unapplyResult.getTraversalControl() != TraversalControl.CONTINUE) {
                transformedResult = unapplyResult.getNode();
            } else {
                ExecutionResultNode unapplyResultNode = unapplyResult.getNode();
                transformedResult = this.convertChildren(executionId, unapplyResultNode, null, unapplyEnvironment.overallSchema, unapplyResultNode, unapplyEnvironment.isHydrationTransformation, unapplyEnvironment.batched, transformationIdToTransformation, transformationToFieldId, unapplyEnvironment.typeRenameMappings, nadelContext, transformationMetadata, hydrationInputPaths);
            }
            resultCounter.incrementFieldRenameCount(transformedResult.getTotalFieldRenameCount());
            resultCounter.incrementTypeRenameCount(transformedResult.getTotalTypeRenameCount());
            if (first) {
                handleResult.changedNode = transformedResult;
                first = false;
                continue;
            }
            handleResult.siblings.add(transformedResult);
        }
        handleResult.traversalControl = TraversalControl.ABORT;
        return handleResult;
    }

    private ExecutionResultNode mergeHydrationNodes(List<ExecutionResultNode> nodesWithTransformedFields, ExecutionResultNode primaryNode) {
        if (primaryNode.isNullValue()) {
            return primaryNode;
        }
        LinkedHashMap<String, Object> completedValues = new LinkedHashMap<String, Object>();
        boolean isListSource = primaryNode instanceof ListExecutionResultNode;
        for (ExecutionResultNode hydrationNode : nodesWithTransformedFields) {
            Object value = hydrationNode.getCompletedValue();
            String resultKey = hydrationNode.getResultKey();
            completedValues.put(resultKey, value);
            if (hydrationNode.getResultPath().equals((Object)primaryNode.getResultPath())) {
                primaryNode = hydrationNode;
            }
            if (isListSource) {
                Assert.assertTrue((boolean)(hydrationNode instanceof ListExecutionResultNode), () -> String.format("Expected source argument %s to return a list of values", hydrationNode.getResultKey()));
                continue;
            }
            Assert.assertTrue((!(hydrationNode instanceof ListExecutionResultNode) ? 1 : 0) != 0, () -> String.format("Expected source argument %s to return a single value", hydrationNode.getResultKey()));
        }
        if (isListSource) {
            return this.mergeListHydrationNodeValues(primaryNode, completedValues);
        }
        if (primaryNode instanceof ObjectExecutionResultNode) {
            return this.mergeObjectHydrationNodeValues(primaryNode, completedValues);
        }
        return primaryNode.withNewCompletedValue(completedValues);
    }

    private ExecutionResultNode mergeListHydrationNodeValues(ExecutionResultNode primaryNode, Map<String, Object> completedValues) {
        ArrayList<ExecutionResultNode> newChildren = new ArrayList<ExecutionResultNode>();
        for (int index = 0; index < primaryNode.getChildren().size(); ++index) {
            ExecutionResultNode child = primaryNode.getChildren().get(index);
            LinkedHashMap<String, Object> childCompletedValues = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : completedValues.entrySet()) {
                Object value = entry.getValue();
                value = index < ((List)value).size() ? ((List)value).get(index) : null;
                childCompletedValues.put(entry.getKey(), value);
            }
            if (child instanceof ObjectExecutionResultNode) {
                child = this.mergeObjectHydrationNodeValues(child, childCompletedValues);
            } else if (!child.isNullValue()) {
                child = child.withNewCompletedValue(childCompletedValues);
            }
            newChildren.add(child);
        }
        return primaryNode.withNewChildren(newChildren).transform(builder -> builder.fieldId(primaryNode.getFieldIds().get(0)));
    }

    private ExecutionResultNode mergeObjectHydrationNodeValues(ExecutionResultNode node, Map<String, Object> completedValues) {
        return this.changeLeafValueInObjectNode(node, completedValues).get(0);
    }

    private List<ExecutionResultNode> changeLeafValueInObjectNode(ExecutionResultNode node, Map<String, Object> completedValues) {
        if (node instanceof LeafExecutionResultNode) {
            if (!node.isNullValue()) {
                node = node.withNewCompletedValue(completedValues);
            }
            return new ArrayList<ExecutionResultNode>(Collections.singletonList(node));
        }
        List<ExecutionResultNode> modifiedChildren = this.changeLeafValueInObjectNode(node.getChildren().get(0), completedValues);
        return new ArrayList<ExecutionResultNode>(Collections.singletonList(node.transform(builder -> builder.children(modifiedChildren))));
    }

    private TuplesTwo<ExecutionResultNode, Map<AbstractNode, List<ExecutionResultNode>>> splitTreeByTransformationDefinition(ExecutionResultNode executionResultNode, ExecutionResultNode directParentNode, Map<String, FieldTransformation> transformationIdToTransformation, Map<FieldTransformation, String> transformationToFieldId, TransformationMetadata transformationMetadata) {
        if (executionResultNode instanceof RootExecutionResultNode) {
            return Tuples.of(executionResultNode, Collections.emptyMap());
        }
        LinkedHashMap transformationIdsByTransformationDefinition = new LinkedHashMap();
        List<String> fieldIds = executionResultNode.getFieldIds();
        LinkedHashSet<String> rootTransformationIdsForNode = new LinkedHashSet<String>();
        for (String fieldId : fieldIds) {
            List<String> rootTransformationIdsForFieldId = FieldMetadataUtil.getRootOfTransformationIds(fieldId, transformationMetadata.getMetadataByFieldId());
            for (String rootTransformationId : rootTransformationIdsForFieldId) {
                FieldTransformation fieldTransformation = (FieldTransformation)Assert.assertNotNull((Object)transformationIdToTransformation.get(rootTransformationId));
                rootTransformationIdsForNode.addAll(rootTransformationIdsForFieldId);
                if (!transformationToFieldId.containsKey(fieldTransformation) || !transformationToFieldId.get(fieldTransformation).equals(fieldId)) continue;
                AbstractNode definition = fieldTransformation.getDefinition();
                transformationIdsByTransformationDefinition.putIfAbsent(definition, new LinkedHashSet());
                ((Set)transformationIdsByTransformationDefinition.get(definition)).add(rootTransformationId);
            }
        }
        LinkedHashMap<AbstractNode, List<ExecutionResultNode>> treesByTransformationDefinition = new LinkedHashMap<AbstractNode, List<ExecutionResultNode>>();
        Set<AbstractNode> definitions = transformationIdsByTransformationDefinition.keySet();
        boolean canSkipTraversal = this.canSkipTraversal(definitions, executionResultNode, transformationMetadata);
        if (canSkipTraversal) {
            treesByTransformationDefinition.put(definitions.iterator().next(), Collections.singletonList(executionResultNode));
        } else {
            for (AbstractNode definition : definitions) {
                Set transformationIds = (Set)transformationIdsByTransformationDefinition.get(definition);
                treesByTransformationDefinition.putIfAbsent(definition, new ArrayList());
                ((List)treesByTransformationDefinition.get(definition)).add(this.nodesWithTransformationIds(executionResultNode, transformationIds, transformationMetadata));
                if (!(definition instanceof UnderlyingServiceHydration)) continue;
                for (ExecutionResultNode child : directParentNode.getChildren()) {
                    if (child == executionResultNode || this.getFieldIdsWithTransformationIds(child, transformationIds, transformationMetadata).isEmpty()) continue;
                    ExecutionResultNode resultNode = this.nodesWithTransformationIds(child, transformationIds, transformationMetadata);
                    ((List)treesByTransformationDefinition.get(definition)).add(resultNode);
                }
            }
        }
        ExecutionResultNode treeWithoutRootTransformations = canSkipTraversal ? null : this.nodesWithoutTransformationIds(executionResultNode, rootTransformationIdsForNode, transformationMetadata);
        return Tuples.of(treeWithoutRootTransformations, treesByTransformationDefinition);
    }

    private boolean canSkipTraversal(Set<AbstractNode> definitions, ExecutionResultNode executionResultNode, TransformationMetadata transformationMetadata) {
        return definitions.size() == 1 && !(definitions.iterator().next() instanceof UnderlyingServiceHydration) && this.getFieldIdsWithoutTransformations(executionResultNode, transformationMetadata).isEmpty();
    }

    private ExecutionResultNode nodesWithTransformationIds(ExecutionResultNode executionResultNode, final Set<String> transformationIds, final TransformationMetadata transformationMetadata) {
        return this.resultNodesTransformer.transform(executionResultNode, (TraverserVisitor<ExecutionResultNode>)new TraverserVisitorStub<ExecutionResultNode>(){

            public TraversalControl enter(TraverserContext<ExecutionResultNode> context) {
                ExecutionResultNode node = (ExecutionResultNode)context.thisNode();
                List<String> fieldIdsWithId = transformationIds == null ? ServiceResultNodesToOverallResult.this.getFieldIdsWithoutTransformations(node, transformationMetadata) : ServiceResultNodesToOverallResult.this.getFieldIdsWithTransformationIds(node, transformationIds, transformationMetadata);
                if (fieldIdsWithId.isEmpty()) {
                    return TreeTransformerUtil.deleteNode(context);
                }
                ExecutionResultNode changedNode = StrategyUtil.changeFieldIsInResultNode(node, fieldIdsWithId);
                return TreeTransformerUtil.changeNode(context, (Object)changedNode);
            }
        });
    }

    private ExecutionResultNode nodesWithoutTransformationIds(ExecutionResultNode executionResultNode, final Set<String> transformationIds, final TransformationMetadata transformationMetadata) {
        return this.resultNodesTransformer.transform(executionResultNode, (TraverserVisitor<ExecutionResultNode>)new TraverserVisitorStub<ExecutionResultNode>(){

            public TraversalControl enter(TraverserContext<ExecutionResultNode> context) {
                ExecutionResultNode node = (ExecutionResultNode)context.thisNode();
                List<String> fieldIdsWithoutTransformationIds = ServiceResultNodesToOverallResult.this.getFieldIdsWithoutTransformationIds(node, transformationIds, transformationMetadata);
                if (fieldIdsWithoutTransformationIds.isEmpty()) {
                    return TreeTransformerUtil.deleteNode(context);
                }
                ExecutionResultNode changedNode = StrategyUtil.changeFieldIsInResultNode(node, fieldIdsWithoutTransformationIds);
                return TreeTransformerUtil.changeNode(context, (Object)changedNode);
            }
        });
    }

    private List<String> getFieldIdsWithoutTransformationIds(ExecutionResultNode node, Set<String> transformationIds, TransformationMetadata transformationMetadata) {
        return FpKit.filter(node.getFieldIds(), fieldId -> {
            Map<String, List<FieldMetadata>> metadataByFieldId = transformationMetadata.getMetadataByFieldId();
            List<String> transformationIdsForFieldId = FieldMetadataUtil.getTransformationIds(fieldId, metadataByFieldId);
            return Collections.disjoint(transformationIdsForFieldId, transformationIds);
        });
    }

    private List<String> getFieldIdsWithoutTransformations(ExecutionResultNode node, TransformationMetadata transformationMetadata) {
        return FpKit.filter(node.getFieldIds(), fieldId -> {
            Map<String, List<FieldMetadata>> metadataByFieldId = transformationMetadata.getMetadataByFieldId();
            List<String> transformationIdsForFieldId = FieldMetadataUtil.getTransformationIds(fieldId, metadataByFieldId);
            return transformationIdsForFieldId.isEmpty();
        });
    }

    private List<String> getFieldIdsWithTransformationIds(ExecutionResultNode node, Set<String> transformationIds, TransformationMetadata transformationMetadata) {
        return FpKit.filter(node.getFieldIds(), fieldId -> {
            List<String> transformationIdsForField = FieldMetadataUtil.getTransformationIds(fieldId, transformationMetadata.getMetadataByFieldId());
            return transformationIdsForField.stream().anyMatch(transformationIds::contains);
        });
    }

    private ExecutionResultNode mapNode(ExecutionResultNode node, UnapplyEnvironment environment, ResultCounter resultCounter) {
        ExecutionResultNode mappedNode = this.executionResultNodeMapper.mapERNFromUnderlyingToOverall(node, environment, resultCounter);
        mappedNode = this.resolvedValueMapper.mapCompletedValue(mappedNode, environment);
        return mappedNode;
    }

    private TuplesTwo<Set<FieldTransformation>, List<String>> getTransformationsAndNotTransformedFields(ExecutionResultNode node, Map<String, FieldTransformation> transformationIdToTransformation, TransformationMetadata transformationMetadata) {
        LinkedHashSet<FieldTransformation> transformations = new LinkedHashSet<FieldTransformation>();
        ArrayList<String> notTransformedFields = new ArrayList<String>();
        for (String fieldId : node.getFieldIds()) {
            if (node.getResultPath().isListSegment()) {
                notTransformedFields.add(fieldId);
                continue;
            }
            List<String> rootTransformationIds = FieldMetadataUtil.getRootOfTransformationIds(fieldId, transformationMetadata.getMetadataByFieldId());
            if (rootTransformationIds.isEmpty()) {
                notTransformedFields.add(fieldId);
                continue;
            }
            for (String transformationId : rootTransformationIds) {
                FieldTransformation fieldTransformation = transformationIdToTransformation.get(transformationId);
                transformations.add(fieldTransformation);
            }
        }
        return Tuples.of(transformations, notTransformedFields);
    }

    private RootExecutionResultNode mapRootResultNode(RootExecutionResultNode resultNode) {
        return ((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)((RootExecutionResultNode.Builder)RootExecutionResultNode.newRootExecutionResultNode().children(resultNode.getChildren())).errors(resultNode.getErrors())).extensions(resultNode.getExtensions())).elapsedTime(resultNode.getElapsedTime())).build();
    }

    private NormalizedQueryField getNormalizedQueryFieldForResultNode(ObjectExecutionResultNode resultNode, NormalizedQueryFromAst normalizedQueryFromAst) {
        String id = resultNode.getFieldIds().get(0);
        List normalizedFields = (List)Assert.assertNotNull((Object)normalizedQueryFromAst.getNormalizedFieldsByFieldId(id));
        for (NormalizedQueryField normalizedField : normalizedFields) {
            if (resultNode.getObjectType() != normalizedField.getObjectType() || resultNode.getFieldDefinition() != normalizedField.getFieldDefinition()) continue;
            return normalizedField;
        }
        return (NormalizedQueryField)Assert.assertShouldNeverHappen((String)"Can't find normalized query field", (Object[])new Object[0]);
    }

    private boolean isArtificialHydrationNode(List<String> fieldIds, Set<String> transformationToFieldIds) {
        return fieldIds.stream().noneMatch(transformationToFieldIds::contains);
    }

    private boolean isFirstNode(ObjectExecutionResultNode node) {
        ResultPath path = node.getResultPath();
        return this.isFirstNode(path);
    }

    private boolean isFirstNode(ResultPath resultPath) {
        for (ResultPath segment = resultPath; segment != null; segment = segment.getParent()) {
            if (!segment.isListSegment() || segment.getSegmentIndex() == 0) continue;
            return false;
        }
        return true;
    }

    public static class HandleResult {
        ExecutionResultNode changedNode;
        List<ExecutionResultNode> siblings = Collections.emptyList();
        TraversalControl traversalControl = TraversalControl.CONTINUE;

        public HandleResult() {
        }

        public static HandleResult newHandleResultWithSiblings() {
            HandleResult handleResult = new HandleResult();
            handleResult.siblings = new ArrayList<ExecutionResultNode>();
            return handleResult;
        }

        public HandleResult(ExecutionResultNode changedNode, List<ExecutionResultNode> siblings, TraversalControl traversalControl) {
            this.changedNode = changedNode;
            this.siblings = siblings;
            this.traversalControl = traversalControl;
        }

        public static HandleResult simple(ExecutionResultNode executionResultNode) {
            return new HandleResult(executionResultNode, Collections.emptyList(), TraversalControl.CONTINUE);
        }
    }
}

