/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation;

import graphql.Internal;
import graphql.execution.ResultPath;
import graphql.language.Field;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.nadel.dsl.FieldMappingDefinition;
import graphql.nadel.engine.execution.FieldMetadataUtil;
import graphql.nadel.engine.execution.PathMapper;
import graphql.nadel.engine.execution.UnapplyEnvironment;
import graphql.nadel.engine.execution.transformation.ApplyEnvironment;
import graphql.nadel.engine.execution.transformation.ApplyResult;
import graphql.nadel.engine.execution.transformation.FieldTransformation;
import graphql.nadel.engine.execution.transformation.FieldUtils;
import graphql.nadel.engine.execution.transformation.UnapplyResult;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.ListExecutionResultNode;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.util.TraversalControl;
import graphql.util.TreeTransformerUtil;
import java.util.List;

@Internal
public class FieldRenameTransformation
extends FieldTransformation {
    PathMapper pathMapper = new PathMapper();
    private final FieldMappingDefinition mappingDefinition;

    public FieldRenameTransformation(FieldMappingDefinition mappingDefinition) {
        this.mappingDefinition = mappingDefinition;
    }

    public FieldMappingDefinition getDefinition() {
        return this.mappingDefinition;
    }

    @Override
    public ApplyResult apply(ApplyEnvironment environment) {
        this.setEnvironment(environment);
        List path = this.mappingDefinition.getInputPath();
        List<String> existingIds = FieldMetadataUtil.getTransformationIds(environment.getField(), environment.getMetadataByFieldId());
        Field changedNode = environment.getField().transform(builder -> builder.name((String)this.mappingDefinition.getInputPath().get(0)));
        FieldMetadataUtil.addFieldMetadata(changedNode, this.getTransformationId(), true, environment.getMetadataByFieldId());
        FieldUtils.addTransformationIdToChildren(environment.getField(), environment.getFragmentDefinitionMap(), this.getTransformationId(), environment.getMetadataByFieldId());
        SelectionSet selectionSetWithIds = changedNode.getSelectionSet();
        if (path.size() > 1) {
            Field firstChildField = FieldUtils.pathToFields(path.subList(1, path.size()), environment.getField(), this.getTransformationId(), existingIds, false, selectionSetWithIds, environment.getMetadataByFieldId());
            changedNode = changedNode.transform(builder -> builder.selectionSet(SelectionSet.newSelectionSet().selection((Selection)firstChildField).build()));
        } else {
            changedNode = changedNode.transform(builder -> builder.selectionSet(selectionSetWithIds));
        }
        TreeTransformerUtil.changeNode(environment.getTraverserContext(), (Object)changedNode);
        return new ApplyResult(TraversalControl.CONTINUE);
    }

    @Override
    public UnapplyResult unapplyResultNode(ExecutionResultNode executionResultNode, List<FieldTransformation> allTransformations, UnapplyEnvironment environment) {
        NormalizedQueryField matchingNormalizedOverallField = this.getMatchingNormalizedQueryFieldBasedOnParent(environment.correctParentNode);
        ExecutionResultNode resultNode = FieldUtils.getSubTree(executionResultNode, this.mappingDefinition.getInputPath().size() - 1);
        resultNode = this.mapToOverallFieldAndTypes(resultNode, allTransformations, matchingNormalizedOverallField);
        resultNode = this.replaceFieldsAndTypesInsideList(resultNode, allTransformations, matchingNormalizedOverallField);
        ResultPath mappedPath = environment.correctParentNode.getResultPath().segment(resultNode.getResultKey());
        resultNode = resultNode.transform(builder -> builder.resultPath(mappedPath));
        return new UnapplyResult(resultNode, TraversalControl.CONTINUE);
    }

    private ExecutionResultNode replaceFieldsAndTypesInsideList(ExecutionResultNode node, List<FieldTransformation> allTransformations, NormalizedQueryField normalizedQueryField) {
        if (node instanceof ListExecutionResultNode) {
            return FieldUtils.mapChildren(node, child -> {
                ExecutionResultNode newChild = this.mapToOverallFieldAndTypes((ExecutionResultNode)child, allTransformations, normalizedQueryField);
                return this.replaceFieldsAndTypesInsideList(newChild, allTransformations, normalizedQueryField);
            });
        }
        return node;
    }
}

