/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.ResultPath;
import graphql.language.AbstractNode;
import graphql.language.Field;
import graphql.language.Node;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.engine.execution.UnapplyEnvironment;
import graphql.nadel.engine.execution.transformation.ApplyEnvironment;
import graphql.nadel.engine.execution.transformation.ApplyResult;
import graphql.nadel.engine.execution.transformation.UnapplyResult;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.RootExecutionResultNode;
import graphql.nadel.normalized.NormalizedQueryField;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@Internal
public abstract class FieldTransformation {
    private ApplyEnvironment environment;
    private String transformationId = this.getClass().getSimpleName() + "-" + UUID.randomUUID().toString();

    public abstract ApplyResult apply(ApplyEnvironment var1);

    public abstract UnapplyResult unapplyResultNode(ExecutionResultNode var1, List<FieldTransformation> var2, UnapplyEnvironment var3);

    public abstract AbstractNode getDefinition();

    public String getTransformationId() {
        return this.transformationId;
    }

    public void setEnvironment(ApplyEnvironment environment) {
        this.environment = environment;
    }

    public ApplyEnvironment getApplyEnvironment() {
        return this.environment;
    }

    public Field getOriginalField() {
        return this.getApplyEnvironment().getField();
    }

    public GraphQLOutputType getOriginalFieldType() {
        return this.getApplyEnvironment().getFieldDefinitionOverall().getType();
    }

    public GraphQLFieldsContainer getOriginalFieldsContainer() {
        return this.getApplyEnvironment().getFieldsContainerOverall();
    }

    public GraphQLFieldDefinition getOriginalFieldDefinition() {
        return this.getApplyEnvironment().getFieldDefinitionOverall();
    }

    protected NormalizedQueryField getMatchingNormalizedQueryFieldBasedOnParent(ExecutionResultNode parent) {
        List<NormalizedQueryField> normalizedFields = this.getApplyEnvironment().getNormalizedQueryFieldsOverall();
        if (parent instanceof RootExecutionResultNode) {
            Assert.assertTrue((normalizedFields.size() == 1 ? 1 : 0) != 0, () -> "only one normalized field expected");
            return normalizedFields.get(0);
        }
        ResultPath path = parent.getResultPath();
        List<String> parentQueryPath = FieldTransformation.executionPathToQueryPath(path);
        for (NormalizedQueryField normalizedField : normalizedFields) {
            NormalizedQueryField parentNormalizedField = normalizedField.getParent();
            if (!parentQueryPath.equals(parentNormalizedField.getPath()) || parentNormalizedField.getObjectType() != parent.getObjectType() || parentNormalizedField.getFieldDefinition() != parent.getFieldDefinition() || !parentNormalizedField.getResultKey().equals(parent.getResultKey())) continue;
            return normalizedField;
        }
        return (NormalizedQueryField)Assert.assertShouldNeverHappen((String)"could not find matching normalized field for parent node %s ", (Object[])new Object[]{parent});
    }

    private static List<String> executionPathToQueryPath(ResultPath executionPath) {
        return executionPath.toList().stream().filter(o -> o instanceof String).map(String.class::cast).collect(Collectors.toList());
    }

    protected ExecutionResultNode replaceFieldIdsWithOriginalValue(List<FieldTransformation> allTransformations, ExecutionResultNode executionResultNode) {
        List<String> underlyingFieldIds = executionResultNode.getFieldIds();
        Assert.assertTrue((allTransformations.size() == underlyingFieldIds.size() ? 1 : 0) != 0);
        ArrayList<String> newFieldIds = new ArrayList<String>();
        for (FieldTransformation fieldTransformation : allTransformations) {
            newFieldIds.add(NodeId.getId((Node)fieldTransformation.getOriginalField()));
        }
        return executionResultNode.transform(builder -> builder.fieldIds(newFieldIds));
    }

    protected ExecutionResultNode mapToOverallFieldAndTypes(ExecutionResultNode node, List<FieldTransformation> allTransformations, NormalizedQueryField matchingNormalizedOverallField) {
        node = this.replaceFieldIdsWithOriginalValue(allTransformations, node);
        node = node.transform(builder -> ((ExecutionResultNode.BuilderBase)((ExecutionResultNode.BuilderBase)((ExecutionResultNode.BuilderBase)builder.alias(matchingNormalizedOverallField.getAlias())).objectType(matchingNormalizedOverallField.getObjectType())).fieldDefinition(matchingNormalizedOverallField.getFieldDefinition())).objectType(matchingNormalizedOverallField.getObjectType()));
        return node;
    }
}

