/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation;

import graphql.Assert;
import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectField;
import graphql.language.Value;
import graphql.nadel.dsl.NodeId;
import graphql.nadel.engine.execution.transformation.OverallTypeInfo;
import graphql.nadel.engine.execution.transformation.OverallTypeInformation;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputValueDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.LinkedHashMap;

@Internal
public class RecordOverallTypeInformation {
    public <T extends Node> OverallTypeInformation<T> recordOverallTypes(T node, final GraphQLSchema graphQLSchema, GraphQLOutputType rootOutputType) {
        final LinkedHashMap<String, OverallTypeInfo> overallTypeInfoMap = new LinkedHashMap<String, OverallTypeInfo>();
        NodeVisitorStub recordTypeInfos = new NodeVisitorStub(){

            public TraversalControl visitArgument(Argument argument, TraverserContext<Node> context) {
                GraphQLFieldDefinition fieldDefinition = (GraphQLFieldDefinition)context.getVarFromParents(GraphQLFieldDefinition.class);
                GraphQLArgument graphQLArgument = fieldDefinition.getArgument(argument.getName());
                context.setVar(GraphQLArgument.class, (Object)graphQLArgument);
                context.setVar(GraphQLInputValueDefinition.class, (Object)graphQLArgument);
                OverallTypeInfo overallTypeInfo = new OverallTypeInfo(null, fieldDefinition, graphQLArgument, null);
                overallTypeInfoMap.put(NodeId.getId((Node)argument), overallTypeInfo);
                return TraversalControl.CONTINUE;
            }

            public TraversalControl visitObjectField(ObjectField node, TraverserContext<Node> context) {
                GraphQLInputValueDefinition graphQLInputValueDefinition = (GraphQLInputValueDefinition)context.getVarFromParents(GraphQLInputValueDefinition.class);
                GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll((GraphQLType)graphQLInputValueDefinition.getType());
                if (unmodifiedType instanceof GraphQLInputObjectType) {
                    GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)unmodifiedType;
                    GraphQLInputObjectField inputObjectTypeField = inputObjectType.getField(node.getName());
                    context.setVar(GraphQLInputValueDefinition.class, (Object)inputObjectTypeField);
                }
                return TraversalControl.CONTINUE;
            }

            protected TraversalControl visitValue(Value<?> value, TraverserContext<Node> context) {
                GraphQLArgument graphQLArgument = (GraphQLArgument)context.getVarFromParents(GraphQLArgument.class);
                GraphQLInputValueDefinition graphQLInputValueDefinition = (GraphQLInputValueDefinition)context.getVarFromParents(GraphQLInputValueDefinition.class);
                OverallTypeInfo overallTypeInfo = new OverallTypeInfo(null, null, graphQLArgument, graphQLInputValueDefinition);
                overallTypeInfoMap.put(NodeId.getId(value), overallTypeInfo);
                return TraversalControl.CONTINUE;
            }

            public TraversalControl visitFragmentDefinition(FragmentDefinition fragmentDefinition, TraverserContext<Node> context) {
                GraphQLOutputType outputType = (GraphQLOutputType)Assert.assertNotNull((Object)graphQLSchema.getType(fragmentDefinition.getTypeCondition().getName()));
                context.setVar(GraphQLOutputType.class, (Object)outputType);
                return TraversalControl.CONTINUE;
            }

            public TraversalControl visitInlineFragment(InlineFragment inlineFragment, TraverserContext<Node> context) {
                if (inlineFragment.getTypeCondition() == null) {
                    return TraversalControl.CONTINUE;
                }
                GraphQLOutputType outputType = (GraphQLOutputType)Assert.assertNotNull((Object)graphQLSchema.getType(inlineFragment.getTypeCondition().getName()));
                context.setVar(GraphQLOutputType.class, (Object)outputType);
                return TraversalControl.CONTINUE;
            }

            public TraversalControl visitField(Field field, TraverserContext<Node> context) {
                if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
                    return TraversalControl.CONTINUE;
                }
                GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)GraphQLTypeUtil.unwrapAll((GraphQLType)((GraphQLType)context.getVarFromParents(GraphQLOutputType.class)));
                GraphQLFieldDefinition fieldDefinition = (GraphQLFieldDefinition)Assert.assertNotNull((Object)fieldsContainer.getFieldDefinition(field.getName()), () -> String.format("field %s not found for type %s", field.getName(), fieldsContainer.getName()));
                context.setVar(GraphQLFieldDefinition.class, (Object)fieldDefinition);
                GraphQLOutputType newOutputType = fieldDefinition.getType();
                context.setVar(GraphQLOutputType.class, (Object)newOutputType);
                OverallTypeInfo overallTypeInfo = new OverallTypeInfo(fieldsContainer, fieldDefinition, null, null);
                overallTypeInfoMap.put(NodeId.getId((Node)field), overallTypeInfo);
                return TraversalControl.CONTINUE;
            }
        };
        LinkedHashMap<Class<GraphQLOutputType>, GraphQLOutputType> rootVars = new LinkedHashMap<Class<GraphQLOutputType>, GraphQLOutputType>();
        if (rootOutputType != null) {
            rootVars.put(GraphQLOutputType.class, rootOutputType);
        }
        NodeTraverser nodeTraverser = new NodeTraverser(rootVars, Node::getChildren);
        nodeTraverser.depthFirst((NodeVisitor)recordTypeInfos, node);
        return new OverallTypeInformation(overallTypeInfoMap);
    }
}

