/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.execution.transformation.variables;

import graphql.Assert;
import graphql.PublicApi;
import graphql.nadel.engine.execution.transformation.variables.InputValueTransform;
import graphql.nadel.engine.execution.transformation.variables.InputValueTree;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInputValueDefinition;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

@PublicApi
public class InputValueTransformer {
    public static Object transform(GraphQLInputValueDefinition valueDefinition, Object coercedValue, InputValueTransform inputValueTransform) {
        String argumentName = valueDefinition.getName();
        GraphQLInputType inputType = valueDefinition.getType();
        InputValueTree inputValueTree = new InputValueTree(null, argumentName, inputType, valueDefinition);
        return InputValueTransformer.transformValue(coercedValue, argumentName, inputType, inputValueTree, inputValueTransform);
    }

    private static Object transformValue(Object coercedValue, String name, GraphQLInputType type, InputValueTree inputValueTree, InputValueTransform inputValueTransform) {
        if (coercedValue == null) {
            return inputValueTransform.transformValue(coercedValue, inputValueTree);
        }
        if (GraphQLTypeUtil.isNonNull((GraphQLType)type)) {
            return InputValueTransformer.transformValue(coercedValue, name, InputValueTransformer.unwrapOne(type), inputValueTree.unwrapOne(), inputValueTransform);
        }
        if (type instanceof GraphQLScalarType) {
            return inputValueTransform.transformValue(coercedValue, inputValueTree);
        }
        if (type instanceof GraphQLEnumType) {
            return inputValueTransform.transformValue(coercedValue, inputValueTree);
        }
        if (GraphQLTypeUtil.isList((GraphQLType)type)) {
            Assert.assertTrue((boolean)(coercedValue instanceof Iterable), () -> "The value MUST be an Iterable");
            Object newValue = InputValueTransformer.transformListValue((Iterable)coercedValue, name, InputValueTransformer.unwrapOne(type), inputValueTree.unwrapOne(), inputValueTransform);
            return inputValueTransform.transformValue(newValue, inputValueTree);
        }
        if (type instanceof GraphQLInputObjectType) {
            Assert.assertTrue((boolean)(coercedValue instanceof Map), () -> "The value MUST be an Map");
            Object newValue = InputValueTransformer.transformObjectValue((Map)coercedValue, (GraphQLInputObjectType)type, inputValueTree, inputValueTransform);
            return inputValueTransform.transformValue(newValue, inputValueTree);
        }
        return Assert.assertShouldNeverHappen((String)"Have we missed a type case?", (Object[])new Object[0]);
    }

    private static Object transformObjectValue(Map<String, Object> coercedMap, GraphQLInputObjectType inputObjectType, InputValueTree inputValueTree, InputValueTransform inputValueTransform) {
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
        for (GraphQLInputObjectField inputFieldDef : inputObjectType.getFieldDefinitions()) {
            String fieldName = inputFieldDef.getName();
            GraphQLInputType fieldType = inputFieldDef.getType();
            InputValueTree newInputValueTree = new InputValueTree(inputValueTree, fieldName, fieldType, (GraphQLInputValueDefinition)inputFieldDef);
            if (!coercedMap.containsKey(fieldName)) continue;
            Object coercedValue = coercedMap.get(fieldName);
            Object newValue = InputValueTransformer.transformValue(coercedValue, fieldName, fieldType, newInputValueTree, inputValueTransform);
            newMap.put(fieldName, newValue);
        }
        return newMap;
    }

    private static Object transformListValue(Iterable coercedIterable, String name, GraphQLInputType unwrappedListType, InputValueTree inputValueTree, InputValueTransform inputValueTransform) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Object value : coercedIterable) {
            Object newValue = InputValueTransformer.transformValue(value, name, unwrappedListType, inputValueTree.unwrapOne(), inputValueTransform);
            newList.add(newValue);
        }
        return newList;
    }

    static GraphQLInputType unwrapOne(GraphQLInputType type) {
        return (GraphQLInputType)GraphQLTypeUtil.unwrapOne((GraphQLType)type);
    }
}

