/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.result;

import graphql.Assert;
import graphql.Internal;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Internal
public class ResultNodeAdapter
implements NodeAdapter<ExecutionResultNode> {
    public static final ResultNodeAdapter RESULT_NODE_ADAPTER = new ResultNodeAdapter();

    private ResultNodeAdapter() {
    }

    public Map<String, List<ExecutionResultNode>> getNamedChildren(ExecutionResultNode parentNode) {
        return Collections.singletonMap(null, parentNode.getChildren());
    }

    public ExecutionResultNode withNewChildren(ExecutionResultNode parentNode, Map<String, List<ExecutionResultNode>> newChildren) {
        Assert.assertTrue((newChildren.size() == 1 ? 1 : 0) != 0);
        List<ExecutionResultNode> childrenList = newChildren.get(null);
        Assert.assertNotNull(childrenList);
        return parentNode.transform(t -> t.children(childrenList));
    }

    public ExecutionResultNode removeChild(ExecutionResultNode parentNode, NodeLocation location) {
        int index = location.getIndex();
        ArrayList<ExecutionResultNode> childrenList = new ArrayList<ExecutionResultNode>(parentNode.getChildren());
        Assert.assertTrue((index >= 0 && index < childrenList.size() ? 1 : 0) != 0, () -> "The remove index MUST be within the range of the children");
        childrenList.remove(index);
        return parentNode.transform(builder -> builder.children(childrenList));
    }
}

