/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.engine.result;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.ResultPath;
import graphql.nadel.engine.result.ExecutionResultNode;
import graphql.nadel.engine.result.LeafExecutionResultNode;
import graphql.nadel.engine.result.ListExecutionResultNode;
import graphql.nadel.engine.result.NonNullableFieldWasNullError;
import graphql.nadel.engine.result.ObjectExecutionResultNode;
import graphql.nadel.engine.result.ResultNodeAdapter;
import graphql.nadel.engine.result.ResultNodeTraverser;
import graphql.nadel.engine.result.RootExecutionResultNode;
import graphql.nadel.engine.result.UnresolvedObjectResultNode;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import graphql.util.NodeMultiZipper;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import graphql.util.TraverserVisitorStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class ResultNodesUtil {
    public static ExecutionResult toExecutionResult(RootExecutionResultNode root) {
        ExecutionResultData executionResultData = ResultNodesUtil.toDataImpl(root);
        if (executionResultData.nonNullableFieldWasNullError != null) {
            return ExecutionResultImpl.newExecutionResult().data(null).addError((GraphQLError)executionResultData.nonNullableFieldWasNullError).build();
        }
        LinkedHashMap<String, Object> bugMap = new LinkedHashMap<String, Object>(executionResultData.extensions);
        return ExecutionResultImpl.newExecutionResult().data(executionResultData.data).errors(executionResultData.errors).extensions(bugMap).build();
    }

    private static ExecutionResultData data(Object data, ExecutionResultNode executionResultNode) {
        ArrayList<GraphQLError> allErrors = new ArrayList<GraphQLError>(executionResultNode.getErrors());
        return new ExecutionResultData(data, allErrors);
    }

    private static ExecutionResultData data(Object data, List<GraphQLError> errors) {
        return new ExecutionResultData(data, errors);
    }

    private static ExecutionResultData data(Object data, List<GraphQLError> errors, Map<String, Object> extensions) {
        return new ExecutionResultData(data, errors, extensions);
    }

    private static ExecutionResultData data(NonNullableFieldWasNullError error) {
        return new ExecutionResultData(error);
    }

    private static ExecutionResultData toDataImpl(ExecutionResultNode root) {
        if (root instanceof UnresolvedObjectResultNode) {
            return ResultNodesUtil.data((Object)("Not resolved : " + root.getResultPath() + " with field " + root.getFieldName()), Collections.emptyList());
        }
        if (root instanceof LeafExecutionResultNode) {
            return root.getNonNullableFieldWasNullError() != null ? ResultNodesUtil.data(root.getNonNullableFieldWasNullError()) : ResultNodesUtil.data(root.getCompletedValue(), root);
        }
        if (root instanceof ListExecutionResultNode) {
            return ResultNodesUtil.toDataImplList(root);
        }
        if (root instanceof ObjectExecutionResultNode) {
            return ResultNodesUtil.toDataImplObject(root);
        }
        return (ExecutionResultData)Assert.assertShouldNeverHappen((String)"An unexpected node type %s", (Object[])new Object[]{root.getClass()});
    }

    private static ExecutionResultData toDataImplObject(ExecutionResultNode root) {
        boolean isNonNull = false;
        GraphQLOutputType actualType = null;
        if (root instanceof RootExecutionResultNode) {
            isNonNull = true;
        }
        if (root.getFieldDefinition() != null) {
            actualType = ResultNodesUtil.getActualType(root.getFieldDefinition(), root.getResultPath());
            isNonNull = GraphQLTypeUtil.isNonNull((GraphQLType)actualType);
        }
        Map<String, Object> extensions = root.getExtensions();
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        for (ExecutionResultNode child : root.getChildren()) {
            ExecutionResultData executionResultData = ResultNodesUtil.toDataImpl(child);
            if (isNonNull && (child.getNonNullableFieldWasNullError() != null || executionResultData.nonNullableFieldWasNullError != null)) {
                if (actualType != null) {
                    return ResultNodesUtil.data(new NonNullableFieldWasNullError((GraphQLNonNull)actualType, root.getResultPath()));
                }
                return ResultNodesUtil.data(new NonNullableFieldWasNullError((GraphQLNonNull)child.getFieldDefinition().getType(), root.getResultPath()));
            }
            if (executionResultData.nonNullableFieldWasNullError != null) {
                return ResultNodesUtil.data(null, Collections.singletonList(executionResultData.nonNullableFieldWasNullError), extensions);
            }
            resultMap.put(child.getResultKey(), executionResultData.data);
            errors.addAll(executionResultData.errors);
        }
        errors.addAll(root.getErrors());
        return ResultNodesUtil.data(resultMap, errors, extensions);
    }

    private static ExecutionResultData toDataImplList(ExecutionResultNode root) {
        boolean isNonNull = false;
        GraphQLOutputType actualType = null;
        if (root.getFieldDefinition() != null) {
            actualType = ResultNodesUtil.getActualType(root.getFieldDefinition(), root.getResultPath());
            isNonNull = GraphQLTypeUtil.isNonNull((GraphQLType)actualType);
        }
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        ArrayList<Object> data = new ArrayList<Object>();
        for (ExecutionResultNode child : root.getChildren()) {
            ExecutionResultData executionResultData = ResultNodesUtil.toDataImpl(child);
            if (isNonNull && (child.getNonNullableFieldWasNullError() != null || executionResultData.nonNullableFieldWasNullError != null)) {
                return ResultNodesUtil.data(new NonNullableFieldWasNullError((GraphQLNonNull)actualType, root.getResultPath()));
            }
            if (executionResultData.nonNullableFieldWasNullError != null) {
                return ResultNodesUtil.data(null, Collections.singletonList(executionResultData.nonNullableFieldWasNullError));
            }
            data.add(executionResultData.data);
            errors.addAll(executionResultData.errors);
        }
        errors.addAll(root.getErrors());
        return ResultNodesUtil.data(data, errors);
    }

    private static GraphQLOutputType getActualType(GraphQLFieldDefinition fieldDefinition, ResultPath resultPath) {
        GraphQLOutputType result = fieldDefinition.getType();
        ResultPath executionPath = resultPath;
        while (executionPath.isListSegment()) {
            executionPath = executionPath.dropSegment();
            GraphQLOutputType tempType = (GraphQLOutputType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)result);
            Assert.assertTrue((boolean)(tempType instanceof GraphQLList), () -> String.format("Expected an embedded list type but got type %s  - complete type is %s for path %s", GraphQLTypeUtil.simplePrint((GraphQLType)tempType), GraphQLTypeUtil.simplePrint((GraphQLType)fieldDefinition.getType()), resultPath));
            result = tempType;
            result = (GraphQLOutputType)((GraphQLList)result).getWrappedType();
        }
        return result;
    }

    public static List<NodeZipper<ExecutionResultNode>> getUnresolvedNodes(Collection<ExecutionResultNode> roots) {
        final ArrayList<NodeZipper<ExecutionResultNode>> result = new ArrayList<NodeZipper<ExecutionResultNode>>();
        ResultNodeTraverser traverser = ResultNodeTraverser.depthFirst();
        traverser.traverse((TraverserVisitor<ExecutionResultNode>)new TraverserVisitorStub<ExecutionResultNode>(){

            public TraversalControl enter(TraverserContext<ExecutionResultNode> context) {
                if (context.thisNode() instanceof UnresolvedObjectResultNode) {
                    result.add(new NodeZipper((Object)((ExecutionResultNode)context.thisNode()), context.getBreadcrumbs(), (NodeAdapter)ResultNodeAdapter.RESULT_NODE_ADAPTER));
                }
                return TraversalControl.CONTINUE;
            }
        }, roots);
        return result;
    }

    public static NodeMultiZipper<ExecutionResultNode> getUnresolvedNodes(ExecutionResultNode root) {
        List<NodeZipper<ExecutionResultNode>> unresolvedNodes = ResultNodesUtil.getUnresolvedNodes(Collections.singleton(root));
        return new NodeMultiZipper((Object)root, unresolvedNodes, (NodeAdapter)ResultNodeAdapter.RESULT_NODE_ADAPTER);
    }

    public static NodeLocation key(String name) {
        return new NodeLocation(name, 0);
    }

    public static NodeLocation index(int index) {
        return new NodeLocation(null, index);
    }

    private static class ExecutionResultData {
        Object data;
        List<GraphQLError> errors = Collections.emptyList();
        Map<String, Object> extensions = Collections.emptyMap();
        NonNullableFieldWasNullError nonNullableFieldWasNullError;

        public ExecutionResultData(Object data, List<GraphQLError> errors, Map<String, Object> extensions) {
            this.data = data;
            this.errors = errors;
            this.extensions = extensions;
        }

        public ExecutionResultData(Object data, List<GraphQLError> errors) {
            this.data = data;
            this.errors = errors;
        }

        public ExecutionResultData(NonNullableFieldWasNullError nonNullableFieldWasNullError) {
            this.data = null;
            this.nonNullableFieldWasNullError = nonNullableFieldWasNullError;
        }
    }
}

