/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.onetime.core;

import com.atlassian.onetime.core.HMACDigest;
import com.atlassian.onetime.core.HOTP;
import com.atlassian.onetime.core.HOTPGeneratorKt;
import com.atlassian.onetime.core.OTPLength;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/onetime/core/OTPGenerator;", "", "otpLength", "Lcom/atlassian/onetime/core/OTPLength;", "digest", "Lcom/atlassian/onetime/core/HMACDigest;", "(Lcom/atlassian/onetime/core/OTPLength;Lcom/atlassian/onetime/core/HMACDigest;)V", "getDigest", "()Lcom/atlassian/onetime/core/HMACDigest;", "modulusOperand", "", "getModulusOperand", "()I", "modulusOperand$delegate", "Lkotlin/Lazy;", "getOtpLength", "()Lcom/atlassian/onetime/core/OTPLength;", "generateOtp", "Lcom/atlassian/onetime/core/HOTP;", "key", "", "counter", "", "truncate", "hmac", "onetime"})
public abstract class OTPGenerator {
    @NotNull
    private final OTPLength otpLength;
    @NotNull
    private final HMACDigest digest;
    @NotNull
    private final Lazy modulusOperand$delegate;

    public OTPGenerator(@NotNull OTPLength otpLength, @NotNull HMACDigest digest) {
        Intrinsics.checkNotNullParameter((Object)((Object)otpLength), (String)"otpLength");
        Intrinsics.checkNotNullParameter((Object)((Object)digest), (String)"digest");
        this.otpLength = otpLength;
        this.digest = digest;
        this.modulusOperand$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ OTPGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return (int)Math.pow(10.0, this.this$0.getOtpLength().getValue());
            }
        }));
    }

    @NotNull
    public OTPLength getOtpLength() {
        return this.otpLength;
    }

    @NotNull
    public HMACDigest getDigest() {
        return this.digest;
    }

    private final int getModulusOperand() {
        Lazy lazy = this.modulusOperand$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    protected final HOTP generateOtp(@NotNull byte[] key, long counter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] hmacOut = HmacUtils.getInitializedMac((HmacAlgorithms)this.getDigest().getValue(), (byte[])key).doFinal(HOTPGeneratorKt.access$toByteArray(counter));
        Intrinsics.checkNotNullExpressionValue((Object)hmacOut, (String)"hmacOut");
        int intOtp = this.truncate(hmacOut) % this.getModulusOperand();
        String string = "%0" + this.getOtpLength().getValue() + "d";
        Object[] objectArray = new Object[]{intOtp};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return new HOTP(string2);
    }

    private final int truncate(byte[] hmac) {
        byte[] byArray;
        byte $this$truncate_u24lambda_u2d1 = (byte)(ArraysKt.last((byte[])hmac) & 0xF);
        boolean bl = false;
        byte[] $this$truncate_u24lambda_u2d1_u24lambda_u2d0 = byArray = CollectionsKt.toByteArray((Collection)ArraysKt.slice((byte[])hmac, (IntRange)new IntRange((int)$this$truncate_u24lambda_u2d1, $this$truncate_u24lambda_u2d1 + 3)));
        boolean bl2 = false;
        $this$truncate_u24lambda_u2d1_u24lambda_u2d0[0] = (byte)($this$truncate_u24lambda_u2d1_u24lambda_u2d0[0] & 0x7F);
        return ByteBuffer.wrap(byArray).getInt();
    }
}

