/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.onetime.core;

import com.atlassian.onetime.core.HMACDigest;
import com.atlassian.onetime.core.HOTP;
import com.atlassian.onetime.core.OTPGenerator;
import com.atlassian.onetime.core.OTPLength;
import com.atlassian.onetime.core.TOTP;
import com.atlassian.onetime.model.TOTPSecret;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/onetime/core/TOTPGenerator;", "Lcom/atlassian/onetime/core/OTPGenerator;", "clock", "Ljava/time/Clock;", "startTime", "", "timeStepSeconds", "otpLength", "Lcom/atlassian/onetime/core/OTPLength;", "digest", "Lcom/atlassian/onetime/core/HMACDigest;", "(Ljava/time/Clock;IILcom/atlassian/onetime/core/OTPLength;Lcom/atlassian/onetime/core/HMACDigest;)V", "getDigest", "()Lcom/atlassian/onetime/core/HMACDigest;", "getOtpLength", "()Lcom/atlassian/onetime/core/OTPLength;", "getStartTime", "()I", "getTimeStepSeconds", "generate", "", "Lcom/atlassian/onetime/core/TOTP;", "totpSecret", "Lcom/atlassian/onetime/model/TOTPSecret;", "delaySteps", "futureSteps", "generateCurrent", "onetime"})
public final class TOTPGenerator
extends OTPGenerator {
    @NotNull
    private final Clock clock;
    private final int startTime;
    private final int timeStepSeconds;
    @NotNull
    private final OTPLength otpLength;
    @NotNull
    private final HMACDigest digest;

    public TOTPGenerator(@NotNull Clock clock, int startTime, int timeStepSeconds, @NotNull OTPLength otpLength, @NotNull HMACDigest digest) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)((Object)otpLength), (String)"otpLength");
        Intrinsics.checkNotNullParameter((Object)((Object)digest), (String)"digest");
        super(otpLength, digest);
        this.clock = clock;
        this.startTime = startTime;
        this.timeStepSeconds = timeStepSeconds;
        this.otpLength = otpLength;
        this.digest = digest;
    }

    public /* synthetic */ TOTPGenerator(Clock clock, int n, int n2, OTPLength oTPLength, HMACDigest hMACDigest, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 30;
        }
        if ((n3 & 8) != 0) {
            oTPLength = OTPLength.SIX;
        }
        if ((n3 & 0x10) != 0) {
            hMACDigest = HMACDigest.SHA1;
        }
        this(clock, n, n2, oTPLength, hMACDigest);
    }

    public final int getStartTime() {
        return this.startTime;
    }

    public final int getTimeStepSeconds() {
        return this.timeStepSeconds;
    }

    @Override
    @NotNull
    public OTPLength getOtpLength() {
        return this.otpLength;
    }

    @Override
    @NotNull
    public HMACDigest getDigest() {
        return this.digest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TOTP> generate(@NotNull TOTPSecret totpSecret, int delaySteps, int futureSteps) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)totpSecret, (String)"totpSecret");
        long step = (this.clock.millis() / (long)1000 - (long)this.startTime) / (long)this.timeStepSeconds;
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)RangesKt.until((long)(step - (long)delaySteps), (long)step)), (Object)step), (Iterable)((Iterable)new LongRange(step + 1L, step + (long)futureSteps)));
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.generateOtp(totpSecret.getValue(), (long)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void hotp;
            HOTP it = (HOTP)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TOTP(hotp.getValue()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List generate$default(TOTPGenerator tOTPGenerator, TOTPSecret tOTPSecret, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return tOTPGenerator.generate(tOTPSecret, n, n2);
    }

    @NotNull
    public final TOTP generateCurrent(@NotNull TOTPSecret totpSecret) {
        Intrinsics.checkNotNullParameter((Object)totpSecret, (String)"totpSecret");
        return this.generate(totpSecret, 0, 0).get(0);
    }

    public TOTPGenerator() {
        this(null, 0, 0, null, null, 31, null);
    }
}

