/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.onetime.service;

import com.atlassian.onetime.core.TOTP;
import com.atlassian.onetime.core.TOTPGenerator;
import com.atlassian.onetime.model.EmailAddress;
import com.atlassian.onetime.model.Issuer;
import com.atlassian.onetime.model.TOTPSecret;
import com.atlassian.onetime.service.TOTPConfiguration;
import com.atlassian.onetime.service.TOTPService;
import com.atlassian.onetime.service.TOTPVerificationResult;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/onetime/service/DefaultTOTPService;", "Lcom/atlassian/onetime/service/TOTPService;", "totpGenerator", "Lcom/atlassian/onetime/core/TOTPGenerator;", "totpConfiguration", "Lcom/atlassian/onetime/service/TOTPConfiguration;", "(Lcom/atlassian/onetime/core/TOTPGenerator;Lcom/atlassian/onetime/service/TOTPConfiguration;)V", "generateTOTPUrl", "Ljava/net/URI;", "totpSecret", "Lcom/atlassian/onetime/model/TOTPSecret;", "emailAddress", "Lcom/atlassian/onetime/model/EmailAddress;", "issuer", "Lcom/atlassian/onetime/model/Issuer;", "(Lcom/atlassian/onetime/model/TOTPSecret;Lcom/atlassian/onetime/model/EmailAddress;Lcom/atlassian/onetime/model/Issuer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateTotpSecret", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verify", "Lcom/atlassian/onetime/service/TOTPVerificationResult;", "code", "Lcom/atlassian/onetime/core/TOTP;", "(Lcom/atlassian/onetime/core/TOTP;Lcom/atlassian/onetime/model/TOTPSecret;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onetime"})
public final class DefaultTOTPService
implements TOTPService {
    @NotNull
    private final TOTPGenerator totpGenerator;
    @NotNull
    private final TOTPConfiguration totpConfiguration;

    public DefaultTOTPService(@NotNull TOTPGenerator totpGenerator, @NotNull TOTPConfiguration totpConfiguration) {
        Intrinsics.checkNotNullParameter((Object)totpGenerator, (String)"totpGenerator");
        Intrinsics.checkNotNullParameter((Object)totpConfiguration, (String)"totpConfiguration");
        this.totpGenerator = totpGenerator;
        this.totpConfiguration = totpConfiguration;
    }

    public /* synthetic */ DefaultTOTPService(TOTPGenerator tOTPGenerator, TOTPConfiguration tOTPConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tOTPGenerator = new TOTPGenerator(null, 0, 0, null, null, 31, null);
        }
        if ((n & 2) != 0) {
            tOTPConfiguration = new TOTPConfiguration(null, 0, 0, 7, null);
        }
        this(tOTPGenerator, tOTPConfiguration);
    }

    @Override
    @Nullable
    public Object generateTotpSecret(@NotNull Continuation<? super TOTPSecret> $completion) {
        return this.totpConfiguration.getSecretProvider().generateSecret($completion);
    }

    @Override
    @Nullable
    public Object generateTOTPUrl(@NotNull TOTPSecret totpSecret, @NotNull EmailAddress emailAddress, @NotNull Issuer issuer, @NotNull Continuation<? super URI> $completion) {
        String string = URLEncoder.encode(emailAddress.getValue(), StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(emailAddress.value, StandardCharsets.UTF_8)");
        String encodedEmailAddress = string;
        String string2 = URLEncoder.encode(issuer.getValue(), StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(issuer.value, StandardCharsets.UTF_8)");
        String encodedIssuer = string2;
        String template = "otpauth://totp/" + encodedIssuer + ":" + encodedEmailAddress + "?secret=" + totpSecret.getBase32Encoded() + "&issuer=" + encodedIssuer + "&algorithm=" + this.totpGenerator.getDigest().toQueryParam() + "&digits=" + this.totpGenerator.getOtpLength().getValue() + "&period=" + this.totpGenerator.getTimeStepSeconds();
        return new URI(template);
    }

    @Override
    @Nullable
    public Object verify(@NotNull TOTP code, @NotNull TOTPSecret totpSecret, @NotNull Continuation<? super TOTPVerificationResult> $completion) {
        int index = this.totpGenerator.generate(totpSecret, this.totpConfiguration.getAllowedPastSteps(), this.totpConfiguration.getAllowedFutureSteps()).indexOf(code);
        return index == -1 ? (TOTPVerificationResult)TOTPVerificationResult.InvalidTotp.INSTANCE : (TOTPVerificationResult)new TOTPVerificationResult.Success(index - this.totpConfiguration.getAllowedPastSteps());
    }

    public DefaultTOTPService() {
        this(null, null, 3, null);
    }
}

