/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.aaf.cert;

import aaf.v2_0.Certs;
import aaf.v2_0.Users;
import com.att.cadi.Access;
import com.att.cadi.Hash;
import com.att.cadi.aaf.v2_0.AAFCon;
import com.att.cadi.client.Future;
import com.att.cadi.principal.X509Principal;
import com.att.cadi.taf.cert.CertIdentity;
import com.att.cadi.taf.cert.X509Taf;
import com.att.inno.env.APIException;
import com.att.inno.env.util.Chrono;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.XMLGregorianCalendar;

public class AAFListedCertIdentity
implements CertIdentity {
    private static final long EIGHT_HOURS = 28800000L;
    private static Map<ByteArrayHolder, String> certs = null;
    private static final String[] authMechanisms = new String[]{"tguard", "basicAuth", "csp"};
    private static String[] certIDs;
    private static Map<String, Set<String>> trusted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AAFListedCertIdentity(Access access, AAFCon aafcon) throws APIException {
        Class<AAFListedCertIdentity> clazz = AAFListedCertIdentity.class;
        synchronized (AAFListedCertIdentity.class) {
            if (certIDs == null) {
                String cip = access.getProperty("aaf_cert_ids", "");
                certIDs = cip.split("\\s*,\\s*");
            }
            if (certs == null) {
                CertUpdate cu = new CertUpdate(aafcon);
                ((TimerTask)cu).run();
                new Timer("AAF Identity Refresh Timer", true).scheduleAtFixedRate((TimerTask)cu, 28800000L, 28800000L);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static Set<String> trusted(String authMech) {
        return trusted.get(authMech);
    }

    public Principal identity(HttpServletRequest req, X509Certificate cert, byte[] certBytes) throws CertificateException {
        byte[] fingerprint;
        String id;
        if (cert == null && certBytes == null) {
            return null;
        }
        if (certBytes == null) {
            certBytes = cert.getEncoded();
        }
        if ((id = certs.get(new ByteArrayHolder(fingerprint = X509Taf.getFingerPrint((byte[])certBytes)))) != null) {
            return new X509Principal(id, cert, certBytes);
        }
        return null;
    }

    static {
        trusted = null;
    }

    private class CertUpdate
    extends TimerTask {
        private AAFCon aafcon;

        public CertUpdate(AAFCon con) {
            this.aafcon = con;
        }

        @Override
        public void run() {
            try {
                TreeMap<ByteArrayHolder, String> newCertsMap = new TreeMap<ByteArrayHolder, String>();
                TreeMap newTrustMap = new TreeMap();
                HashSet<String> userLookup = new HashSet<String>();
                for (String s : certIDs) {
                    userLookup.add(s);
                }
                for (String authMech : authMechanisms) {
                    Future<Users> fusr = this.aafcon.client.read("/authz/users/perm/com.att.aaf.trust/" + authMech + "/authenticate", Users.class, this.aafcon.usersDF);
                    if (fusr.get(5000)) {
                        List<Users.User> users = ((Users)fusr.value).getUser();
                        if (users.isEmpty()) {
                            this.aafcon.access.log(Access.Level.WARN, new Object[]{"AAF Lookup-No IDs in Role com.att.aaf.trustForID <> " + authMech});
                            continue;
                        }
                        this.aafcon.access.log(Access.Level.INFO, new Object[]{"Loading Trust Authentication Info for", authMech});
                        HashSet<String> hsUser = new HashSet<String>();
                        for (Users.User u : users) {
                            userLookup.add(u.getId());
                            hsUser.add(u.getId());
                        }
                        newTrustMap.put(authMech, hsUser);
                        continue;
                    }
                    this.aafcon.access.log(Access.Level.WARN, new Object[]{"Could not get Users in Perm com.att.trust|tguard|authenticate", fusr.code(), fusr.body()});
                }
                for (String u : userLookup) {
                    Future<Certs> fc = this.aafcon.client.read("/authn/cert/id/" + u, Certs.class, this.aafcon.certsDF);
                    XMLGregorianCalendar now = Chrono.timeStamp();
                    if (fc.get(5000)) {
                        List<Certs.Cert> certs = ((Certs)fc.value).getCert();
                        if (certs.isEmpty()) {
                            this.aafcon.access.log(Access.Level.WARN, new Object[]{"No Cert Associations for", u});
                            continue;
                        }
                        for (Certs.Cert c : ((Certs)fc.value).getCert()) {
                            XMLGregorianCalendar then = c.getExpires();
                            if (then == null || then.compare(now) <= 0) continue;
                            newCertsMap.put(new ByteArrayHolder(c.getFingerprint()), c.getId());
                            this.aafcon.access.log(Access.Level.INIT, new Object[]{"Associating " + c.getId() + " expiring " + Chrono.dateOnlyStamp(c.getExpires()) + " with " + c.getX500()});
                        }
                        continue;
                    }
                    this.aafcon.access.log(Access.Level.WARN, new Object[]{"Could not get Certificates for", u});
                }
                certs = newCertsMap;
                trusted = newTrustMap;
            }
            catch (Exception e) {
                this.aafcon.access.log(e, new Object[]{"Failure to update Certificate Identities from AAF"});
            }
        }
    }

    private static class ByteArrayHolder
    implements Comparable<ByteArrayHolder> {
        private byte[] ba;

        public ByteArrayHolder(byte[] ba) {
            this.ba = ba;
        }

        @Override
        public int compareTo(ByteArrayHolder b) {
            return Hash.compareTo((byte[])this.ba, (byte[])b.ba);
        }
    }
}

