/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.aaf.v2_0;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.cadi.AbsUserCache;
import com.att.cadi.CachedPrincipal;
import com.att.cadi.GetCred;
import com.att.cadi.Hash;
import com.att.cadi.SecuritySetter;
import com.att.cadi.User;
import com.att.cadi.aaf.v2_0.AAFCon;
import com.att.cadi.aaf.v2_0.DMEPrincipalSS;
import com.att.cadi.client.Future;
import com.att.cadi.client.Rcli;
import com.att.cadi.config.Config;
import com.att.cadi.dme2.DRcli;
import com.att.cadi.lur.ConfigPrincipal;
import com.att.cadi.lur.aaf.AAFPermission;
import com.att.inno.env.APIException;
import java.security.Principal;

public class AAFAuthn
extends AbsUserCache<AAFPermission> {
    public static final SecuritySetter<DME2Client> NULL_SECURITY_SETTER = new SecuritySetter<DME2Client>(){

        public void setSecurity(DME2Client client) {
        }
    };
    private DRcli client;
    private int timeout;
    private String realm;
    private long timeToLive;

    public AAFAuthn(AAFCon con) throws Exception {
        block2: {
            super(con.access, (long)con.cleanInterval, con.highCount, con.usageRefreshTriggerCount);
            this.client = con.client;
            this.timeout = con.timeout;
            this.timeToLive = con.cleanInterval;
            try {
                this.setRealm();
            }
            catch (APIException e) {
                if (!(e.getCause() instanceof DME2Exception)) break block2;
                this.realm = con.access.getProperty("aaf_default_realm", Config.getDefaultRealm());
            }
        }
    }

    public AAFAuthn(AAFCon con, AbsUserCache<AAFPermission> cache) throws Exception {
        block2: {
            super(cache);
            this.client = con.client;
            this.timeout = con.timeout;
            this.timeToLive = con.cleanInterval;
            try {
                this.setRealm();
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof DME2Exception)) break block2;
                this.realm = con.access.getProperty("aaf_default_realm", Config.getDefaultRealm());
            }
        }
    }

    private void setRealm() throws Exception {
        Future<String> fp = this.client.forUser(NULL_SECURITY_SETTER).read("/authn/basicAuth", "text/plain", new String[0]);
        if (fp.get(this.timeout)) {
            throw new Exception("Do not preset Basic Auth Information for AAFAuthn");
        }
        if (fp.code() == 401) {
            this.realm = fp.header("WWW-Authenticate");
            this.realm = this.realm != null && this.realm.startsWith("Basic realm=\"") ? this.realm.substring(13, this.realm.length() - 1) : "unknown.com";
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public String validate(String user, String password) throws Exception {
        User usr = this.getUser(user);
        byte[] bytes = password.getBytes();
        if (usr != null && usr.principal != null && usr.principal.getName().equals(user) && usr.principal instanceof GetCred) {
            if (Hash.isEqual((byte[])((GetCred)usr.principal).getCred(), (byte[])bytes)) {
                return null;
            }
            this.remove(usr);
        }
        AAFCachedPrincipal cp = new AAFCachedPrincipal(this, user, bytes, this.timeToLive);
        switch (cp.revalidate()) {
            case REVALIDATED: {
                if (usr != null) {
                    usr.principal = cp;
                } else {
                    this.addUser(new User((Principal)((Object)cp), (long)this.timeout));
                }
                return null;
            }
            case INACCESSIBLE: {
                return "AAF Inaccessible";
            }
            case UNVALIDATED: {
                return "User/Pass combo invalid";
            }
        }
        return "AAFAuthn doesn't handle this Principal";
    }

    private class AAFCachedPrincipal
    extends ConfigPrincipal
    implements CachedPrincipal {
        private AAFAuthn aaf;
        private long expires;
        private long timeToLive;

        public AAFCachedPrincipal(AAFAuthn aaf, String name, byte[] pass, long timeToLive) {
            super(name, pass);
            this.aaf = aaf;
            this.timeToLive = timeToLive;
            this.expires = timeToLive + System.currentTimeMillis();
        }

        public CachedPrincipal.Resp revalidate() {
            try {
                AbsUserCache.Miss missed = AAFAuthn.this.missed(this.getName());
                if (missed == null || missed.mayContinue(this.getCred())) {
                    Rcli<DME2Client> client = this.aaf.client.forUser(new DMEPrincipalSS((Principal)((Object)this)));
                    Future<String> fp = client.read("/authn/basicAuth", "text/plain", new String[0]);
                    if (fp.get(this.aaf.timeout)) {
                        this.expires = System.currentTimeMillis() + this.timeToLive;
                        AAFAuthn.this.addUser(new User((Principal)((Object)this), this.expires));
                        return CachedPrincipal.Resp.REVALIDATED;
                    }
                    AAFAuthn.this.addMiss(this.getName(), this.getCred());
                    return CachedPrincipal.Resp.UNVALIDATED;
                }
                return CachedPrincipal.Resp.UNVALIDATED;
            }
            catch (Exception e) {
                this.aaf.access.log(e, new Object[0]);
                return CachedPrincipal.Resp.INACCESSIBLE;
            }
        }

        public long expires() {
            return this.expires;
        }
    }
}

