/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.aaf.v2_0;

import aaf.v2_0.Certs;
import aaf.v2_0.Perms;
import aaf.v2_0.Users;
import com.att.aaf.marshal.CertsMarshal;
import com.att.aft.dme2.api.DME2Client;
import com.att.cadi.Access;
import com.att.cadi.SecuritySetter;
import com.att.cadi.aaf.v2_0.UserPass;
import com.att.cadi.dme2.DRcli;
import com.att.inno.env.APIException;
import com.att.rosetta.env.RosettaDF;
import com.att.rosetta.env.RosettaEnv;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class AAFCon {
    public final Access access;
    public final int timeout;
    public final int cleanInterval;
    public final int highCount;
    public final int userExpires;
    public final int usageRefreshTriggerCount;
    public final DRcli client;
    public final RosettaDF<Perms> permsDF;
    public final RosettaDF<Certs> certsDF;
    public final RosettaDF<Users> usersDF;
    private String realm;

    public AAFCon(Access access) throws APIException, URISyntaxException {
        this.access = access;
        this.timeout = Integer.parseInt(access.getProperty("aaf_timeout", "5000"));
        this.cleanInterval = Integer.parseInt(access.getProperty("aaf_clean_interval", "30000"));
        this.highCount = Integer.parseInt(access.getProperty("aaf_high_count", "1000").trim());
        int dmeTimeout = Integer.parseInt(access.getProperty("aaf_conn_timeout", "3000").trim());
        this.userExpires = Integer.parseInt(access.getProperty("aaf_user_expires", "600000").trim());
        this.usageRefreshTriggerCount = Integer.parseInt(access.getProperty("aaf_user_expires", "600000").trim()) - 1;
        String aafurl = access.getProperty("aaf_url", null);
        if (aafurl == null) {
            throw new APIException("aaf_url property is required.");
        }
        String user = access.getProperty("aaf_id", null);
        UserPass ss = DRcli.NULL_SS;
        if (user == null) {
            access.log(Access.Level.INIT, new Object[]{"aaf_id", "is not set"});
        } else {
            String password = access.getProperty("aaf_password", null);
            if (password == null) {
                access.log(Access.Level.INIT, new Object[]{"aaf_password", "is not set"});
            } else {
                try {
                    password = access.decrypt(password, true);
                    ss = new UserPass(user, password);
                }
                catch (IOException e) {
                    throw new APIException("Error decrypting aaf_password", e);
                }
            }
        }
        this.client = new DRcli(new URI(aafurl), ss);
        this.client.apiVersion("2.0").readTimeout(dmeTimeout);
        this.realm = "aaf.att.com";
        RosettaEnv env = new RosettaEnv();
        this.permsDF = env.newDataFactory(new Class[]{Perms.class});
        this.usersDF = env.newDataFactory(new Class[]{Users.class});
        this.certsDF = env.newDataFactory(new Class[]{Certs.class});
        this.certsDF.rootMarshal(new CertsMarshal());
    }

    public String getRealm() {
        return this.realm;
    }

    public void basicAuth(String user, String pass) throws IOException {
        this.client.setSecuritySetter(new UserPass(user, pass));
    }

    public void set(SecuritySetter<DME2Client> ss) {
        this.client.setSecuritySetter(ss);
    }
}

