/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.client;

import com.att.aft.dme2.api.DME2Manager;
import com.att.cadi.Access;
import com.att.cadi.client.Delete;
import com.att.cadi.client.EnvAccess;
import com.att.cadi.client.Get;
import com.att.cadi.client.Post;
import com.att.cadi.client.Put;
import com.att.cadi.config.SecurityInfo;
import com.att.cadi.dme2.DME2Locator;
import com.att.cadi.http.BasicAuthSS;
import com.att.cadi.http.HMangr;
import com.att.inno.env.APIException;
import com.att.inno.env.DataFactory;
import com.att.rosetta.env.RosettaDF;
import com.att.rosetta.env.RosettaEnv;
import java.util.HashMap;
import java.util.Map;

public class AAFClient {
    private RosettaEnv env;
    private Map<Class<?>, RosettaDF<?>> map = new HashMap();
    HMangr hman;
    BasicAuthSS ss;

    public AAFClient(RosettaEnv env) throws Exception {
        this.env = env;
        EnvAccess access = new EnvAccess(env);
        String user = access.getProperty("aaf_id", null);
        String password = access.decrypt(access.getProperty("aaf_password", null), true);
        SecurityInfo si = new SecurityInfo((Access)access);
        DME2Manager dm = new DME2Manager("APIclient DME2Manager", System.getProperties());
        DME2Locator loc = new DME2Locator(access, dm, access.getProperty("aaf_url", null));
        int TIMEOUT = Integer.parseInt(access.getProperty("aaf_conn_timeout", "30000"));
        this.hman = new HMangr(access, loc).readTimeout(TIMEOUT).apiVersion("2.0");
        this.ss = new BasicAuthSS(user, password, si);
    }

    public AAFClient(RosettaEnv env, DME2Manager dm) throws Exception {
        this.env = env;
        EnvAccess access = new EnvAccess(env);
        String user = access.getProperty("aaf_id", null);
        String password = access.decrypt(access.getProperty("aaf_password", null), true);
        SecurityInfo si = new SecurityInfo((Access)access);
        DME2Locator loc = new DME2Locator(access, dm, access.getProperty("aaf_url", null));
        int TIMEOUT = Integer.parseInt(access.getProperty("aaf_conn_timeout", "30000"));
        this.hman = new HMangr(access, loc).readTimeout(TIMEOUT).apiVersion("2.0");
        this.ss = new BasicAuthSS(user, password, si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <T> RosettaDF<T> getDF(Class<T> cls) throws APIException {
        DataFactory<Object> rdf;
        RosettaEnv rosettaEnv = this.env;
        synchronized (rosettaEnv) {
            rdf = this.map.get(cls);
            if (rdf == null) {
                rdf = this.env.newDataFactory(new Class[]{cls});
                this.map.put(cls, (RosettaDF<?>)rdf);
            }
        }
        return rdf;
    }

    public <T> Get<T> read(Class<T> cls) throws APIException {
        return new Get<T>(this, this.getDF(cls));
    }

    public <T> Get<T> get(Class<T> cls) throws APIException {
        return new Get<T>(this, this.getDF(cls));
    }

    public <T> Post<T> post(Class<T> cls) throws APIException {
        return new Post<T>(this, this.getDF(cls));
    }

    public <T> Post<T> create(Class<T> cls) throws APIException {
        return new Post<T>(this, this.getDF(cls));
    }

    public <T> Put<T> put(Class<T> cls) throws APIException {
        return new Put<T>(this, this.getDF(cls));
    }

    public <T> Put<T> update(Class<T> cls) throws APIException {
        return new Put<T>(this, this.getDF(cls));
    }

    public <T> Delete<T> delete(Class<T> cls) throws APIException {
        return new Delete<T>(this, this.getDF(cls));
    }

    public Delete<Void> delete() throws APIException {
        return new Delete<Void>(this, null);
    }

    public Put<Void> put() {
        return new Put<Void>(this, null);
    }

    static class Call<T> {
        protected static final String VOID_CONTENT_TYPE = "application/Void+json;version=2.0";
        protected RosettaDF<T> df;
        protected AAFClient client;

        public Call(AAFClient ac, RosettaDF<T> df) {
            this.client = ac;
            this.df = df;
        }
    }
}

