/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.client;

import com.att.cadi.Access;
import com.att.cadi.Symm;
import com.att.inno.env.Decryptor;
import com.att.inno.env.Env;
import com.att.rosetta.env.RosettaEnv;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class EnvAccess
implements Access {
    private Env env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvAccess(RosettaEnv env) {
        this.env = env;
        String cpf = env.getProperty("cadi_prop_files");
        if (cpf != null) {
            InputStream is = this.classLoader().getResourceAsStream(cpf);
            if (is == null) {
                try {
                    is = new FileInputStream(cpf);
                }
                catch (FileNotFoundException e) {
                    env.error().log("Cannot find", cpf, "in Classpath or Filepath");
                }
            }
            if (is != null) {
                try {
                    try {
                        this.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    env.error().log(e, new Object[0]);
                }
            }
        }
        if (env.getProperty("cadi_keyfile") != null) {
            final Symm s = Symm.obtain((Access)this);
            env.set(new Decryptor(){
                private Symm symm;
                {
                    this.symm = s;
                }

                @Override
                public String decrypt(String encrypted) {
                    try {
                        return encrypted != null ? this.symm.depass(encrypted) : encrypted;
                    }
                    catch (IOException e) {
                        return "";
                    }
                }
            });
        }
        env.loadToSystemPropsStartsWith("AFT_", "DME2");
    }

    public void log(Access.Level level, Object ... elements) {
        switch (level) {
            case AUDIT: {
                this.env.audit().log(elements);
                break;
            }
            case DEBUG: {
                this.env.debug().log(elements);
                break;
            }
            case ERROR: {
                this.env.error().log(elements);
                break;
            }
            case INFO: {
                this.env.info().log(elements);
                break;
            }
            case INIT: {
                this.env.init().log(elements);
                break;
            }
            case WARN: {
                this.env.warn().log(elements);
                break;
            }
        }
    }

    public void log(Exception e, Object ... elements) {
        this.env.error().log(e, elements);
    }

    public void setLogLevel(Access.Level level) {
    }

    public ClassLoader classLoader() {
        return this.env.getClass().getClassLoader();
    }

    public String getProperty(String string, String def) {
        return this.env.getProperty(string, def);
    }

    public void load(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        for (Map.Entry<Object, Object> es : props.entrySet()) {
            this.env.setProperty(es.getKey().toString(), es.getValue().toString());
        }
    }

    public String decrypt(String encrypted, boolean anytext) throws IOException {
        return this.env.decryptor().decrypt(encrypted);
    }
}

