/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.client;

import com.att.cadi.Locator;
import com.att.cadi.LocatorException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;

public class PropertyLocator
implements Locator {
    private final URI[] orig;
    private PLItem[] current;
    private int end;
    private final Random random;

    public PropertyLocator(String locList) throws LocatorException {
        if (locList == null) {
            throw new LocatorException("No Location List given for PropertyLocator");
        }
        String[] locarray = locList.split("\\s*,\\s*");
        this.orig = new URI[locarray.length];
        this.random = new Random();
        for (int i = 0; i < locarray.length; ++i) {
            try {
                this.orig[i] = new URI(locarray[i]);
                continue;
            }
            catch (URISyntaxException e) {
                throw new LocatorException((Throwable)e);
            }
        }
        this.current = new PLItem[this.orig.length];
        this.refresh();
    }

    public URI get(Locator.Item item) throws URISyntaxException, LocatorException {
        return this.orig[((PLItem)item).idx];
    }

    public Locator.Item first() throws LocatorException {
        return this.end > 0 ? this.current[0] : null;
    }

    public boolean hasItems() {
        return this.end > 0;
    }

    public Locator.Item next(Locator.Item item) throws LocatorException {
        int spot = ((PLItem)item).order + 1;
        if (spot >= this.end) {
            return null;
        }
        return this.current[spot];
    }

    public synchronized void invalidate(Locator.Item item) throws URISyntaxException, LocatorException {
        int i;
        if (--this.end <= 0) {
            return;
        }
        PLItem pli = (PLItem)item;
        for (i = 0; i < this.end && pli != this.current[i]; ++i) {
        }
        int order = this.current[i].order;
        while (i < this.end) {
            this.current[i] = this.current[i + 1];
            this.current[i].order = order++;
            ++i;
        }
        this.current[this.end] = pli;
    }

    public Locator.Item best() throws LocatorException {
        switch (this.current.length) {
            case 0: {
                return null;
            }
            case 1: {
                return this.current[0];
            }
        }
        return this.current[Math.abs(this.random.nextInt()) % this.end];
    }

    public synchronized boolean refresh() {
        this.end = this.orig.length;
        for (int i = 0; i < this.end; ++i) {
            if (this.current[i] == null) {
                this.current[i] = new PLItem(i);
                continue;
            }
            this.current[i].idx = this.current[i].order = i;
        }
        return true;
    }

    private class PLItem
    implements Locator.Item {
        public int idx;
        public int order;

        public PLItem(int i) {
            this.idx = this.order = i;
        }

        public String toString() {
            return "Item: " + this.idx + " order: " + this.order;
        }
    }
}

