/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.client;

import com.att.aft.dme2.api.DME2Client;
import com.att.cadi.Symm;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;

public abstract class RawClient {
    protected static String aafid;
    protected static String aafpass;
    protected static String aafurl;
    protected static Symm symm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean init(PrintStream out) {
        block15: {
            try {
                File pfile;
                String propfile = System.getProperty("cadi_prop_files");
                if (propfile == null) {
                    propfile = "raw.props";
                }
                if (!(pfile = new File(propfile)).exists()) {
                    if (!propfile.equals("raw.props")) break block15;
                    out.println("Creating 'raw.props'.  Edit for proper values, then run again.  Alternatively, set cadi_prop_files to a cadi properties file");
                    FileOutputStream fos = new FileOutputStream(pfile);
                    PrintStream ps = new PrintStream(fos);
                    try {
                        ps.println("# Use http://www.bing.com/maps to figure out LAT/LONG of an Address");
                        ps.println("AFT_LATITUDE=38.432930");
                        ps.println("AFT_LONGITUDE=-90.432480");
                        ps.println("AFT_ENVIRONMENT=AFTUAT");
                        ps.print("aaf_url");
                        ps.println("=aaf_url=https://DME2RESOLVE/service=com.att.authz.AuthorizationService/version=2.0/envContext=DEV/routeOffer=BAU_SE");
                        ps.print("cadi_keyfile");
                        ps.println("=<keyfile.  use java -jar cadi-core*.jar in lib dir>");
                        ps.println("aaf_id");
                        ps.print("=<your id>");
                        ps.println("aaf_password");
                        ps.print("=<your encrypted password.  use java -jar cadi-core*.jar in lib dir>");
                        break block15;
                    }
                    finally {
                        ps.close();
                    }
                }
                FileInputStream fis = new FileInputStream(propfile);
                try {
                    System.getProperties().load(fis);
                }
                finally {
                    fis.close();
                }
                String cadiKeyFile = System.getProperty("cadi_keyfile");
                aafid = System.getProperty("aaf_id");
                aafpass = System.getProperty("aaf_password");
                aafurl = System.getProperty("aaf_url");
                out.println("Contacting: " + aafurl);
                if (cadiKeyFile == null || aafid == null || aafpass == null || aafurl == null) {
                    out.print("cadi_keyfile");
                    out.print(", ");
                    out.print("cadi_keyfile");
                    out.print(", ");
                    out.print("cadi_keyfile");
                    out.print(", ");
                    out.print("cadi_keyfile");
                    out.print(" need to be set in ");
                    out.println(propfile);
                } else {
                    fis = new FileInputStream(cadiKeyFile);
                    try {
                        symm = Symm.obtain((InputStream)fis);
                    }
                    finally {
                        fis.close();
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
        }
        return false;
    }

    public abstract String call(PrintStream var1, String var2, String var3) throws Exception;

    public static void main(String[] args) {
        PrintStream out = System.out;
        try {
            if (RawClient.init(out)) {
                if (args.length < 2) {
                    System.out.println("Parameters: <Method> <path>");
                } else {
                    DME2 client = new DME2();
                    out.println(((RawClient)client).call(out, args[0], args[1]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
    }

    protected static class DME2
    extends RawClient {
        protected DME2() {
        }

        @Override
        public String call(PrintStream out, String meth, String path) {
            try {
                DME2Client client = new DME2Client(new URI(aafurl), 10000L);
                client.setCredentials(aafid, symm.depass(aafpass));
                client.setMethod(meth);
                client.setContext(path);
                if ("GET".equalsIgnoreCase(meth) || "DELETE".equalsIgnoreCase(meth)) {
                    client.setPayload("");
                } else if ("POST".equalsIgnoreCase(meth) || "PUT".equalsIgnoreCase(meth)) {
                    int c;
                    StringBuilder sb = new StringBuilder();
                    while ((c = System.in.read()) >= 0) {
                        sb.append((char)c);
                    }
                    client.setPayload(sb.toString());
                }
                return client.sendAndWait(10000L);
            }
            catch (Exception e) {
                e.printStackTrace(out);
                return "";
            }
        }
    }
}

