/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.client;

import com.att.cadi.CadiException;
import com.att.cadi.SecuritySetter;
import com.att.cadi.client.EClient;
import com.att.cadi.client.Future;
import com.att.inno.env.APIException;
import com.att.inno.env.Data;
import com.att.inno.env.util.Pool;
import com.att.rosetta.env.RosettaDF;
import com.att.rosetta.env.RosettaData;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class Rcli<CT> {
    public static final String BLANK = "";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPTS = "Accepts";
    protected static final String POST = "POST";
    protected static final String GET = "GET";
    protected static final String PUT = "PUT";
    protected static final String DELETE = "DELETE";
    protected Data.TYPE type;
    protected String apiVersion;
    protected int readTimeout = 5000;
    protected int connectionTimeout = 3000;
    protected URI uri;
    protected SecuritySetter<CT> ss;
    private String queryParams;
    private String fragment;
    public static Pool<byte[]> buffPool = new Pool<byte[]>(new Pool.Creator<byte[]>(){

        @Override
        public byte[] create() throws APIException {
            return new byte[1024];
        }

        @Override
        public void destroy(byte[] t) {
        }

        @Override
        public boolean isValid(byte[] t) {
            return true;
        }

        @Override
        public void reuse(byte[] t) {
        }
    });

    public void setSecuritySetter(SecuritySetter<CT> ss) {
        this.ss = ss;
    }

    public Rcli<CT> forUser(SecuritySetter<CT> ss) {
        Rcli<CT> rv = this.clone(this.uri == null ? this.uri : this.uri, ss);
        rv.ss = ss;
        rv.type = this.type;
        rv.apiVersion = this.apiVersion;
        return rv;
    }

    protected abstract Rcli<CT> clone(URI var1, SecuritySetter<CT> var2);

    public Rcli<CT> readTimeout(int millis) {
        this.readTimeout = millis;
        return this;
    }

    public Rcli<CT> connectionTimeout(int millis) {
        this.connectionTimeout = millis;
        return this;
    }

    public Rcli<CT> type(Data.TYPE type) {
        this.type = type;
        return this;
    }

    public Rcli<CT> apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String typeString(Class<?> cls) {
        return "application/" + cls.getSimpleName() + "+" + this.type.name().toLowerCase() + (this.apiVersion == null ? BLANK : ";version=" + this.apiVersion);
    }

    protected abstract EClient<CT> client() throws CadiException;

    public <T> Future<T> create(String pathinfo, String contentType, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(POST);
        client.addHeader(CONTENT_TYPE, contentType);
        client.setPathInfo(pathinfo);
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureCreate(df.getTypeClass());
    }

    public <T> Future<T> create(String pathinfo, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(POST);
        client.addHeader(CONTENT_TYPE, this.typeString(df.getTypeClass()));
        client.setPathInfo(pathinfo);
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureCreate(df.getTypeClass());
    }

    public <T> Future<T> create(String pathinfo, Class<?> cls, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(POST);
        client.addHeader(CONTENT_TYPE, this.typeString(cls));
        client.setPathInfo(pathinfo);
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureCreate(df.getTypeClass());
    }

    public <T> Future<T> create(String pathinfo, Class<T> cls) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(POST);
        client.addHeader(CONTENT_TYPE, this.typeString(cls));
        client.setPathInfo(pathinfo);
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPayload(null);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureCreate(cls);
    }

    public Future<Void> create(String pathinfo, String contentType) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(POST);
        client.addHeader(CONTENT_TYPE, contentType);
        client.setPathInfo(pathinfo);
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPayload(null);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureCreate(Void.class);
    }

    public Future<String> read(String pathinfo, String accept, String ... headers) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(GET);
        client.addHeader(ACCEPTS, accept);
        for (int i = 1; i < headers.length; i += 2) {
            client.addHeader(headers[i - 1], headers[i]);
        }
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(null);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureReadString();
    }

    public <T> Future<T> read(String pathinfo, String accept, RosettaDF<T> df, String ... headers) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(GET);
        client.addHeader(ACCEPTS, accept);
        for (int i = 1; i < headers.length; i += 2) {
            client.addHeader(headers[i - 1], headers[i]);
        }
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(null);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureRead(df, this.type);
    }

    public <T> Future<T> read(String pathinfo, RosettaDF<T> df, String ... headers) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(GET);
        client.addHeader(ACCEPTS, this.typeString(df.getTypeClass()));
        for (int i = 1; i < headers.length; i += 2) {
            client.addHeader(headers[i - 1], headers[i]);
        }
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(null);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureRead(df, this.type);
    }

    public <T> Future<T> read(String pathinfo, Class<?> cls, RosettaDF<T> df) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(GET);
        client.addHeader(ACCEPTS, this.typeString(cls));
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(null);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureRead(df, this.type);
    }

    public <T> Future<T> update(String pathinfo, String contentType, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(PUT);
        client.addHeader(CONTENT_TYPE, contentType);
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(t);
    }

    public <T> Future<String> updateRespondString(String pathinfo, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(PUT);
        client.addHeader(CONTENT_TYPE, this.typeString(df.getTypeClass()));
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.futureReadString();
    }

    public <T> Future<T> update(String pathinfo, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(PUT);
        client.addHeader(CONTENT_TYPE, this.typeString(df.getTypeClass()));
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(t);
    }

    public <T> Future<T> update(String pathinfo, Class<?> cls, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(PUT);
        client.addHeader(CONTENT_TYPE, this.typeString(cls));
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(t);
    }

    public <T> Future<Void> update(String pathinfo) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(PUT);
        client.addHeader(CONTENT_TYPE, this.typeString(Void.class));
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(null);
    }

    public <T> Future<T> delete(String pathinfo, String contentType, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(DELETE);
        client.addHeader(CONTENT_TYPE, contentType);
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(t);
    }

    public <T> Future<T> delete(String pathinfo, Class<?> cls, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(DELETE);
        client.addHeader(CONTENT_TYPE, this.typeString(cls));
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(t);
    }

    public <T> Future<T> delete(String pathinfo, final RosettaDF<T> df, final T t) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(DELETE);
        client.addHeader(CONTENT_TYPE, this.typeString(df.getTypeClass()));
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(new EClient.Transfer(){

            @Override
            public void transfer(OutputStream os) throws IOException, APIException {
                ((RosettaData)((RosettaData)df.newData()).out(Rcli.this.type)).direct(t, os, new boolean[0]);
            }
        });
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(t);
    }

    public <T> Future<T> delete(String pathinfo, Class<T> cls) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(DELETE);
        client.addHeader(CONTENT_TYPE, this.typeString(cls));
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(null);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(null);
    }

    public Future<Void> delete(String pathinfo, String contentType) throws APIException, CadiException {
        String qp;
        int idx = pathinfo.indexOf(63);
        if (idx >= 0) {
            qp = pathinfo.substring(idx + 1);
            pathinfo = pathinfo.substring(0, idx);
        } else {
            qp = this.queryParams;
        }
        EClient<CT> client = this.client();
        client.setMethod(DELETE);
        client.addHeader(CONTENT_TYPE, contentType);
        client.setQueryParams(qp);
        client.setFragment(this.fragment);
        client.setPathInfo(pathinfo);
        client.setPayload(null);
        client.send();
        this.fragment = null;
        this.queryParams = null;
        return client.future(null);
    }

    public Future<Void> transfer(final HttpServletRequest req, HttpServletResponse resp, String pathParam, int expected) throws CadiException, APIException {
        URI uri;
        EClient<CT> client = this.client();
        try {
            uri = new URI(req.getRequestURI());
        }
        catch (Exception e) {
            throw new CadiException("Invalid incoming URI", (Throwable)e);
        }
        Enumeration en = req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            client.addHeader(name, req.getHeader(name));
        }
        client.setQueryParams(req.getQueryString());
        client.setFragment(uri.getFragment());
        client.setPathInfo(pathParam);
        String meth = req.getMethod();
        client.setMethod(meth);
        if (!GET.equals(meth)) {
            client.setPayload(new EClient.Transfer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void transfer(OutputStream os) throws IOException, APIException {
                    ServletInputStream is = req.getInputStream();
                    Pool.Pooled<byte[]> pbuff = buffPool.get();
                    try {
                        int read;
                        while ((read = is.read((byte[])pbuff.content)) >= 0) {
                            os.write((byte[])pbuff.content, 0, read);
                        }
                    }
                    finally {
                        pbuff.done();
                    }
                }
            });
        }
        client.send();
        return client.future(resp, expected);
    }

    public String toString() {
        return this.uri.toString();
    }

    public Rcli<CT> setQueryParams(String queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public Rcli<CT> setFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public URI getURI() {
        return this.uri;
    }
}

