/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.client;

public class Result<T> {
    public final int code;
    public final T value;
    public final String error;

    private Result(int code, T value, String error) {
        this.code = code;
        this.value = value;
        this.error = error;
    }

    public static <T> Result<T> ok(int code, T t) {
        return new Result<T>(code, t, null);
    }

    public static <T> Result<T> err(int code, String body) {
        return new Result<Object>(code, null, body);
    }

    public boolean isOK() {
        return this.error == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Code: ");
        sb.append(this.code);
        if (this.error != null) {
            sb.append(" = ");
            sb.append(this.error);
        }
        return sb.toString();
    }
}

