/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.dme2;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.handler.DME2RestfulHandler;
import com.att.cadi.CadiException;
import com.att.cadi.SecuritySetter;
import com.att.cadi.client.EClient;
import com.att.cadi.client.Future;
import com.att.inno.env.APIException;
import com.att.inno.env.Data;
import com.att.rosetta.env.RosettaDF;
import com.att.rosetta.env.RosettaData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletResponse;

public class DEClient
implements EClient<DME2Client> {
    private DME2Client client;
    private DME2RestfulHandler replyHandler;
    private EClient.Transfer payload;

    public DEClient(DME2Manager manager, SecuritySetter<DME2Client> ss, URI uri, long timeout) throws DME2Exception, CadiException {
        this.client = new DME2Client(manager, uri, timeout);
        this.client.setAllowAllHttpReturnCodes(Boolean.valueOf(true));
        ss.setSecurity((Object)this.client);
        this.replyHandler = new DME2RestfulHandler("");
        this.client.setReplyHandler((AsyncResponseHandlerIntf)this.replyHandler);
    }

    @Override
    public void setMethod(String meth) {
        this.client.setMethod(meth);
    }

    @Override
    public void setPathInfo(String pathinfo) {
        int qp = pathinfo.indexOf(63);
        if (qp < 0) {
            this.client.setContext(pathinfo);
        } else {
            this.client.setContext(pathinfo.substring(0, qp));
            this.client.setQueryParams(pathinfo.substring(qp + 1));
        }
    }

    @Override
    public void setPayload(EClient.Transfer transfer) {
        this.payload = transfer;
    }

    @Override
    public void addHeader(String tag, String value) {
        this.client.addHeader(tag, value);
    }

    @Override
    public void setQueryParams(String q) {
        this.client.setQueryParams(q);
    }

    @Override
    public void setFragment(String f) {
    }

    @Override
    public void send() throws APIException {
        try {
            if (this.payload != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.payload.transfer(baos);
                this.client.setPayload(new String(baos.toByteArray()));
            } else {
                this.client.setPayload("");
            }
            this.client.send();
        }
        catch (DME2Exception e) {
            throw new APIException(e);
        }
        catch (IOException e) {
            throw new APIException(e);
        }
    }

    @Override
    public <T> Future<T> futureCreate(Class<T> t) {
        return new DFuture<T>(this.replyHandler){

            @Override
            public boolean get(int timeout) throws Exception {
                this.info = this.reply.getResponse((long)timeout);
                return this.info.getCode() == 201;
            }
        };
    }

    @Override
    public Future<String> futureReadString() {
        return new DFuture<String>(this.replyHandler){

            @Override
            public boolean get(int timeout) throws Exception {
                this.info = this.reply.getResponse((long)timeout);
                if (this.info.getCode() == 200) {
                    this.value = this.info.getBody();
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public <T> Future<T> futureRead(final RosettaDF<T> df, final Data.TYPE type) {
        return new DFuture<T>(this.replyHandler){

            @Override
            public boolean get(int timeout) throws Exception {
                this.info = this.reply.getResponse((long)timeout);
                if (this.info.getCode() == 200) {
                    this.value = ((RosettaData)((RosettaData)((RosettaData)df.newData()).in(type)).load(this.info.getBody())).asObject();
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public <T> Future<T> future(final T t) {
        return new DFuture<T>(this.replyHandler){

            @Override
            public boolean get(int timeout) throws Exception {
                this.info = this.reply.getResponse((long)timeout);
                if (this.info.getCode() == 200) {
                    this.value = t;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public Future<Void> future(HttpServletResponse resp, int expected) throws APIException {
        return null;
    }

    public class DFuture<T>
    extends Future<T> {
        protected final DME2RestfulHandler reply;
        protected DME2RestfulHandler.ResponseInfo info;

        public DFuture(DME2RestfulHandler reply) {
            this.reply = reply;
        }

        @Override
        public boolean get(int timeout) throws Exception {
            this.info = this.reply.getResponse((long)timeout);
            return this.info.getCode() == 200;
        }

        @Override
        public int code() {
            return this.info.getCode();
        }

        @Override
        public String body() {
            return this.info.getBody();
        }

        @Override
        public String header(String tag) {
            return this.info.header(tag);
        }
    }
}

