/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.dme2;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.DME2Server;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.cadi.Access;
import com.att.cadi.Locator;
import com.att.cadi.LocatorException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class DME2Locator
implements Locator {
    private DME2Manager dm;
    private DME2Endpoint[] endpoints;
    private Access access;
    private String service;
    private String version;
    private String routeOffer;
    private String envContext;
    private String thisMachine;
    private String pathInfo;
    private int thisPort;
    private boolean removeSelf;
    private static final Random random = new Random();

    public DME2Locator(Access access, DME2Manager dm, String service, String version, String envContext, String routeOffer) throws DME2Exception, UnknownHostException, LocatorException {
        this(access, dm, service, version, envContext, routeOffer, false);
    }

    public DME2Locator(Access access, DME2Manager dm, String service, String version, String envContext, String routeOffer, boolean removeSelf) throws DME2Exception, UnknownHostException, LocatorException {
        this.access = access;
        this.dm = dm == null ? new DME2Manager("DME2Locator created DME2Manager", System.getProperties()) : dm;
        this.service = service;
        this.version = version;
        this.envContext = envContext;
        this.routeOffer = routeOffer;
        this.refresh();
        DME2Server server = dm.getServer();
        if (server == null) {
            this.thisMachine = InetAddress.getLocalHost().getHostName();
            this.thisPort = 0;
        }
        this.removeSelf = removeSelf;
    }

    public DME2Locator(Access access, DME2Manager dm, String aafurl) throws DME2Exception, UnknownHostException, LocatorException {
        this(access, dm, aafurl, false);
    }

    public DME2Locator(Access access, DME2Manager dm, String aafurl, boolean removeSelf) throws DME2Exception, UnknownHostException, LocatorException {
        if (aafurl == null) {
            throw new LocatorException("URL is null");
        }
        this.access = access;
        this.dm = dm == null ? new DME2Manager("DME2Locator created DME2Manager", System.getProperties()) : dm;
        String[] split = aafurl.split("/");
        StringBuilder sb = new StringBuilder();
        boolean dme2Entered = false;
        for (String s : split) {
            if (s.startsWith("service=")) {
                this.service = s.substring(8);
            } else if (s.startsWith("version=")) {
                this.version = s.substring(8);
            } else if (s.startsWith("envContext=")) {
                this.envContext = s.substring(11);
            } else if (s.startsWith("routeOffer=")) {
                this.routeOffer = s.substring(11);
                dme2Entered = true;
            } else if (dme2Entered) {
                sb.append('/');
                sb.append(s);
            }
            this.pathInfo = sb.toString();
        }
        DME2Server server = dm.getServer();
        if (server == null) {
            this.thisMachine = InetAddress.getLocalHost().getHostName();
            this.thisPort = 0;
        } else if (this.thisMachine == null) {
            this.thisMachine = InetAddress.getLocalHost().getHostName();
            this.thisPort = 0;
        }
        this.removeSelf = removeSelf;
        this.refresh();
    }

    public boolean refresh() {
        try {
            this.endpoints = this.dm.findEndpoints(this.service, this.version, this.envContext, this.routeOffer, true);
            if (this.removeSelf) {
                for (int i = 0; i < this.endpoints.length; ++i) {
                    if (this.endpoints[i].getPort() != this.thisPort || !this.endpoints[i].getHost().equals(this.thisMachine)) continue;
                    this.endpoints[i] = null;
                }
            }
            return this.endpoints.length != 0;
        }
        catch (Exception e) {
            this.access.log(Access.Level.ERROR, new Object[]{e.getMessage()});
            return false;
        }
    }

    private String noEndpointsString() {
        StringBuilder sb = new StringBuilder("No DME2 Endpoints found for ");
        sb.append(this.service);
        sb.append('/');
        sb.append(this.version);
        sb.append('/');
        sb.append(this.envContext);
        sb.append('/');
        sb.append(this.routeOffer);
        return sb.toString();
    }

    public URI get(Locator.Item item) throws URISyntaxException, LocatorException {
        DME2Endpoint de;
        if (!this.hasItems()) {
            throw new LocatorException(this.noEndpointsString());
        }
        if (item == null) {
            return null;
        }
        Item li = (Item)item;
        if (li.uri != null) {
            return li.uri;
        }
        if (li.idx < this.endpoints.length && (de = this.endpoints[li.idx]) != null) {
            return li.uri = new URI(de.getProtocol(), null, de.getHost(), de.getPort(), this.pathInfo, null, null);
        }
        return null;
    }

    public boolean hasItems() {
        return this.endpoints != null && this.endpoints.length > 0;
    }

    public void invalidate(Locator.Item item) throws URISyntaxException, LocatorException {
        int idx;
        if (item instanceof Item && (idx = ((Item)item).idx) < this.endpoints.length) {
            int i;
            DME2Endpoint uhoh = this.endpoints[idx];
            this.endpoints[idx] = null;
            boolean noneLeft = true;
            for (i = 0; i < this.endpoints.length && noneLeft; ++i) {
                noneLeft = this.endpoints[i] == null;
            }
            if (noneLeft && this.refresh()) {
                for (i = 0; i < this.endpoints.length && noneLeft; ++i) {
                    DME2Endpoint ep = this.endpoints[i];
                    if (ep == null || !ep.getHost().equals(uhoh.getHost()) || ep.getPort() != uhoh.getPort()) continue;
                    this.endpoints[i] = null;
                }
            }
        }
    }

    public Item best() throws LocatorException {
        int i;
        if (!this.hasItems() && !this.refresh()) {
            throw new LocatorException("No DME2 Endpoints Available");
        }
        int[] usable = new int[this.endpoints.length];
        int count = 0;
        for (int i2 = 0; i2 < this.endpoints.length; ++i2) {
            if (this.endpoints[i2] == null) continue;
            usable[count++] = i2;
        }
        switch (count) {
            case 0: {
                this.refresh();
                return null;
            }
            case 1: {
                return new Item(usable[0]);
            }
        }
        int[] samemach = new int[count];
        int samecount = 0;
        int closecount = 0;
        Integer[] closemach = new Integer[count];
        for (i = 0; i < count; ++i) {
            DME2Endpoint ep = this.endpoints[usable[i]];
            String host = ep.getHost();
            if (this.thisMachine.equalsIgnoreCase(host)) {
                samemach[samecount++] = usable[i];
                continue;
            }
            closemach[closecount++] = usable[i];
        }
        switch (samecount) {
            case 0: {
                break;
            }
            case 1: {
                return new Item(samemach[0]);
            }
            default: {
                i = random.nextInt();
                return new Item(usable[Math.abs(i % samecount)]);
            }
        }
        switch (closecount) {
            case 0: {
                return null;
            }
            case 1: {
                return new Item(closemach[0]);
            }
        }
        DoubIndex[] remote = new DoubIndex[closecount];
        int remotecount = 0;
        for (int i3 = 0; i3 < closecount; ++i3) {
            DME2Endpoint de = this.endpoints[usable[i3]];
            remote[remotecount++] = new DoubIndex(de.getDistance(), i3);
        }
        Arrays.sort(remote, new Comparator<DoubIndex>(){

            @Override
            public int compare(DoubIndex a, DoubIndex b) {
                if (a.d < b.d) {
                    return -1;
                }
                if (a.d > b.d) {
                    return 1;
                }
                return random.nextInt() % 1 == 0 ? 1 : 0;
            }
        });
        return new Item(remote[0].idx);
    }

    public Item first() {
        if (this.endpoints == null) {
            return null;
        }
        for (int i = 0; i < this.endpoints.length; ++i) {
            if (this.endpoints[i] == null) continue;
            return new Item(i);
        }
        return null;
    }

    public Item next(Locator.Item item) throws LocatorException {
        int idx;
        if (this.endpoints == null || this.endpoints.length == 0 || !(item instanceof Item)) {
            return null;
        }
        for (int i = idx = ((Item)item).idx + 1; i < this.endpoints.length; ++i) {
            if (this.endpoints[i] == null) continue;
            return new Item(i);
        }
        return null;
    }

    private class DoubIndex {
        public final double d;
        public final int idx;

        public DoubIndex(double doub, int i) {
            this.d = doub;
            this.idx = i;
        }
    }

    public class Item
    implements Locator.Item {
        private final int idx;
        private URI uri;

        private Item(int i) {
            this.idx = i;
            this.uri = null;
        }
    }
}

