/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.http;

import com.att.cadi.LocatorException;
import com.att.cadi.SecuritySetter;
import com.att.cadi.client.EClient;
import com.att.cadi.client.Future;
import com.att.cadi.client.Rcli;
import com.att.inno.env.APIException;
import com.att.inno.env.Data;
import com.att.inno.env.util.Pool;
import com.att.rosetta.env.RosettaDF;
import com.att.rosetta.env.RosettaData;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class HClient
implements EClient<HttpURLConnection> {
    private URI uri;
    private ArrayList<Header> headers;
    private String meth;
    private String pathinfo;
    private String query;
    private String fragment;
    private EClient.Transfer transfer;
    private SecuritySetter<HttpURLConnection> ss;
    private HttpURLConnection huc;
    private int connectTimeout;

    public HClient(SecuritySetter<HttpURLConnection> ss, URI uri, int connectTimeout) throws Exception {
        if (uri == null) {
            throw new LocatorException("No Client available to call");
        }
        this.uri = uri;
        this.ss = ss;
        this.connectTimeout = connectTimeout;
        this.fragment = "";
        this.query = "";
        this.pathinfo = "";
    }

    @Override
    public void setMethod(String meth) {
        this.meth = meth;
    }

    @Override
    public void setPathInfo(String pathinfo) {
        this.pathinfo = pathinfo;
    }

    @Override
    public void setPayload(EClient.Transfer transfer) {
        this.transfer = transfer;
    }

    @Override
    public void addHeader(String tag, String value) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(new Header(tag, value));
    }

    @Override
    public void setQueryParams(String q) {
        this.query = q;
    }

    @Override
    public void setFragment(String f) {
        this.fragment = f;
    }

    @Override
    public void send() throws APIException {
        try {
            StringBuilder pi = new StringBuilder(this.uri.getPath());
            if (!this.pathinfo.startsWith("/")) {
                pi.append('/');
            }
            pi.append(this.pathinfo);
            URL url = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), pi.toString(), this.query, this.fragment).toURL();
            this.pathinfo = null;
            this.query = null;
            this.fragment = null;
            this.huc = (HttpURLConnection)url.openConnection();
            if (this.ss != null) {
                this.ss.setSecurity((Object)this.huc);
            }
            this.huc.setRequestMethod(this.meth);
            if (this.headers != null) {
                for (Header d : this.headers) {
                    this.huc.addRequestProperty(d.tag, d.value);
                }
            }
            this.huc.setDoInput(true);
            this.huc.setDoOutput(true);
            this.huc.setUseCaches(false);
            this.huc.setConnectTimeout(this.connectTimeout);
            this.huc.connect();
            if (this.transfer != null) {
                this.transfer.transfer(this.huc.getOutputStream());
            }
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            this.pathinfo = null;
            this.meth = null;
            if (this.headers != null) {
                this.headers.clear();
            }
            this.fragment = "";
            this.query = "";
            this.pathinfo = "";
        }
    }

    @Override
    public <T> Future<T> futureCreate(Class<T> t) {
        return new HFuture<T>(this.huc){

            @Override
            public boolean get(int timeout) throws Exception {
                try {
                    this.huc.setReadTimeout(timeout);
                    this.respMessage = this.huc.getResponseMessage();
                    this.respCode = this.huc.getResponseCode();
                    if (this.respCode == 201) {
                        boolean bl = true;
                        return bl;
                    }
                    this.extractError();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public String body() {
                if (this.errContent != null) {
                    return this.errContent.toString();
                }
                if (this.respMessage != null) {
                    return this.respMessage;
                }
                return "";
            }
        };
    }

    @Override
    public Future<String> futureReadString() {
        return new HFuture<String>(this.huc){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean get(int timeout) throws Exception {
                try {
                    this.huc.setReadTimeout(timeout);
                    this.respCode = this.huc.getResponseCode();
                    this.respMessage = this.huc.getResponseMessage();
                    if (this.respCode == 200) {
                        StringBuilder sb = this.inputStreamToString(this.huc.getInputStream());
                        if (sb != null) {
                            this.value = sb.toString();
                        }
                        boolean bl = true;
                        return bl;
                    }
                    this.extractError();
                }
                finally {
                    this.close();
                }
                return false;
            }

            @Override
            public String body() {
                if (this.value != null) {
                    return (String)this.value;
                }
                if (this.errContent != null) {
                    return this.errContent.toString();
                }
                if (this.respMessage != null) {
                    return this.respMessage;
                }
                return "";
            }
        };
    }

    @Override
    public <T> Future<T> futureRead(final RosettaDF<T> df, final Data.TYPE type) {
        return new HFuture<T>(this.huc){
            private Data<T> data;

            @Override
            public boolean get(int timeout) throws Exception {
                try {
                    this.huc.setReadTimeout(timeout);
                    this.respCode = this.huc.getResponseCode();
                    this.respMessage = this.huc.getResponseMessage();
                    if (this.respCode == 200) {
                        this.data = ((RosettaData)((RosettaData)df.newData()).in(type)).load(this.huc.getInputStream());
                        this.value = this.data.asObject();
                        boolean bl = true;
                        return bl;
                    }
                    this.extractError();
                }
                finally {
                    this.close();
                }
                return false;
            }

            @Override
            public String body() {
                if (this.data != null) {
                    try {
                        return this.data.asString();
                    }
                    catch (APIException aPIException) {
                    }
                } else {
                    if (this.errContent != null) {
                        return this.errContent.toString();
                    }
                    if (this.respMessage != null) {
                        return this.respMessage;
                    }
                }
                return "";
            }
        };
    }

    @Override
    public <T> Future<T> future(final T t) {
        return new HFuture<T>(this.huc){

            @Override
            public boolean get(int timeout) throws Exception {
                try {
                    this.huc.setReadTimeout(timeout);
                    this.respCode = this.huc.getResponseCode();
                    this.respMessage = this.huc.getResponseMessage();
                    if (this.respCode == 200) {
                        this.value = t;
                        boolean bl = true;
                        return bl;
                    }
                    this.extractError();
                }
                finally {
                    this.close();
                }
                return false;
            }

            @Override
            public String body() {
                if (this.errContent != null) {
                    return this.errContent.toString();
                }
                if (this.respMessage != null) {
                    return this.respMessage;
                }
                return Integer.toString(this.respCode);
            }
        };
    }

    @Override
    public Future<Void> future(final HttpServletResponse resp, final int expected) throws APIException {
        return new HFuture<Void>(this.huc){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean get(int timeout) throws Exception {
                try {
                    block17: {
                        this.huc.setReadTimeout(timeout);
                        this.respCode = this.huc.getResponseCode();
                        resp.setStatus(this.respCode);
                        this.respMessage = this.huc.getResponseMessage();
                        ServletOutputStream os = resp.getOutputStream();
                        if (this.respCode == expected) {
                            InputStream is = this.huc.getInputStream();
                            Pool.Pooled<byte[]> pbuff = Rcli.buffPool.get();
                            try {
                                int read;
                                while ((read = is.read((byte[])pbuff.content)) >= 0) {
                                    os.write((byte[])pbuff.content, 0, read);
                                }
                            }
                            finally {
                                pbuff.done();
                            }
                            boolean bl = true;
                            return bl;
                        }
                        InputStream is = this.huc.getErrorStream();
                        try {
                            if (is == null) {
                                is = this.huc.getInputStream();
                            }
                            if (is == null) break block17;
                            this.errContent = new StringBuilder();
                            Pool.Pooled<byte[]> pbuff = Rcli.buffPool.get();
                            try {
                                int read;
                                while ((read = is.read((byte[])pbuff.content)) >= 0) {
                                    os.write((byte[])pbuff.content, 0, read);
                                }
                            }
                            finally {
                                pbuff.done();
                            }
                        }
                        catch (IOException e) {
                            this.exception = e;
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public String body() {
                return this.errContent == null ? this.respMessage : this.errContent.toString();
            }
        };
    }

    private static class Header {
        public final String tag;
        public final String value;

        public Header(String t, String v) {
            this.tag = t;
            this.value = v;
        }

        public String toString() {
            return this.tag + '=' + this.value;
        }
    }

    public abstract class HFuture<T>
    extends Future<T> {
        protected HttpURLConnection huc;
        protected int respCode;
        protected String respMessage;
        protected IOException exception;
        protected StringBuilder errContent;

        public HFuture(HttpURLConnection huc) {
            this.huc = huc;
        }

        @Override
        public boolean get(int timeout) throws Exception {
            try {
                this.huc.setReadTimeout(timeout);
                this.respCode = this.huc.getResponseCode();
                this.respMessage = this.huc.getResponseMessage();
            }
            finally {
                this.close();
            }
            return this.respCode == 200;
        }

        protected void extractError() {
            InputStream is = this.huc.getErrorStream();
            try {
                if (is == null) {
                    is = this.huc.getInputStream();
                }
                if (is != null) {
                    int c;
                    this.errContent = new StringBuilder();
                    while ((c = is.read()) >= 0) {
                        this.errContent.append((char)c);
                    }
                }
            }
            catch (IOException e) {
                this.exception = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StringBuilder inputStreamToString(InputStream is) {
            try {
                StringBuilder sb = new StringBuilder();
                InputStreamReader rdr = new InputStreamReader(is);
                try {
                    int read;
                    char[] buf = new char[256];
                    while ((read = rdr.read(buf)) >= 0) {
                        sb.append(buf, 0, read);
                    }
                }
                finally {
                    ((Reader)rdr).close();
                }
                return sb;
            }
            catch (IOException e) {
                this.exception = e;
                return null;
            }
        }

        @Override
        public int code() {
            return this.respCode;
        }

        public HttpURLConnection huc() {
            return this.huc;
        }

        public IOException exception() {
            return this.exception;
        }

        public String respMessage() {
            return this.respMessage;
        }

        @Override
        public String header(String tag) {
            return this.huc.getHeaderField(tag);
        }

        public void close() {
            this.huc.disconnect();
        }
    }
}

