/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.http;

import com.att.cadi.Access;
import com.att.cadi.Locator;
import com.att.cadi.SecuritySetter;
import com.att.cadi.client.Rcli;
import com.att.cadi.http.HRcli;
import com.att.cadi.http.Retryable;
import com.att.inno.env.APIException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import javax.net.ssl.SSLHandshakeException;

public class HMangr {
    private String apiVersion;
    private int readTimeout = 10000;
    private int connectionTimeout = 3000;
    public final Locator loc;
    private Access access;

    public HMangr(Access access, Locator loc) throws Exception {
        this.loc = loc;
        this.access = access;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET> RET same(SecuritySetter<HttpURLConnection> ss, Retryable<HttpURLConnection, RET> retryable) throws Exception {
        RET ret = null;
        boolean retry = true;
        int retries = 0;
        Rcli<Object> client = retryable.lastClient;
        try {
            do {
                if (retryable.item() == null) {
                    retryable.item(this.loc.best());
                    retryable.lastClient = null;
                }
                if (client == null) {
                    URI uri = this.loc.get(retryable.item());
                    if (uri == null) {
                        this.loc.invalidate(retryable.item());
                        retryable.item(this.loc.next(retryable.item()));
                        continue;
                    }
                    client = new HRcli(this, uri, ss).connectionTimeout(this.connectionTimeout).readTimeout(this.readTimeout).apiVersion(this.apiVersion);
                } else {
                    client.setSecuritySetter(ss);
                }
                retry = false;
                try {
                    ret = retryable.code(client);
                }
                catch (APIException e) {
                    Locator.Item item = retryable.item();
                    this.loc.invalidate(item);
                    retryable.item(this.loc.next(item));
                    try {
                        Throwable ec = e.getCause();
                        if (ec instanceof ConnectException) {
                            if (client != null && ++retries < 2) {
                                this.access.log(Access.Level.INFO, new Object[]{"Connection refused, trying next available service"});
                                retry = true;
                                continue;
                            }
                            throw new APIException("Connection refused, no more available connections to try");
                        }
                        if (ec instanceof SSLHandshakeException) {
                            this.access.log(Access.Level.ERROR, new Object[]{ec.getMessage()});
                            retry = false;
                            continue;
                        }
                        retryable.item(null);
                        if (ec instanceof Exception) {
                            throw (Exception)ec;
                        }
                        throw e;
                    }
                    finally {
                        client = null;
                    }
                }
            } while (retry);
        }
        finally {
            retryable.lastClient = client;
        }
        return ret;
    }

    public <RET> RET best(SecuritySetter<HttpURLConnection> ss, Retryable<HttpURLConnection, RET> retryable) throws Exception {
        retryable.item(this.loc.best());
        return this.same(ss, retryable);
    }

    public <RET> RET all(SecuritySetter<HttpURLConnection> ss, Retryable<HttpURLConnection, RET> retryable) throws Exception {
        return this.all(ss, retryable, true);
    }

    public <RET> RET all(SecuritySetter<HttpURLConnection> ss, Retryable<HttpURLConnection, RET> retryable, boolean notify) throws Exception {
        RET ret = null;
        this.loc.refresh();
        Locator.Item li = this.loc.first();
        while (li != null) {
            URI uri = this.loc.get(li);
            try {
                ret = retryable.code(new HRcli(this, uri, ss));
                this.access.log(Access.Level.DEBUG, new Object[]{"Success calling", uri, "during call to all services"});
            }
            catch (APIException e) {
                Throwable t = e.getCause();
                if (t != null && t instanceof ConnectException) {
                    this.loc.invalidate(li);
                    this.access.log(Access.Level.ERROR, new Object[]{"Connection to", uri, "refused during call to all services"});
                }
                throw e;
            }
            catch (ConnectException e) {
                this.loc.invalidate(li);
                this.access.log(Access.Level.ERROR, new Object[]{"Connection to", uri, "refused during call to all services"});
            }
            li = this.loc.next(li);
        }
        if (ret == null && notify) {
            throw new APIException("No available clients to call");
        }
        return ret;
    }

    public void close() {
    }

    public HMangr readTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public int readTimeout() {
        return this.readTimeout;
    }

    public void connectionTimeout(int t) {
        this.connectionTimeout = t;
    }

    public int connectionTimout() {
        return this.connectionTimeout;
    }

    public HMangr apiVersion(String version) {
        this.apiVersion = version;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }
}

