/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.http;

import com.att.cadi.CadiException;
import com.att.cadi.SecuritySetter;
import com.att.cadi.config.SecurityInfo;
import com.att.cadi.principal.BasicPrincipal;
import com.att.cadi.principal.TGuardPrincipal;
import com.att.cadi.taf.csp.CSPPrincipal;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.Principal;
import javax.net.ssl.HttpsURLConnection;

public class TransferSS
implements SecuritySetter<HttpURLConnection> {
    private String value;
    private SecurityInfo securityInfo;
    private boolean trust;
    private SecuritySetter<HttpURLConnection> defSS;

    public TransferSS(Principal principal) throws IOException {
        if (principal instanceof CSPPrincipal) {
            this.value = "CSP " + ((CSPPrincipal)principal).attessec();
            this.trust = false;
        } else if (principal instanceof TGuardPrincipal) {
            this.value = "TGUARD " + ((TGuardPrincipal)principal).info();
            this.trust = true;
        } else if (principal instanceof BasicPrincipal) {
            this.value = ((BasicPrincipal)principal).getAsHeader();
            this.trust = false;
        } else {
            this.trust = true;
        }
    }

    public TransferSS(Principal principal, SecurityInfo si) throws IOException {
        this(principal);
        this.securityInfo = si;
        this.defSS = si.defSS;
    }

    public void setSecurity(HttpURLConnection huc) throws CadiException {
        if (this.value != null) {
            if (this.trust) {
                if (this.defSS == null) {
                    throw new CadiException("Need App Credentials to send message");
                }
                this.defSS.setSecurity((Object)huc);
                huc.setRequestProperty("AS_USER", this.value);
            } else {
                huc.setRequestProperty("Authorization", this.value);
            }
        }
        if (this.securityInfo != null && huc instanceof HttpsURLConnection) {
            this.securityInfo.setSocketFactoryOn((HttpsURLConnection)huc);
        }
    }
}

