/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.http;

import com.att.cadi.CadiException;
import com.att.cadi.SecuritySetter;
import com.att.cadi.Symm;
import com.att.cadi.config.SecurityInfo;
import com.att.inno.env.APIException;
import com.att.inno.env.util.Chrono;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.X509KeyManager;

public class X509SS
implements SecuritySetter<HttpURLConnection> {
    private static final byte[] X509 = "x509 ".getBytes();
    private PrivateKey priv;
    private byte[] pub;
    private String cert;
    private SecurityInfo securityInfo;
    private String algo;
    private static int count = new Random().nextInt();

    public X509SS(SecurityInfo si) throws APIException, IOException, CertificateEncodingException {
        this(si, null);
    }

    public X509SS(SecurityInfo si, String alias) throws APIException, IOException, CertificateEncodingException {
        int i;
        this.securityInfo = si;
        if (alias == null) {
            alias = si.default_alias;
        }
        if (alias == null) {
            throw new APIException("JKS Alias is required to use X509SS Security.  Use cadi_alias to set default alias");
        }
        this.priv = null;
        X509KeyManager[] xkms = si.getKeyManagers();
        if (xkms == null) {
            System.out.println("need KeyManager");
            System.exit(1);
        }
        for (i = 0; this.priv == null && i < xkms.length; ++i) {
            this.priv = xkms[i].getPrivateKey(alias);
        }
        for (i = 0; this.cert == null && i < xkms.length; ++i) {
            X509Certificate[] chain = xkms[i].getCertificateChain(alias);
            if (chain == null || chain.length <= 0) continue;
            this.algo = chain[0].getSigAlgName();
            this.pub = chain[0].getEncoded();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.pub.length * 2);
            ByteArrayInputStream bais = new ByteArrayInputStream(this.pub);
            Symm.base64noSplit().encode((InputStream)bais, (OutputStream)baos, X509);
            this.cert = baos.toString();
        }
        if (this.algo == null) {
            throw new APIException("X509 Security Setter not configured");
        }
    }

    public void setSecurity(HttpURLConnection huc) throws CadiException {
        if (huc instanceof HttpsURLConnection) {
            this.securityInfo.setSocketFactoryOn((HttpsURLConnection)huc);
        }
        if (this.securityInfo.isOneway()) {
            huc.setRequestProperty("Authorization", this.cert);
            try {
                String data = "SignedContent[" + this.inc() + ']' + Chrono.dateTime();
                huc.setRequestProperty("Data", data);
                Signature sig = Signature.getInstance(this.algo);
                sig.initSign(this.priv);
                sig.update(data.getBytes());
                byte[] signature = sig.sign();
                ByteArrayOutputStream baos = new ByteArrayOutputStream((int)((double)signature.length * 1.3));
                ByteArrayInputStream bais = new ByteArrayInputStream(signature);
                Symm.base64noSplit().encode((InputStream)bais, (OutputStream)baos);
                huc.setRequestProperty("Signature", new String(baos.toByteArray()));
            }
            catch (Exception e) {
                throw new CadiException((Throwable)e);
            }
        }
    }

    private synchronized int inc() {
        return ++count;
    }
}

