/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.lur.aaf;

import aaf.xsd.Role;
import aaf.xsd.Roles;
import com.att.aft.dme2.api.DME2Client;
import com.att.cadi.Access;
import com.att.cadi.CadiException;
import com.att.cadi.Permission;
import com.att.cadi.User;
import com.att.cadi.lur.aaf.AAFRole;
import com.att.cadi.lur.aaf.AbsAAFLur;
import com.att.cadi.lur.aaf.JaxSetDocRoles;
import com.att.rosetta.OutJax;
import java.io.StringReader;
import java.io.Writer;
import java.security.Principal;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AAFLurRole1_0
extends AbsAAFLur<AAFRole> {
    private Pattern att_mechID = Pattern.compile("[a-zA-Z][a-zA-Z0-9][0-9]{3}[a-zA-Z0-9]");

    public AAFLurRole1_0(Access access, String dmeServiceName, String mechUser, String mechPasswd, int dmeTimeOut, long userExpiration, int highCount) throws CadiException {
        super(access, dmeServiceName, mechUser, mechPasswd, dmeTimeOut, userExpiration, highCount, 2);
    }

    @Override
    protected boolean isCorrectPermType(Permission pond) {
        return pond instanceof AAFRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected User<AAFRole> loadUser(Principal bait) throws Exception {
        User user;
        Principal principal = (Principal)transmutate.mutate(bait);
        if (principal == null) {
            return null;
        }
        String name = principal.getName();
        long start = System.nanoTime();
        DME2Client client = this.newClient();
        try {
            client.setPayload("/authz/users/" + name + "/roles");
            String responseText = client.sendAndWait((long)this.dmeTimeout);
            JaxSetDocRoles jsd = new JaxSetDocRoles();
            new OutJax(jsd).extract(new StringReader(responseText), (Writer)null, inJSON, new boolean[0]);
            User user2 = this.getUser(bait);
            if (user2 == null) {
                user2 = new User(bait, this.userExpiration);
            }
            this.addUser(user2);
            Roles roles = jsd.getRoles();
            if (roles != null) {
                Map newMap = user2.newMap();
                for (Role role : roles.getRoles()) {
                    user2.add(newMap, (Permission)new AAFRole(role));
                }
                user2.setMap(newMap);
            }
            user = user2;
        }
        catch (Throwable throwable) {
            float time = (float)(System.nanoTime() - start) / 1000000.0f;
            this.access.log(Access.Level.AUDIT, new Object[]{"Remote AAF Service Lookup", name, "in", Float.valueOf(time), "ms"});
            throw throwable;
        }
        float time = (float)(System.nanoTime() - start) / 1000000.0f;
        this.access.log(Access.Level.AUDIT, new Object[]{"Remote AAF Service Lookup", name, "in", Float.valueOf(time), "ms"});
        return user;
    }

    @Override
    public boolean supports(String userName) {
        if (userName == null) {
            return false;
        }
        Matcher m = this.att_mechID.matcher(userName);
        return m == null ? false : m.matches();
    }
}

