/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.lur.aaf;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.handler.DME2RestfulHandler;
import com.att.cadi.AbsUserCache;
import com.att.cadi.Access;
import com.att.cadi.CadiException;
import com.att.cadi.Lur;
import com.att.cadi.Permission;
import com.att.cadi.Transmutate;
import com.att.cadi.User;
import com.att.cadi.lur.aaf.AAFTransmutate;
import com.att.rosetta.InJson;
import java.net.URI;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;

public abstract class AbsAAFLur<PERM extends Permission>
extends AbsUserCache<PERM>
implements Lur {
    private String[] supports;
    protected final String dmeServiceName;
    protected final HashMap<String, String> headers;
    protected final int dmeTimeout;
    protected static final InJson inJSON = new InJson();
    protected final long userExpiration;
    protected final Access access;
    protected static final Transmutate<Principal> transmutate = new AAFTransmutate();

    protected AbsAAFLur(Access access, String dmeServiceName, String mechUser, String mechPasswd, int dmeTimeOut, long userExpiration, int highCount, int usageRefreshTriggerCount) throws CadiException {
        super(access, userExpiration, highCount, 2);
        this.access = access;
        this.dmeServiceName = dmeServiceName;
        this.headers = new HashMap();
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Requesting-MechID", mechUser);
        this.headers.put("Requesting-MechID-Password", mechPasswd);
        this.dmeTimeout = dmeTimeOut;
        this.userExpiration = userExpiration;
        this.supports = access.getProperty("aaf_domain_support", ".com").split("\\s*:\\s*");
    }

    protected abstract User<PERM> loadUser(Principal var1) throws Exception;

    protected abstract boolean isCorrectPermType(Permission var1);

    public boolean supports(String userName) {
        if (userName != null) {
            for (String s : this.supports) {
                if (!userName.endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean fish(Principal bait, Permission pond) {
        if (this.supports(bait.getName())) {
            User<PERM> user = this.getUser(bait);
            if (user == null) {
                try {
                    user = this.loadUser(bait);
                }
                catch (Exception e) {
                    this.access.log(e, new Object[]{"Failure to load from AAF Service"});
                }
            }
            return user == null ? false : user.contains(pond);
        }
        return false;
    }

    public void fishAll(Principal bait, List<Permission> perms) {
        if (this.supports(bait.getName())) {
            User<PERM> user = this.getUser(bait);
            if (user == null) {
                try {
                    user = this.loadUser(bait);
                }
                catch (Exception e) {
                    this.access.log(e, new Object[]{"Failure to load from AAF Service"});
                }
            }
            if (user != null) {
                user.copyPermsTo(perms);
            }
        }
    }

    protected DME2Client newClient() throws CadiException {
        DME2Client sender;
        try {
            sender = new DME2Client(new URI(this.dmeServiceName), (long)this.dmeTimeout);
            DME2RestfulHandler replyHandler = new DME2RestfulHandler(this.dmeServiceName);
            sender.setReplyHandler((AsyncResponseHandlerIntf)replyHandler);
            sender.setAllowAllHttpReturnCodes(Boolean.valueOf(true));
        }
        catch (Exception e) {
            throw new CadiException((Throwable)e);
        }
        sender.setHeaders(this.headers);
        sender.setMethod("GET");
        return sender;
    }
}

